/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.label.object;

import gov.nasa.pds.objectAccess.table.BitFieldAdapter;
import gov.nasa.pds.objectAccess.table.DefaultFieldAdapter;
import gov.nasa.pds.objectAccess.table.DoubleBinaryFieldAdapter;
import gov.nasa.pds.objectAccess.table.FieldAdapter;
import gov.nasa.pds.objectAccess.table.FloatBinaryFieldAdapter;
import gov.nasa.pds.objectAccess.table.IntegerBinaryFieldAdapter;
import gov.nasa.pds.objectAccess.table.NumericTextFieldAdapter;
import java.util.HashMap;
import java.util.Map;

public enum FieldType {
    ASCII_ANYURI("ASCII_AnyURI"),
    ASCII_BIBCODE("ASCII_BibCode"),
    ASCII_BOOLEAN("ASCII_Boolean", new DefaultFieldAdapter(), true),
    ASCII_DOI("ASCII_DOI"),
    ASCII_DATE("ASCII_Date"),
    ASCII_DATE_DOY("ASCII_Date_DOY"),
    ASCII_DATE_TIME("ASCII_Date_Time"),
    ASCII_DATE_TIME_DOY("ASCII_Date_Time_DOY"),
    ASCII_DATE_TIME_DOY_UTC("ASCII_Date_Time_DOY_UTC"),
    ASCII_DATE_TIME_UTC("ASCII_Date_Time_UTC"),
    ASCII_DATE_TIME_YMD("ASCII_Date_Time_YMD"),
    ASCII_DATE_TIME_YMD_UTC("ASCII_Date_Time_YMD_UTC"),
    ASCII_DATE_YMD("ASCII_Date_YMD"),
    ASCII_DIRECTORY_PATH_NAME("ASCII_Directory_Path_Name"),
    ASCII_FILE_NAME("ASCII_File_Name"),
    ASCII_FILE_SPECIFICATION_NAME("ASCII_File_Specification_Name"),
    ASCII_INTEGER("ASCII_Integer", new NumericTextFieldAdapter(10), true),
    ASCII_LID("ASCII_LID"),
    ASCII_LIDVID("ASCII_LIDVID"),
    ASCII_LIDVID_LID("ASCII_LIDVID_LID"),
    ASCII_MD5_CHECKSUM("ASCII_MD5_Checksum"),
    ASCII_NONNEGATIVE_INTEGER("ASCII_NonNegative_Integer", new NumericTextFieldAdapter(10), true),
    ASCII_NUMERIC_BASE16("ASCII_Numeric_Base16", new NumericTextFieldAdapter(16), true),
    ASCII_NUMERIC_BASE2("ASCII_Numeric_Base2", new NumericTextFieldAdapter(2), true),
    ASCII_NUMERIC_BASE8("ASCII_Numeric_Base8", new NumericTextFieldAdapter(8), true),
    ASCII_REAL("ASCII_Real", new NumericTextFieldAdapter(10), true),
    ASCII_STRING("ASCII_String"),
    ASCII_TIME("ASCII_Time"),
    ASCII_VID("ASCII_VID"),
    COMPLEXLSB16("ComplexLSB16"),
    COMPLEXLSB8("ComplexLSB8"),
    COMPLEXMSB16("ComplexMSB16"),
    COMPLEXMSB8("ComplexMSB8"),
    IEEE754LSBDOUBLE("IEEE754LSBDouble", new DoubleBinaryFieldAdapter(false), true),
    IEEE754LSBSINGLE("IEEE754LSBSingle", new FloatBinaryFieldAdapter(false), true),
    IEEE754MSBDOUBLE("IEEE754MSBDouble", new DoubleBinaryFieldAdapter(true), true),
    IEEE754MSBSINGLE("IEEE754MSBSingle", new FloatBinaryFieldAdapter(true), true),
    SIGNEDBYTE("SignedByte", new IntegerBinaryFieldAdapter(1, true, true), true),
    SIGNEDLSB2("SignedLSB2", new IntegerBinaryFieldAdapter(2, true, false), true),
    SIGNEDLSB4("SignedLSB4", new IntegerBinaryFieldAdapter(4, true, false), true),
    SIGNEDLSB8("SignedLSB8", new IntegerBinaryFieldAdapter(8, true, false), true),
    SIGNEDMSB2("SignedMSB2", new IntegerBinaryFieldAdapter(2, true, true), true),
    SIGNEDMSB4("SignedMSB4", new IntegerBinaryFieldAdapter(4, true, true), true),
    SIGNEDMSB8("SignedMSB8", new IntegerBinaryFieldAdapter(8, true, true), true),
    UTF8_STRING("UTF8_String"),
    UNSIGNEDBYTE("UnsignedByte", new IntegerBinaryFieldAdapter(1, false, true), true),
    UNSIGNEDLSB2("UnsignedLSB2", new IntegerBinaryFieldAdapter(2, false, false), true),
    UNSIGNEDLSB4("UnsignedLSB4", new IntegerBinaryFieldAdapter(4, false, false), true),
    UNSIGNEDLSB8("UnsignedLSB8", new IntegerBinaryFieldAdapter(8, false, false), true),
    UNSIGNEDMSB2("UnsignedMSB2", new IntegerBinaryFieldAdapter(2, false, true), true),
    UNSIGNEDMSB4("UnsignedMSB4", new IntegerBinaryFieldAdapter(4, false, true), true),
    UNSIGNEDMSB8("UnsignedMSB8", new IntegerBinaryFieldAdapter(8, false, true), true),
    SIGNEDBITSTRING("SignedBitString", new BitFieldAdapter(true), true),
    UNSIGNEDBITSTRING("UnsignedBitString", new BitFieldAdapter(false), true),
    UNKNOWN("Unknown", new DefaultFieldAdapter(), true);

    private static Map<String, FieldType> xmlTypeMap;
    private String xmlType;
    private FieldAdapter adapter;
    private boolean isRightJustified;

    private FieldType(String xmlType) {
        this(xmlType, new DefaultFieldAdapter(), false);
    }

    private FieldType(String xmlType, FieldAdapter adapter, boolean isRightJustified) {
        this.xmlType = xmlType;
        this.adapter = adapter;
        this.isRightJustified = isRightJustified;
    }

    public static FieldType getFieldType(String xmlType) {
        FieldType type = xmlTypeMap.get(xmlType);
        if (type == null) {
            throw new IllegalArgumentException("No field type definition found for XML type (" + xmlType + ")");
        }
        return type;
    }

    public String getXMLType() {
        return this.xmlType;
    }

    public FieldAdapter getAdapter() {
        return this.adapter;
    }

    public boolean isRightJustified() {
        return this.isRightJustified;
    }

    static {
        xmlTypeMap = new HashMap<String, FieldType>();
        for (FieldType fieldType : FieldType.values()) {
            xmlTypeMap.put(fieldType.getXMLType(), fieldType);
        }
    }
}

