/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.pds4;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.pds4.BaseTable;
import uk.ac.starlink.pds4.Field;
import uk.ac.starlink.pds4.FieldReader;
import uk.ac.starlink.pds4.Group;
import uk.ac.starlink.pds4.Pds4StarTable;
import uk.ac.starlink.pds4.RecordItem;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.URLUtils;

public class BasePds4StarTable
extends Pds4StarTable {
    private final int ncol_;
    private final int recordLength_;
    private final ColumnReader[] colRdrs_;
    private final ByteBuffer dataBuf_;
    private final byte[] randomRecord_;
    private int randomIndex_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.pds4");

    public BasePds4StarTable(BaseTable table, URI contextUri) throws IOException {
        super(table, contextUri);
        this.recordLength_ = Tables.checkedLongToInt(table.getRecordLength());
        this.colRdrs_ = BasePds4StarTable.createColumnReaders(table.getContents());
        this.ncol_ = this.colRdrs_.length;
        this.dataBuf_ = this.getDataBuffer();
        this.randomIndex_ = -1;
        this.randomRecord_ = new byte[this.recordLength_];
    }

    @Override
    public int getColumnCount() {
        return this.ncol_;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.colRdrs_[icol].getInfo();
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        final InputStream in = this.getDataStream();
        final long nrow = this.getRowCount();
        return new RowSequence(){
            long irow_;
            final byte[] record_;
            {
                this.record_ = new byte[BasePds4StarTable.this.recordLength_];
            }

            @Override
            public boolean next() throws IOException {
                int ioff;
                int nb;
                if (this.irow_ >= nrow) {
                    return false;
                }
                for (ioff = 0; ioff < BasePds4StarTable.this.recordLength_; ioff += nb) {
                    nb = in.read(this.record_, ioff, BasePds4StarTable.this.recordLength_ - ioff);
                    if (nb >= 0) continue;
                    return false;
                }
                if (ioff == BasePds4StarTable.this.recordLength_) {
                    ++this.irow_;
                    return true;
                }
                throw new IOException("EOF midway through record");
            }

            @Override
            public Object getCell(int icol) {
                this.checkRow();
                return BasePds4StarTable.this.colRdrs_[icol].readField(this.record_);
            }

            @Override
            public Object[] getRow() {
                this.checkRow();
                Object[] row = new Object[BasePds4StarTable.this.ncol_];
                for (int icol = 0; icol < BasePds4StarTable.this.ncol_; ++icol) {
                    row[icol] = BasePds4StarTable.this.colRdrs_[icol].readField(this.record_);
                }
                return row;
            }

            @Override
            public void close() throws IOException {
                in.close();
            }

            void checkRow() {
                if (this.irow_ == 0L) {
                    throw new IllegalStateException("No current row");
                }
            }
        };
    }

    @Override
    public boolean isRandom() {
        return this.dataBuf_ != null;
    }

    @Override
    public synchronized Object[] getRow(long lrow) throws IOException {
        this.readRecord(lrow);
        Object[] row = new Object[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            row[icol] = this.colRdrs_[icol].readField(this.randomRecord_);
        }
        return row;
    }

    @Override
    public synchronized Object getCell(long lrow, int icol) throws IOException {
        this.readRecord(lrow);
        return this.colRdrs_[icol].readField(this.randomRecord_);
    }

    @Override
    public RowAccess getRowAccess() throws IOException {
        final ByteBuffer dbuf = this.dataBuf_.duplicate();
        final byte[] record = new byte[this.recordLength_];
        return new RowAccess(){

            @Override
            public void setRowIndex(long lrow) {
                dbuf.position(BasePds4StarTable.this.recordLength_ * Tables.checkedLongToInt(lrow));
                dbuf.get(record);
            }

            @Override
            public Object[] getRow() {
                Object[] row = new Object[BasePds4StarTable.this.ncol_];
                for (int icol = 0; icol < BasePds4StarTable.this.ncol_; ++icol) {
                    row[icol] = BasePds4StarTable.this.colRdrs_[icol].readField(record);
                }
                return row;
            }

            @Override
            public Object getCell(int icol) {
                return BasePds4StarTable.this.colRdrs_[icol].readField(record);
            }

            @Override
            public void close() {
            }
        };
    }

    private synchronized void readRecord(long lrow) {
        int irow = Tables.checkedLongToInt(lrow);
        if (irow != this.randomIndex_) {
            this.dataBuf_.position(this.recordLength_ * irow);
            this.dataBuf_.get(this.randomRecord_);
            this.randomIndex_ = irow;
        }
    }

    private ByteBuffer getDataBuffer() throws IOException {
        File file = URLUtils.urlToFile(this.getDataUrl().toString());
        if (file == null || !file.canRead()) {
            return null;
        }
        long size = this.getRowCount() * (long)this.recordLength_;
        if (size > Integer.MAX_VALUE) {
            return null;
        }
        int isize = (int)size;
        try {
            FileChannel channel = new FileInputStream(file).getChannel();
            return channel.map(FileChannel.MapMode.READ_ONLY, this.getDataOffset(), isize);
        }
        catch (IOException e) {
            logger_.log(Level.INFO, "Failed to map file: " + file, e);
            return null;
        }
    }

    private static ColumnReader[] createColumnReaders(RecordItem[] items) {
        ArrayList<ColumnReader> list = new ArrayList<ColumnReader>();
        for (RecordItem item : items) {
            Group group;
            if (item instanceof Field) {
                list.add(new ScalarColumnReader((Field)item));
                continue;
            }
            if (!(item instanceof Group) || (group = (Group)item).getRepetitions() <= 0) continue;
            for (RecordItem subItem : group.getContents()) {
                if (subItem instanceof Field) {
                    Field field = (Field)subItem;
                    FieldReader<?, ?> frdr = FieldReader.getInstance(field.getFieldType(), field.getBlankConstants());
                    list.add(BasePds4StarTable.createVectorColumnReader(field, group, frdr));
                    continue;
                }
                if (!(subItem instanceof Group)) continue;
                logger_.warning("Omit nested group");
            }
        }
        return list.toArray(new ColumnReader[0]);
    }

    private static <S, A> VectorColumnReader<S, A> createVectorColumnReader(Field field, Group group, FieldReader<S, A> fieldReader) {
        return new VectorColumnReader<S, A>(field, group, fieldReader);
    }

    private static class VectorColumnReader<S, A>
    implements ColumnReader {
        final FieldReader<S, A> fieldReader_;
        final ColumnInfo info_;
        final int offset0_;
        final int length_;
        final int step_;
        final int nrep_;
        final int startBit_;
        final int endBit_;

        VectorColumnReader(Field field, Group group, FieldReader<S, A> fieldReader) {
            this.fieldReader_ = fieldReader;
            this.nrep_ = group.getRepetitions();
            this.offset0_ = group.getGroupLocation() - 1 + field.getFieldLocation() - 1;
            this.length_ = field.getFieldLength();
            this.step_ = group.getGroupLength() / this.nrep_;
            this.info_ = Pds4StarTable.createColumnInfo(field, this.fieldReader_.getArrayClass());
            this.info_.setShape(new int[]{this.nrep_});
            this.startBit_ = 0;
            this.endBit_ = 0;
        }

        @Override
        public ColumnInfo getInfo() {
            return this.info_;
        }

        public A readField(byte[] record) {
            A array = this.fieldReader_.createArray(this.nrep_);
            for (int i = 0; i < this.nrep_; ++i) {
                this.fieldReader_.readElement(record, this.offset0_ + i * this.step_, this.length_, this.startBit_, this.endBit_, array, i);
            }
            return array;
        }
    }

    private static class ScalarColumnReader
    implements ColumnReader {
        final FieldReader<?, ?> fieldReader_;
        final int offset_;
        final int length_;
        final ColumnInfo info_;
        final int startBit_;
        final int endBit_;

        ScalarColumnReader(Field field) {
            this.fieldReader_ = FieldReader.getInstance(field.getFieldType(), field.getBlankConstants());
            this.offset_ = field.getFieldLocation() - 1;
            this.length_ = field.getFieldLength();
            this.info_ = Pds4StarTable.createColumnInfo(field, this.fieldReader_.getScalarClass());
            this.startBit_ = 0;
            this.endBit_ = 0;
        }

        @Override
        public ColumnInfo getInfo() {
            return this.info_;
        }

        @Override
        public Object readField(byte[] record) {
            return this.fieldReader_.readScalar(record, this.offset_, this.length_, this.startBit_, this.endBit_);
        }
    }

    private static interface ColumnReader {
        public ColumnInfo getInfo();

        public Object readField(byte[] var1);
    }
}

