/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.pds4;

import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.starlink.pds4.BasePds4StarTable;
import uk.ac.starlink.pds4.BaseTable;
import uk.ac.starlink.pds4.DelimitedPds4StarTable;
import uk.ac.starlink.pds4.DelimitedTable;
import uk.ac.starlink.pds4.Label;
import uk.ac.starlink.pds4.LabelParser;
import uk.ac.starlink.pds4.Table;
import uk.ac.starlink.pds4.TableType;
import uk.ac.starlink.table.MultiTableBuilder;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.formats.DocumentedIOHandler;
import uk.ac.starlink.table.formats.DocumentedTableBuilder;
import uk.ac.starlink.util.ConfigMethod;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;

public class Pds4TableBuilder
extends DocumentedTableBuilder
implements MultiTableBuilder {
    private boolean checkMagic_ = true;
    private boolean observationalOnly_ = false;
    private String[] blankSpecials_ = LabelParser.DEFAULT_BLANK_SPECIALS;
    private static final Collection<String> MAGIC_NAMESPACES = new HashSet<String>(Arrays.asList("http://pds.nasa.gov/pds4/pds/v1"));
    private static final Collection<String> MAGIC_ELEMENTS = new HashSet<String>(Arrays.asList("Product_Ancillary", "Product_Browse", "Product_Bundle", "Product_Collection", "Product_Context", "Product_Document", "Product_File_Text", "Product_Native", "Product_Observational", "Product_SPICE_Kernel", "Product_Thumbnail", "Product_XML_Schema", "Product_Zipped"));

    public Pds4TableBuilder() {
        super(new String[]{".lblx"});
    }

    @Override
    public String getFormatName() {
        return "PDS4";
    }

    @Override
    public String getXmlDescription() {
        return String.join((CharSequence)"\n", "<p>NASA's Planetary Data System version 4 format is described at", DocumentedIOHandler.toLink("https://pds.nasa.gov/datastandards/") + ".", "This implementation is based on v1.16.0 of PDS4.", "</p>", "<p>PDS4 files consist of an XML <em>Label</em> file which", "provides detailed metadata, and which may also contain references", "to external data files stored alongside it.", "This input handler looks for (binary, character or delimited)", "tables in the Label;", "depending on the configuration it may restrict them to those", "in the <code>File_Area_Observational</code> area.", "The Label is the file which has to be presented to this", "input handler to read the table data.", "Because of the relationship between the label and the data files,", "it is usually necessary to move them around together.", "</p>", "<p>If there are multiple tables in the label,", "you can refer to an individual one using the \"<code>#</code>\"", "specifier after the label file name by table <code>name</code>,", "<code>local_identifier</code>, or 1-based index", "(e.g. \"<code>label.xml#1</code>\" refers to the first table).", "</p>", "<p>If there are <code>Special_Constants</code> defined", "in the label, they are in most cases interpreted as blank values", "in the output table data.", "At present, the following special values are interpreted", "as blanks:", Arrays.stream(this.blankSpecials_).map(s -> "  <code>" + s + "</code>").collect(Collectors.joining(",\n")), ".", "</p>", "<p>Fields within top-level Groups are interpreted", "as array values.", "Any fields in nested groups are ignored.", "For these array values only limited null-value substitution", "can be done (since array elements are primitives and so cannot", "take null values).", "</p>", "<p>This input handler is somewhat experimental,", "and the author is not a PDS expert.", "If it behaves strangely or you have suggestions for how it", "could work better, please contact the author.", "</p>", "");
    }

    @Override
    public boolean docIncludesExample() {
        return false;
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    @Override
    public boolean canStream() {
        return false;
    }

    @ConfigMethod(property="checkmagic", doc="<p>Determines whether an initial test is made to see whether\nthe file looks like PDS4 before attempting to read it as one.\nThe tests are ad-hoc and look for certain elements\nand namespaces that are expected to appear near the start of\na table-containing PDS4 file, but it's not bulletproof.\nSetting this true is generally a good idea\nto avoid attempting to parse non-PDS4 files,\nbut you can set it false to attempt to read an PDS4 file\nthat starts with the wrong sequence.\n</p>", example="false")
    public void setCheckMagic(boolean checkMagic) {
        this.checkMagic_ = checkMagic;
    }

    public boolean getCheckMagic() {
        return this.checkMagic_;
    }

    @ConfigMethod(property="observational", doc="<p>Determines whether only tables within a\n<code>&lt;File_Area_Observational&gt;</code> element\nof the PDS4 label should be included.\nIf true, only observational tables are found,\nif false, other tables will be found as well.\n</p>", example="true")
    public void setObservationalOnly(boolean observationalOnly) {
        this.observationalOnly_ = observationalOnly;
    }

    public boolean getObservationalOnly() {
        return this.observationalOnly_;
    }

    @Override
    public void streamStarTable(InputStream in, TableSink sink, String pos) throws TableFormatException {
        throw new TableFormatException("Can't stream");
    }

    @Override
    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storage) throws IOException {
        String pos = datsrc.getPosition();
        boolean ifile = false;
        Label label = this.parseLabel(datsrc);
        Table[] tables = label.getTables();
        if (tables.length == 0) {
            throw new TableFormatException("No tables in PDS4 label");
        }
        Table table = pos != null && pos.trim().length() > 0 ? this.getPositionedTable(tables, pos.trim()) : tables[0];
        return this.createStarTable(table, label.getContextUri());
    }

    @Override
    public TableSequence makeStarTables(DataSource datsrc, StoragePolicy storage) throws IOException {
        Label label = this.parseLabel(datsrc);
        final URI contextUri = label.getContextUri();
        final Table[] tables = label.getTables();
        return new TableSequence(){
            int iNext_;

            @Override
            public StarTable nextTable() throws IOException {
                return this.iNext_ < tables.length ? Pds4TableBuilder.this.createStarTable(tables[this.iNext_++], contextUri) : null;
            }
        };
    }

    public static boolean isMagic(byte[] intro) {
        String content;
        if (intro.length < 32) {
            return false;
        }
        try {
            content = new String(intro, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false);
            content = "";
        }
        for (String tagName : MAGIC_ELEMENTS) {
            if (!content.contains("<" + tagName)) continue;
            return true;
        }
        for (String ns : MAGIC_NAMESPACES) {
            if (!content.contains(ns)) continue;
            return true;
        }
        MagicHandler handler = new MagicHandler();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse((InputStream)new ByteArrayInputStream(intro), (DefaultHandler)handler);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        return handler.isPds4();
    }

    private Label parseLabel(DataSource datsrc) throws IOException {
        if (!this.checkMagic_ || Pds4TableBuilder.isMagic(datsrc.getIntro())) {
            LabelParser parser = new LabelParser(this.observationalOnly_, this.blankSpecials_);
            if (datsrc instanceof FileDataSource) {
                return parser.parseLabel(((FileDataSource)datsrc).getFile());
            }
            return parser.parseLabel(datsrc.getURL());
        }
        throw new TableFormatException("Not a PDS4 label file");
    }

    private StarTable createStarTable(Table table, URI contextUri) throws IOException {
        TableType ttype = table.getTableType();
        if (table instanceof BaseTable) {
            return new BasePds4StarTable((BaseTable)table, contextUri);
        }
        if (table instanceof DelimitedTable) {
            return new DelimitedPds4StarTable((DelimitedTable)table, contextUri);
        }
        assert (false);
        throw new TableFormatException("what?");
    }

    private Table getPositionedTable(Table[] tables, String pos) throws TableFormatException {
        int nt = tables.length;
        try {
            int jpos = Integer.parseInt(pos);
            if (jpos > 0 && jpos <= nt) {
                return tables[jpos - 1];
            }
            String msg = "Table index " + pos + " out of range 1-" + nt;
            throw new TableFormatException(msg);
        }
        catch (RuntimeException runtimeException) {
            for (Table table : tables) {
                if (!pos.equalsIgnoreCase(table.getName()) && !pos.equalsIgnoreCase(table.getLocalIdentifier())) continue;
                return table;
            }
            throw new TableFormatException("No table in label matching position \"" + pos + "\"");
        }
    }

    private static class MagicHandler
    extends DefaultHandler {
        boolean isPds4_;

        private MagicHandler() {
        }

        boolean isPds4() {
            return this.isPds4_;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            if (MAGIC_ELEMENTS.contains(localName) || MAGIC_ELEMENTS.contains(qName)) {
                this.isPds4_ = true;
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            if (MAGIC_NAMESPACES.contains(uri)) {
                this.isPds4_ = true;
            }
        }

        @Override
        public void processingInstruction(String target, String data) {
            if (data != null && data.indexOf("pds.nasa.gov/pds4") >= 0) {
                this.isPds4_ = true;
            }
        }
    }
}

