/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.pds4;

import gov.nasa.pds.objectAccess.table.FieldAdapter;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SafeFieldAdapter
implements FieldAdapter {
    private final FieldAdapter base_;
    private int nWarn_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.pds4");

    public SafeFieldAdapter(FieldAdapter base) {
        this.base_ = base;
    }

    @Override
    public byte getByte(byte[] buf, int offset, int length, int startBit, int stopBit) {
        try {
            return this.base_.getByte(buf, offset, length, startBit, stopBit);
        }
        catch (RuntimeException e) {
            this.reportError(e, "0");
            return 0;
        }
    }

    @Override
    public short getShort(byte[] buf, int offset, int length, int startBit, int stopBit) {
        try {
            return this.base_.getShort(buf, offset, length, startBit, stopBit);
        }
        catch (RuntimeException e) {
            this.reportError(e, "0");
            return 0;
        }
    }

    @Override
    public int getInt(byte[] buf, int offset, int length, int startBit, int stopBit) {
        try {
            return this.base_.getInt(buf, offset, length, startBit, stopBit);
        }
        catch (RuntimeException e) {
            this.reportError(e, "0");
            return 0;
        }
    }

    @Override
    public long getLong(byte[] buf, int offset, int length, int startBit, int stopBit) {
        try {
            return this.base_.getLong(buf, offset, length, startBit, stopBit);
        }
        catch (RuntimeException e) {
            this.reportError(e, "0");
            return 0L;
        }
    }

    @Override
    public BigInteger getBigInteger(byte[] buf, int offset, int length, int startBit, int stopBit) {
        try {
            return this.base_.getBigInteger(buf, offset, length, startBit, stopBit);
        }
        catch (RuntimeException e) {
            this.reportError(e, "null");
            return null;
        }
    }

    @Override
    public float getFloat(byte[] buf, int offset, int length, int startBit, int stopBit) {
        try {
            return this.base_.getFloat(buf, offset, length, startBit, stopBit);
        }
        catch (RuntimeException e) {
            this.reportError(e, "NaN");
            return Float.NaN;
        }
    }

    @Override
    public double getDouble(byte[] buf, int offset, int length, int startBit, int stopBit) {
        try {
            return this.base_.getDouble(buf, offset, length, startBit, stopBit);
        }
        catch (RuntimeException e) {
            this.reportError(e, "NaN");
            return Double.NaN;
        }
    }

    @Override
    public String getString(byte[] buf, int offset, int length, int startBit, int stopBit) {
        try {
            return this.base_.getString(buf, offset, length, startBit, stopBit);
        }
        catch (RuntimeException e) {
            this.reportError(e, "null");
            return null;
        }
    }

    @Override
    public String getString(byte[] buf, int offset, int length, int startBit, int stopBit, Charset charset) {
        try {
            return this.base_.getString(buf, offset, length, startBit, stopBit, charset);
        }
        catch (RuntimeException e) {
            this.reportError(e, "null");
            return null;
        }
    }

    @Override
    public void setString(String value, int offset, int length, ByteBuffer buf, boolean isRightJustified) {
        this.base_.setString(value, offset, length, buf, isRightJustified);
    }

    @Override
    public void setString(String value, int offset, int length, ByteBuffer buf, boolean isRightJustified, Charset charset) {
        this.base_.setString(value, offset, length, buf, isRightJustified, charset);
    }

    @Override
    public void setInt(int value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        this.base_.setInt(value, offset, length, buffer, isRightJustified);
    }

    @Override
    public void setDouble(double value, int offset, int length, ByteBuffer buf, boolean isRightJustified) {
        this.base_.setDouble(value, offset, length, buf, isRightJustified);
    }

    @Override
    public void setFloat(float value, int offset, int length, ByteBuffer buf, boolean isRightJustified) {
        this.base_.setFloat(value, offset, length, buf, isRightJustified);
    }

    @Override
    public void setShort(short value, int offset, int length, ByteBuffer buf, boolean isRightJustified) {
        this.base_.setShort(value, offset, length, buf, isRightJustified);
    }

    @Override
    public void setByte(byte value, int offset, int length, ByteBuffer buf, boolean isRightJustified) {
        this.base_.setByte(value, offset, length, buf, isRightJustified);
    }

    @Override
    public void setLong(long value, int offset, int length, ByteBuffer buf, boolean isRightJustified) {
        this.base_.setLong(value, offset, length, buf, isRightJustified);
    }

    @Override
    public void setBigInteger(BigInteger value, int offset, int length, ByteBuffer buf, boolean isRightJustified) {
        this.base_.setBigInteger(value, offset, length, buf, isRightJustified);
    }

    private void reportError(RuntimeException e, String dfltValue) {
        if (this.nWarn_ == 0) {
            String msg = "PDS4 library code failed at least once during read, using default value " + dfltValue;
            logger_.log(Level.WARNING, msg, e);
        }
        ++this.nWarn_;
    }
}

