/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.parquet;

import java.io.IOException;
import java.util.Arrays;
import java.util.function.LongSupplier;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnReadStore;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.column.impl.ColumnReaderImpl;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.schema.MessageType;
import uk.ac.starlink.parquet.Decoder;
import uk.ac.starlink.parquet.InputColumn;
import uk.ac.starlink.parquet.ParquetStarTable;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.util.IOSupplier;

public class SequentialParquetStarTable
extends ParquetStarTable {
    public SequentialParquetStarTable(IOSupplier<ParquetFileReader> pfrSupplier, ParquetStarTable.Config config) throws IOException {
        super(pfrSupplier, config);
    }

    @Override
    public boolean isRandom() {
        return false;
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        return new ParquetRowSplittable();
    }

    @Override
    public RowSplittable getRowSplittable() throws IOException {
        return new ParquetRowSplittable();
    }

    private static long[] getBlockSizes(ParquetFileReader pfr) {
        return pfr.getRowGroups().stream().mapToLong(blk -> blk.getRowCount()).toArray();
    }

    private static <T> ColAccess<T> createColAccess(ColumnReadStore crstore, InputColumn<T> incol) {
        ColumnDescriptor cdesc = incol.getColumnDescriptor();
        final int cdefmax = cdesc.getMaxDefinitionLevel();
        final Decoder decoder = incol.createDecoder();
        final ColumnReader crdr = crstore.getColumnReader(cdesc);
        final Runnable readValue = crdr instanceof ColumnReaderImpl ? () -> SequentialParquetStarTable.lambda$createColAccess$1((ColumnReaderImpl)crdr) : () -> {
            decoder.clearValue();
            decoder.readItem(crdr);
        };
        return new ColAccess<T>(){
            private boolean hasValue_;
            private T value_;

            @Override
            public void clear() {
                this.hasValue_ = false;
            }

            @Override
            public void skip(long n) {
                for (long i = 0L; i < n; ++i) {
                    do {
                        if (crdr.getCurrentDefinitionLevel() == cdefmax) {
                            readValue.run();
                        }
                        crdr.consume();
                    } while (crdr.getCurrentRepetitionLevel() > 0);
                }
            }

            @Override
            public T read() {
                if (!this.hasValue_) {
                    decoder.clearValue();
                    do {
                        int cdef;
                        if ((cdef = crdr.getCurrentDefinitionLevel()) == cdefmax) {
                            decoder.readItem(crdr);
                        } else if (cdef == cdefmax - 1) {
                            decoder.readNull();
                        }
                        crdr.consume();
                    } while (crdr.getCurrentRepetitionLevel() > 0);
                    this.value_ = decoder.getValue();
                    this.hasValue_ = true;
                }
                return this.value_;
            }
        };
    }

    private static /* synthetic */ void lambda$createColAccess$1(ColumnReaderImpl rec$) {
        rec$.readValue();
    }

    private static interface ColAccess<T> {
        public void clear();

        public void skip(long var1);

        public T read();
    }

    private class ParquetRowSplittable
    implements RowSplittable {
        final ParquetFileReader pfr_;
        final int ncol_;
        final MessageType schema_;
        final long[] irows_;
        final long[] blockSizes_;
        int iblock_;
        int iblockEnd_;
        ColAccess<?>[] colAccesses_;
        long irow_;
        long irGroupEnd_;

        public ParquetRowSplittable() throws IOException {
            this(-1, -1);
        }

        private ParquetRowSplittable(int iblock, int iblockEnd) throws IOException {
            this.pfr_ = SequentialParquetStarTable.this.getParquetFileReader();
            this.ncol_ = SequentialParquetStarTable.this.getColumnCount();
            this.schema_ = SequentialParquetStarTable.this.getSchema();
            this.blockSizes_ = SequentialParquetStarTable.getBlockSizes(this.pfr_);
            this.irows_ = new long[this.ncol_];
            this.iblock_ = -1;
            this.irow_ = -1L;
            this.iblockEnd_ = iblockEnd >= 0 ? iblockEnd : this.blockSizes_.length;
            this.skipBlocks(iblock + 1);
        }

        @Override
        public LongSupplier rowIndex() {
            return () -> this.irow_;
        }

        public ParquetRowSplittable split() {
            if (this.colAccesses_ == null && this.iblockEnd_ - this.iblock_ > 2) {
                ParquetRowSplittable split;
                int mid = (1 + this.iblock_ + this.iblockEnd_) / 2;
                try {
                    split = new ParquetRowSplittable(this.iblock_, mid);
                    this.skipBlocks(mid - 1 - this.iblock_);
                }
                catch (IOException e) {
                    return null;
                }
                return split;
            }
            return null;
        }

        public long splittableSize() {
            long nr = 0L;
            for (int ib = this.iblock_ + 1; ib < this.iblockEnd_; ++ib) {
                nr += this.blockSizes_[ib];
            }
            return nr;
        }

        @Override
        public boolean next() throws IOException {
            assert (this.irow_ < this.irGroupEnd_);
            if (this.irow_ + 1L == this.irGroupEnd_) {
                assert (this.iblock_ < this.iblockEnd_);
                if (this.iblock_ + 1 == this.iblockEnd_) {
                    return false;
                }
                this.nextReadStore();
                Arrays.fill(this.irows_, this.irow_);
            }
            ++this.irow_;
            return true;
        }

        @Override
        public Object getCell(int icol) {
            ColAccess<?> colAccess;
            try {
                colAccess = this.colAccesses_[icol];
            }
            catch (NullPointerException e) {
                throw new IllegalStateException("next() not called");
            }
            long nadv = this.irow_ - this.irows_[icol];
            if (nadv > 0L) {
                if (nadv > 1L) {
                    colAccess.skip(nadv - 1L);
                }
                colAccess.clear();
            }
            this.irows_[icol] = this.irow_;
            return colAccess.read();
        }

        @Override
        public Object[] getRow() {
            Object[] row = new Object[this.ncol_];
            for (int ic = 0; ic < this.ncol_; ++ic) {
                row[ic] = this.getCell(ic);
            }
            return row;
        }

        @Override
        public void close() throws IOException {
            this.pfr_.close();
        }

        private boolean nextReadStore() throws IOException {
            PageReadStore pageStore = this.pfr_.readNextRowGroup();
            if (pageStore == null) {
                return false;
            }
            ++this.iblock_;
            assert (pageStore.getRowCount() == this.blockSizes_[this.iblock_]);
            this.irGroupEnd_ += pageStore.getRowCount();
            ColumnReadStore crstore = SequentialParquetStarTable.this.getColumnReadStore(pageStore, this.schema_);
            this.colAccesses_ = new ColAccess[this.ncol_];
            for (int ic = 0; ic < this.ncol_; ++ic) {
                this.colAccesses_[ic] = SequentialParquetStarTable.createColAccess(crstore, SequentialParquetStarTable.this.getInputColumn(ic));
            }
            return true;
        }

        private void skipBlocks(int nb) throws IOException {
            for (int ib = 0; ib < nb; ++ib) {
                if (!this.pfr_.skipNextRowGroup()) {
                    throw new IOException("Failed to skip row group");
                }
                ++this.iblock_;
                long nr = this.blockSizes_[this.iblock_];
                this.irow_ += nr;
                this.irGroupEnd_ += nr;
            }
        }
    }
}

