/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.hints;

import com.jidesoft.hints.AbstractListIntelliHints;
import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class FileIntelliHints
extends AbstractListIntelliHints {
    private boolean _folderOnly = false;
    private boolean _showFullPath = true;
    private FilenameFilter _filter;

    public FileIntelliHints(JTextComponent comp) {
        super(comp);
    }

    public boolean isFolderOnly() {
        return this._folderOnly;
    }

    public void setFolderOnly(boolean folderOnly) {
        this._folderOnly = folderOnly;
    }

    public boolean isShowFullPath() {
        return this._showFullPath;
    }

    public void setShowFullPath(boolean showFullPath) {
        this._showFullPath = showFullPath;
    }

    public boolean updateHints(Object value) {
        String prefix;
        int index2;
        if (value == null) {
            return false;
        }
        String s = value.toString();
        if (s.length() == 0) {
            return false;
        }
        int index1 = s.lastIndexOf(92);
        int index = Math.max(index1, index2 = s.lastIndexOf(47));
        if (index == -1) {
            return false;
        }
        String dir = s.substring(0, index + 1);
        Object[] files = new File(dir).list(new FilenameFilter(prefix = index == s.length() - 1 ? null : s.substring(index + 1).toLowerCase()){
            final /* synthetic */ String val$prefix;
            {
                this.val$prefix = string;
            }

            public boolean accept(File dir, String name) {
                boolean result;
                if (FileIntelliHints.this.isFolderOnly() && new File(dir.getAbsolutePath() + File.separator + name).isFile()) {
                    return false;
                }
                boolean bl = result = this.val$prefix == null || name.toLowerCase().startsWith(this.val$prefix);
                if (result && FileIntelliHints.this.getFilter() != null) {
                    return FileIntelliHints.this.getFilter().accept(dir, name);
                }
                return result;
            }
        });
        if (files == null || files.length == 0 || files.length == 1 && files[0].equalsIgnoreCase(prefix)) {
            this.setListData(new String[0]);
            return false;
        }
        this.getList().setCellRenderer(new PrefixListCellRenderer(this.isShowFullPath() ? dir : ""));
        this.setListData(files);
        return true;
    }

    public void acceptHint(Object selected) {
        int index2;
        int caretPosition;
        if (selected == null) {
            return;
        }
        String selectedValue = "" + selected;
        String value = this.getTextComponent().getText();
        int index1 = value.lastIndexOf(92, caretPosition = this.getTextComponent().getCaretPosition());
        int index = Math.max(index1, index2 = value.lastIndexOf(47, caretPosition));
        if (index == -1) {
            return;
        }
        int prefixlen = caretPosition - index - 1;
        try {
            this.getTextComponent().getDocument().insertString(caretPosition, selectedValue.substring(prefixlen), null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public FilenameFilter getFilter() {
        return this._filter;
    }

    public void setFilter(FilenameFilter filter) {
        this._filter = filter;
    }

    private class PrefixListCellRenderer
    extends DefaultListCellRenderer {
        private String _prefix;

        public PrefixListCellRenderer(String prefix) {
            this._prefix = prefix;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent((JList<?>)list, this._prefix + value, index, isSelected, cellHasFocus);
        }
    }
}

