/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.FontUtils;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public class BasicStyledLabelUI
extends BasicLabelUI
implements SwingConstants {
    public static Comparator<StyleRange> _comparator;
    protected static BasicStyledLabelUI styledLabelUI;
    private final List<StyledText> _styledTexts = new ArrayList<StyledText>();
    private int _preferredRowCount = 1;
    private boolean _gettingPreferredSize;

    public static ComponentUI createUI(JComponent c) {
        return styledLabelUI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if ("styleRange".equals(e.getPropertyName())) {
            List<StyledText> list = this._styledTexts;
            synchronized (list) {
                this._styledTexts.clear();
            }
            if (e.getSource() instanceof StyledLabel) {
                ((StyledLabel)e.getSource()).revalidate();
                ((StyledLabel)e.getSource()).repaint();
            }
        } else if ("ignoreColorSettings".equals(e.getPropertyName()) && e.getSource() instanceof StyledLabel) {
            ((StyledLabel)e.getSource()).repaint();
        }
    }

    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        View v;
        View view = v = l != null ? (View)l.getClientProperty("html") : null;
        if (v != null) {
            super.paintEnabledText(l, g, s, textX, textY);
        } else {
            this.paintStyledText((StyledLabel)l, g, textX, textY);
        }
    }

    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        View v;
        View view = v = l != null ? (View)l.getClientProperty("html") : null;
        if (v != null) {
            super.paintDisabledText(l, g, s, textX, textY);
        } else {
            this.paintStyledText((StyledLabel)l, g, textX, textY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildStyledText(StyledLabel label) {
        List<StyledText> list = this._styledTexts;
        synchronized (list) {
            this._styledTexts.clear();
            StyleRange[] styleRanges = label.getStyleRanges();
            if (_comparator == null) {
                _comparator = new Comparator<StyleRange>(){

                    @Override
                    public int compare(StyleRange r1, StyleRange r2) {
                        if (r1.getStart() < r2.getStart()) {
                            return -1;
                        }
                        if (r1.getStart() > r2.getStart()) {
                            return 1;
                        }
                        return 0;
                    }
                };
            }
            Arrays.sort(styleRanges, _comparator);
            String s = label.getText();
            if (s != null && s.length() > 0) {
                int index = 0;
                for (StyleRange styleRange : styleRanges) {
                    String text;
                    if (index >= s.length()) break;
                    if (styleRange.getStart() > index) {
                        text = s.substring(index, Math.min(styleRange.getStart(), s.length()));
                        StyleRange newRange = new StyleRange(index, styleRange.getStart() - index, -1);
                        this.addStyledTexts(text, newRange, label);
                        index = styleRange.getStart();
                    }
                    if (styleRange.getStart() == index) {
                        if (styleRange.getLength() == -1) {
                            text = s.substring(index);
                            this.addStyledTexts(text, styleRange, label);
                            index = s.length();
                            continue;
                        }
                        text = s.substring(index, Math.min(index + styleRange.getLength(), s.length()));
                        this.addStyledTexts(text, styleRange, label);
                        index += styleRange.getLength();
                        continue;
                    }
                    if (styleRange.getStart() >= index) continue;
                }
                if (index < s.length()) {
                    String text = s.substring(index, s.length());
                    StyleRange range = new StyleRange(index, s.length() - index, -1);
                    this.addStyledTexts(text, range, label);
                }
            }
        }
    }

    private void addStyledTexts(String text, StyleRange range, StyledLabel label) {
        range = new StyleRange(range);
        int index1 = text.indexOf(13);
        int index2 = text.indexOf(10);
        while (index1 >= 0 || index2 >= 0) {
            int index;
            int n = index = index1 >= 0 ? index1 : -1;
            if (index2 >= 0 && (index2 < index1 || index < 0)) {
                index = index2;
            }
            String subString = text.substring(0, index);
            StyleRange newRange = new StyleRange(range);
            newRange.setStart(range.getStart());
            newRange.setLength(index);
            this._styledTexts.add(new StyledText(subString, newRange));
            int length = 1;
            if (text.charAt(index) == '\r' && index + 1 < text.length() && text.charAt(index + 1) == '\n') {
                ++length;
            }
            newRange = new StyleRange(range);
            newRange.setStart(range.getStart() + index);
            newRange.setLength(length);
            this._styledTexts.add(new StyledText(text.substring(index, index + length), newRange));
            text = text.substring(index + length);
            range.setStart(range.getStart() + index + length);
            range.setLength(range.getLength() - index - length);
            index1 = text.indexOf(13);
            index2 = text.indexOf(10);
        }
        if (text.length() > 0) {
            this._styledTexts.add(new StyledText(text, range));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize(JComponent c) {
        Dimension preferredSize;
        this._gettingPreferredSize = true;
        try {
            preferredSize = super.getPreferredSize(c);
        }
        finally {
            this._gettingPreferredSize = false;
        }
        return preferredSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        size = null;
        if (label instanceof StyledLabel) {
            oldPreferredWidth = ((StyledLabel)label).getPreferredWidth();
            oldRows = ((StyledLabel)label).getRows();
            try {
                if (((StyledLabel)label).isLineWrap() && label.getWidth() > 0) {
                    ((StyledLabel)label).setPreferredWidth(label.getWidth());
                }
                size = this.getPreferredSize((StyledLabel)label);
                if (oldPreferredWidth > 0 && oldPreferredWidth < label.getWidth()) {
                    ((StyledLabel)label).setPreferredWidth(oldPreferredWidth);
                    size = this.getPreferredSize((StyledLabel)label);
                }
                if (!((StyledLabel)label).isLineWrap() || ((StyledLabel)label).getMinRows() <= 0) ** GOTO lbl25
                ((StyledLabel)label).setPreferredWidth(0);
                ((StyledLabel)label).setRows(0);
                minSize = this.getPreferredSize((StyledLabel)label);
                if (minSize.height <= size.height) ** GOTO lbl25
                size = minSize;
            }
            finally {
                ((StyledLabel)label).setPreferredWidth(oldPreferredWidth);
                ((StyledLabel)label).setRows(oldRows);
            }
        } else {
            size = label.getPreferredSize();
        }
lbl25:
        // 5 sources

        textR.width = size.width;
        textR.height = size.height;
        if (label.getIcon() != null) {
            textR.width -= label.getIcon().getIconWidth() + label.getIconTextGap();
        }
        return BasicStyledLabelUI.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getPreferredSize(StyledLabel label) {
        this.buildStyledText(label);
        Font font = this.getFont(label);
        FontMetrics fm = label.getFontMetrics(font);
        int defaultFontSize = font.getSize();
        boolean lineWrap = label.isLineWrap() || label.getText() != null && (label.getText().contains("\r") || label.getText().contains("\n"));
        List<StyledText> list = this._styledTexts;
        synchronized (list) {
            int preferredWidth;
            FontMetrics fm2;
            StyledText[] texts = this._styledTexts.toArray(new StyledText[this._styledTexts.size()]);
            int maxRowHeight = fm.getHeight();
            for (StyledText styledText : texts) {
                StyleRange style = styledText.styleRange;
                int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / style.getFontShrinkRatio()) : defaultFontSize;
                font = this.getFont(label);
                int styleHeight = fm.getHeight();
                if (style != null && (style.getFontStyle() != -1 && font.getStyle() != style.getFontStyle() || font.getSize() != size)) {
                    font = FontUtils.getCachedDerivedFont(font, style.getFontStyle() == -1 ? font.getStyle() : style.getFontStyle(), size);
                    fm2 = label.getFontMetrics(font);
                    styleHeight = fm2.getHeight();
                }
                maxRowHeight = Math.max(maxRowHeight, ++styleHeight);
            }
            int naturalRowCount = 1;
            int nextRowStartIndex = 0;
            int width = 0;
            int maxWidth = 0;
            ArrayList<Integer> lineWidths = new ArrayList<Integer>();
            for (StyledText styledText : this._styledTexts) {
                StyleRange style = styledText.styleRange;
                int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / style.getFontShrinkRatio()) : defaultFontSize;
                font = this.getFont(label);
                String s = styledText.text.substring(nextRowStartIndex);
                if (s.startsWith("\r") || s.startsWith("\n")) {
                    lineWidths.add(width);
                    maxWidth = Math.max(width, maxWidth);
                    width = 0;
                    if (label.getMaxRows() <= 0 || ++naturalRowCount < label.getMaxRows()) continue;
                    break;
                }
                if (style != null && (style.getFontStyle() != -1 && font.getStyle() != style.getFontStyle() || font.getSize() != size)) {
                    font = FontUtils.getCachedDerivedFont(font, style.getFontStyle() == -1 ? font.getStyle() : style.getFontStyle(), size);
                    fm2 = label.getFontMetrics(font);
                    width += fm2.stringWidth(s);
                    continue;
                }
                width += fm.stringWidth(s);
            }
            lineWidths.add(width);
            int maxLineWidth = maxWidth = Math.max(width, maxWidth);
            this._preferredRowCount = naturalRowCount;
            if (lineWrap && label.getPreferredWidth() <= 0 && label.getRows() > 0) {
                maxWidth = this.getMaximumWidth(label, maxWidth, naturalRowCount, label.getRows());
            }
            if ((preferredWidth = label.getPreferredWidth()) > 0 && label.getInsets() != null) {
                preferredWidth -= label.getInsets().left + label.getInsets().right;
            }
            if (label.getIcon() != null && label.getHorizontalTextPosition() != 0) {
                preferredWidth -= label.getIcon().getIconWidth() + label.getIconTextGap();
            }
            if (lineWrap && preferredWidth > 0 && maxWidth > preferredWidth) {
                maxWidth = this.getLayoutWidth(label, preferredWidth);
            }
            if (lineWrap && label.getMaxRows() > 0 && this._preferredRowCount > label.getMaxRows()) {
                if (label.getPreferredWidth() <= 0) {
                    maxWidth = this.getMaximumWidth(label, maxWidth, naturalRowCount, label.getMaxRows());
                } else {
                    this._preferredRowCount = label.getMaxRows();
                }
            }
            if (lineWrap && label.getPreferredWidth() <= 0 && label.getMinRows() > 0 && this._preferredRowCount < label.getMinRows()) {
                maxWidth = this.getMaximumWidth(label, maxWidth, naturalRowCount, label.getMinRows());
            }
            if (this._gettingPreferredSize && label.getRows() > 0 && this._preferredRowCount > label.getRows() && (label.getPreferredWidth() <= 0 || label.getPreferredWidth() >= maxLineWidth)) {
                this._preferredRowCount = label.getRows();
                maxLineWidth = 0;
                for (int i = 0; i < lineWidths.size() && i < this._preferredRowCount; ++i) {
                    maxLineWidth = Math.max(maxLineWidth, (Integer)lineWidths.get(i));
                }
            }
            Dimension dimension = new Dimension(Math.min(maxWidth, maxLineWidth), (maxRowHeight + Math.max(0, label.getRowGap())) * this._preferredRowCount);
            if (label.getIcon() != null) {
                dimension = new Dimension(dimension.width + label.getIconTextGap() + label.getIcon().getIconWidth(), dimension.height);
            }
            return dimension;
        }
    }

    private int getLayoutWidth(StyledLabel label, int maxWidth) {
        Font font = this.getFont(label);
        int defaultFontSize = font.getSize();
        FontMetrics fm = label.getFontMetrics(font);
        int nextRowStartIndex = 0;
        int x = 0;
        this._preferredRowCount = 1;
        for (int i = 0; i < this._styledTexts.size(); ++i) {
            FontMetrics fm2;
            StyledText styledText = this._styledTexts.get(i);
            StyleRange style = styledText.styleRange;
            if (styledText.text.contains("\r") || styledText.text.contains("\n")) {
                x = 0;
                ++this._preferredRowCount;
                continue;
            }
            int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / style.getFontShrinkRatio()) : defaultFontSize;
            font = this.getFont(label);
            if (style != null && (style.getFontStyle() != -1 && font.getStyle() != style.getFontStyle() || font.getSize() != size)) {
                font = FontUtils.getCachedDerivedFont(font, style.getFontStyle() == -1 ? font.getStyle() : style.getFontStyle(), size);
                fm2 = label.getFontMetrics(font);
            } else {
                fm2 = fm;
            }
            String s = styledText.text.substring(nextRowStartIndex);
            int strWidth = fm2.stringWidth(s);
            boolean wrapped = false;
            int widthLeft = maxWidth - x;
            if (widthLeft < strWidth) {
                int nextWordStartIndex;
                wrapped = true;
                int availLength = s.length() * widthLeft / strWidth + 1;
                int nextRowStartIndexInSubString = 0;
                boolean needBreak = false;
                boolean needContinue = false;
                int loopCount = 0;
                do {
                    String subStringThisRow;
                    String subString;
                    int firstRowWordEndIndex;
                    int n = nextWordStartIndex = (firstRowWordEndIndex = this.findFirstRowWordEndIndex(subString = s.substring(0, Math.min(availLength, s.length())))) < 0 ? 0 : this.findNextWordStartIndex(s, firstRowWordEndIndex);
                    if (firstRowWordEndIndex < 0) {
                        if (x != 0) {
                            x = 0;
                            --i;
                            ++this._preferredRowCount;
                            if (label.getMaxRows() > 0 && this._preferredRowCount >= label.getMaxRows()) {
                                needBreak = true;
                            }
                            needContinue = true;
                            break;
                        }
                        firstRowWordEndIndex = 0;
                        nextWordStartIndex = Math.min(s.length(), availLength);
                    }
                    if ((strWidth = fm2.stringWidth(subStringThisRow = s.substring(0, Math.min(nextRowStartIndexInSubString = firstRowWordEndIndex + 1, s.length())))) > widthLeft) {
                        availLength = subString.length() * widthLeft / strWidth;
                    }
                    if (++loopCount <= 50) continue;
                    System.err.println("Painting Styled Label Error: " + styledText);
                    break;
                } while (strWidth > widthLeft && availLength > 0);
                if (needBreak) break;
                if (needContinue) continue;
                while (nextRowStartIndexInSubString < nextWordStartIndex && (strWidth += fm2.charWidth(s.charAt(nextRowStartIndexInSubString))) < widthLeft) {
                    ++nextRowStartIndexInSubString;
                }
                String subStringThisRow = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                strWidth = fm2.stringWidth(subStringThisRow);
                while (nextRowStartIndexInSubString < nextWordStartIndex && (strWidth += fm2.charWidth(s.charAt(nextRowStartIndexInSubString))) < widthLeft) {
                    ++nextRowStartIndexInSubString;
                }
                s = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                strWidth = fm2.stringWidth(s);
                nextRowStartIndex += nextRowStartIndexInSubString;
            } else {
                nextRowStartIndex = 0;
            }
            if (wrapped) {
                ++this._preferredRowCount;
                x = 0;
                --i;
                continue;
            }
            x += strWidth;
        }
        return maxWidth;
    }

    private int getMaximumWidth(StyledLabel label, int maxWidth, int naturalRowCount, int limitedRows) {
        int paintRows;
        int textWidth = label.getWidth() - label.getInsets().left - label.getInsets().right;
        if (label.getIcon() != null) {
            textWidth -= label.getIcon().getIconWidth() + label.getIconTextGap();
        }
        if (naturalRowCount > 1) {
            int proposedMaxWidthMin = 1;
            int proposedMaxWidthMax = maxWidth;
            this._preferredRowCount = naturalRowCount;
            while (proposedMaxWidthMin < proposedMaxWidthMax) {
                int middle = (proposedMaxWidthMax + proposedMaxWidthMin) / 2;
                maxWidth = this.getLayoutWidth(label, middle);
                if (this._preferredRowCount > limitedRows) {
                    proposedMaxWidthMin = middle + 1;
                    this._preferredRowCount = naturalRowCount;
                    continue;
                }
                proposedMaxWidthMax = middle - 1;
            }
            return maxWidth + maxWidth / 20;
        }
        int estimatedWidth = maxWidth / limitedRows + 1;
        int x = 0;
        int nextRowStartIndex = 0;
        Font font = this.getFont(label);
        FontMetrics fm = label.getFontMetrics(font);
        int defaultFontSize = font.getSize();
        for (int i = 0; i < this._styledTexts.size(); ++i) {
            FontMetrics fm2;
            StyledText styledText = this._styledTexts.get(i);
            StyleRange style = styledText.styleRange;
            int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / style.getFontShrinkRatio()) : defaultFontSize;
            font = this.getFont(label);
            if (style != null && (style.getFontStyle() != -1 && font.getStyle() != style.getFontStyle() || font.getSize() != size)) {
                font = FontUtils.getCachedDerivedFont(font, style.getFontStyle() == -1 ? font.getStyle() : style.getFontStyle(), size);
                fm2 = label.getFontMetrics(font);
            } else {
                fm2 = fm;
            }
            String s = styledText.text.substring(nextRowStartIndex);
            int strWidth = fm2.stringWidth(s);
            int widthLeft = estimatedWidth - x;
            if (widthLeft < strWidth) {
                int availLength = s.length() * widthLeft / strWidth + 1;
                String subString = s.substring(0, Math.min(availLength, s.length()));
                int firstRowWordEndIndex = this.findFirstRowWordEndIndex(subString);
                int nextWordStartIndex = this.findNextWordStartIndex(s, firstRowWordEndIndex);
                if (firstRowWordEndIndex < 0) {
                    firstRowWordEndIndex = nextWordStartIndex < s.length() ? this.findFirstRowWordEndIndex(s.substring(0, nextWordStartIndex)) : nextWordStartIndex;
                }
                int nextRowStartIndexInSubString = firstRowWordEndIndex + 1;
                String subStringThisRow = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                strWidth = fm2.stringWidth(subStringThisRow);
                while (nextRowStartIndexInSubString < nextWordStartIndex && (strWidth += fm2.charWidth(s.charAt(++nextRowStartIndexInSubString))) < widthLeft) {
                }
                s = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                strWidth = fm2.stringWidth(s);
                nextRowStartIndex += nextRowStartIndexInSubString;
                if (x + strWidth >= maxWidth) {
                    x = Math.max(x, strWidth);
                    break;
                }
                if (x + strWidth >= estimatedWidth) {
                    x += strWidth;
                    break;
                }
                --i;
            }
            x += strWidth;
        }
        int paintWidth = x;
        if (label.getInsets() != null) {
            paintWidth += label.getInsets().left + label.getInsets().right;
        }
        if ((paintRows = this.internalPaintStyledText(label, null, 0, 0, paintWidth)) != limitedRows) {
            maxWidth = Math.min(maxWidth, textWidth);
            while (paintRows > limitedRows && paintWidth < maxWidth) {
                paintRows = this.internalPaintStyledText(label, null, 0, 0, paintWidth += 2);
            }
            while (paintRows < limitedRows && paintWidth > 0) {
                paintRows = this.internalPaintStyledText(label, null, 0, 0, paintWidth -= 2);
            }
            x = paintWidth;
            if (label.getInsets() != null) {
                x -= label.getInsets().left + label.getInsets().right;
            }
        }
        this._preferredRowCount = limitedRows;
        return x;
    }

    protected Font getFont(StyledLabel label) {
        Font font = label.getFont();
        if (font == null) {
            font = UIDefaultsLookup.getFont("Label.font");
        }
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintStyledText(StyledLabel label, Graphics g, int textX, int textY) {
        label.setTruncated(false);
        int paintWidth = label.getWidth();
        if (label.isLineWrap()) {
            int oldPreferredWidth = label.getPreferredWidth();
            int oldRows = label.getRows();
            try {
                label.setRows(0);
                paintWidth = this.getPreferredSize((StyledLabel)label).width;
                label.setPreferredWidth(oldPreferredWidth > 0 ? Math.min(label.getWidth(), oldPreferredWidth) : label.getWidth());
                Dimension sizeOnWidth = this.getPreferredSize(label);
                if (sizeOnWidth.width < paintWidth) {
                    paintWidth = sizeOnWidth.width;
                }
            }
            finally {
                label.setPreferredWidth(oldPreferredWidth);
                label.setRows(oldRows);
            }
        }
        Color oldColor = g.getColor();
        int textWidth = label.getWidth();
        if (label.getInsets() != null) {
            textWidth -= label.getInsets().left + label.getInsets().right;
        }
        if (label.getIcon() != null && label.getHorizontalTextPosition() != 0) {
            textWidth -= label.getIcon().getIconWidth() + label.getIconTextGap();
        }
        paintWidth = Math.min(paintWidth, textWidth);
        this.internalPaintStyledText(label, g, textX, textY, paintWidth);
        g.setColor(oldColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int internalPaintStyledText(StyledLabel label, Graphics g, int textX, int textY, int paintWidth) {
        Insets insets;
        int labelHeight = label.getHeight();
        if (labelHeight <= 0) {
            labelHeight = Integer.MAX_VALUE;
        }
        if ((insets = label.getInsets()) != null) {
            labelHeight -= insets.top + insets.bottom;
        }
        int leftMostX = 0;
        if (insets != null) {
            leftMostX += insets.left;
        }
        if (label.getIcon() != null) {
            int horizontalTextPosition = label.getHorizontalTextPosition();
            if (horizontalTextPosition == 11 && label.getComponentOrientation().isLeftToRight() || horizontalTextPosition == 10 && !label.getComponentOrientation().isLeftToRight()) {
                horizontalTextPosition = 4;
            }
            if (horizontalTextPosition == 4) {
                leftMostX += label.getIcon().getIconWidth() + label.getIconTextGap();
            }
        }
        int startX = textX < leftMostX ? leftMostX : textX;
        int endX = paintWidth + startX;
        int x = startX;
        int mnemonicIndex = label.getDisplayedMnemonicIndex();
        if (UIManager.getLookAndFeel() instanceof WindowsLookAndFeel && WindowsLookAndFeel.isMnemonicHidden()) {
            mnemonicIndex = -1;
        }
        int charDisplayed = 0;
        int mneIndex = 0;
        Font font = this.getFont(label);
        FontMetrics fm = label.getFontMetrics(font);
        FontMetrics nextFm2 = null;
        int defaultFontSize = font.getSize();
        List<StyledText> list = this._styledTexts;
        synchronized (list) {
            FontMetrics fm2;
            int maxRowHeight = fm.getHeight();
            int minStartY = fm.getAscent();
            int horizontalAlignment = label.getHorizontalAlignment();
            switch (horizontalAlignment) {
                case 10: {
                    horizontalAlignment = label.getComponentOrientation().isLeftToRight() ? 2 : 4;
                    break;
                }
                case 11: {
                    horizontalAlignment = label.getComponentOrientation().isLeftToRight() ? 4 : 2;
                }
            }
            for (StyledText styledText : this._styledTexts) {
                StyleRange style = styledText.styleRange;
                int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / style.getFontShrinkRatio()) : defaultFontSize;
                font = this.getFont(label);
                if (style == null || (style.getFontStyle() == -1 || font.getStyle() == style.getFontStyle()) && font.getSize() == size) continue;
                font = FontUtils.getCachedDerivedFont(font, style.getFontStyle() == -1 ? font.getStyle() : style.getFontStyle(), size);
                fm2 = label.getFontMetrics(font);
                maxRowHeight = Math.max(maxRowHeight, fm2.getHeight());
                minStartY = Math.max(minStartY, fm2.getAscent());
            }
            boolean lineWrap = label.isLineWrap();
            if (!lineWrap) {
                for (StyledText styledText : this._styledTexts) {
                    if (!styledText.text.endsWith("\n")) continue;
                    lineWrap = true;
                    break;
                }
            }
            if (lineWrap && textY < minStartY) {
                textY = minStartY;
            }
            int nextRowStartIndex = 0;
            int rowCount = 0;
            int rowStartOffset = 0;
            for (int i = 0; i < this._styledTexts.size(); ++i) {
                boolean displayMnemonic;
                StyledText styledText = this._styledTexts.get(i);
                StyleRange style = styledText.styleRange;
                if (mnemonicIndex >= 0 && styledText.text.length() - nextRowStartIndex > mnemonicIndex - charDisplayed) {
                    displayMnemonic = true;
                    mneIndex = mnemonicIndex - charDisplayed;
                } else {
                    displayMnemonic = false;
                }
                charDisplayed += styledText.text.length() - nextRowStartIndex;
                if (styledText.text.contains("\r") || styledText.text.contains("\n")) {
                    boolean lastRow;
                    boolean bl = lastRow = label.getMaxRows() > 0 && rowCount >= label.getMaxRows() - 1 || textY + maxRowHeight + Math.max(0, label.getRowGap()) > labelHeight;
                    if (horizontalAlignment != 2 && g != null) {
                        if (lastRow && i != this._styledTexts.size() - 1) {
                            x += fm.stringWidth("...");
                        }
                        this.paintRow(label, g, startX, x, endX, textY, rowStartOffset, style.getStart() + styledText.text.length(), lastRow);
                    }
                    rowStartOffset = style.getStart();
                    nextRowStartIndex = 0;
                    nextFm2 = null;
                    if (!lastRow) {
                        rowStartOffset += style.getLength();
                        ++rowCount;
                        x = startX;
                        textY += maxRowHeight + Math.max(0, label.getRowGap());
                        continue;
                    }
                    if (horizontalAlignment != 2 && g != null) break;
                }
                int y = textY;
                if (nextFm2 == null) {
                    int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / style.getFontShrinkRatio()) : defaultFontSize;
                    font = this.getFont(label);
                    if (style != null && (style.getFontStyle() != -1 && font.getStyle() != style.getFontStyle() || font.getSize() != size)) {
                        font = FontUtils.getCachedDerivedFont(font, style.getFontStyle() == -1 ? font.getStyle() : style.getFontStyle(), size);
                        fm2 = label.getFontMetrics(font);
                    } else {
                        fm2 = fm;
                    }
                } else {
                    fm2 = nextFm2;
                }
                if (g != null) {
                    g.setFont(font);
                }
                boolean stop = false;
                String s = styledText.text.substring(Math.min(nextRowStartIndex, styledText.text.length()));
                if (s.contains("\r") || s.contains("\n")) {
                    s = "...";
                    stop = true;
                }
                int strWidth = fm2.stringWidth(s);
                boolean wrapped = false;
                int widthLeft = endX - x;
                if (widthLeft < strWidth && widthLeft >= 0) {
                    if (label.isLineWrap() && (label.getMaxRows() > 0 && rowCount < label.getMaxRows() - 1 || label.getMaxRows() <= 0) && y + maxRowHeight + Math.max(0, label.getRowGap()) <= labelHeight) {
                        int nextWordStartIndex;
                        wrapped = true;
                        int availLength = s.length() * widthLeft / strWidth + 1;
                        int nextRowStartIndexInSubString = 0;
                        boolean needBreak = false;
                        boolean needContinue = false;
                        int loopCount = 0;
                        do {
                            String subStringThisRow;
                            String subString;
                            int firstRowWordEndIndex;
                            int n = nextWordStartIndex = (firstRowWordEndIndex = this.findFirstRowWordEndIndex(subString = s.substring(0, Math.max(0, Math.min(availLength, s.length()))))) < 0 ? 0 : this.findNextWordStartIndex(s, firstRowWordEndIndex);
                            if (firstRowWordEndIndex < 0) {
                                if (x != startX) {
                                    boolean lastRow;
                                    boolean bl = lastRow = label.getMaxRows() > 0 && rowCount >= label.getMaxRows() - 1;
                                    if (horizontalAlignment != 2 && g != null) {
                                        this.paintRow(label, g, startX, x, endX, textY, rowStartOffset, style.getStart() + Math.min(nextRowStartIndex, styledText.text.length()), lastRow);
                                    }
                                    textY += maxRowHeight + Math.max(0, label.getRowGap());
                                    x = startX;
                                    --i;
                                    ++rowCount;
                                    rowStartOffset = style.getStart() + Math.min(nextRowStartIndex, styledText.text.length());
                                    if (lastRow) {
                                        needBreak = true;
                                    }
                                    needContinue = true;
                                    break;
                                }
                                firstRowWordEndIndex = 0;
                                nextWordStartIndex = Math.min(s.length(), availLength);
                            }
                            if ((strWidth = fm2.stringWidth(subStringThisRow = s.substring(0, Math.min(nextRowStartIndexInSubString = firstRowWordEndIndex + 1, s.length())))) > widthLeft) {
                                availLength = subString.length() * widthLeft / strWidth;
                            }
                            if (++loopCount <= 15) continue;
                            System.err.println("Painting Styled Label Error: " + styledText);
                            break;
                        } while (strWidth > widthLeft && availLength > 0);
                        if (needBreak) break;
                        if (needContinue) continue;
                        while (nextRowStartIndexInSubString < nextWordStartIndex && (strWidth += fm2.charWidth(s.charAt(nextRowStartIndexInSubString))) < widthLeft) {
                            ++nextRowStartIndexInSubString;
                        }
                        s = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                        strWidth = fm2.stringWidth(s);
                        charDisplayed -= styledText.text.length() - nextRowStartIndex;
                        if (displayMnemonic) {
                            if (mnemonicIndex >= 0 && s.length() > mnemonicIndex - charDisplayed) {
                                displayMnemonic = true;
                                mneIndex = mnemonicIndex - charDisplayed;
                            } else {
                                displayMnemonic = false;
                            }
                        }
                        charDisplayed += s.length();
                        nextRowStartIndex += nextRowStartIndexInSubString;
                    } else {
                        s = SwingUtilities.layoutCompoundLabel(label, fm2, s, null, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), new Rectangle(x, y, widthLeft, labelHeight), new Rectangle(), new Rectangle(), 0);
                        strWidth = fm2.stringWidth(s);
                    }
                    stop = !lineWrap || y + maxRowHeight + Math.max(0, label.getRowGap()) > labelHeight || label.getMaxRows() > 0 && rowCount >= label.getMaxRows() - 1;
                } else if (lineWrap) {
                    nextRowStartIndex = 0;
                } else if (i < this._styledTexts.size() - 1) {
                    String nextS;
                    StyledText nextStyledText = this._styledTexts.get(i + 1);
                    String nextText = nextStyledText.text;
                    StyleRange nextStyle = nextStyledText.styleRange;
                    int size = nextStyle != null && (nextStyle.isSuperscript() || nextStyle.isSubscript()) ? Math.round((float)defaultFontSize / nextStyle.getFontShrinkRatio()) : defaultFontSize;
                    font = this.getFont(label);
                    if (nextStyle != null && (nextStyle.getFontStyle() != -1 && font.getStyle() != nextStyle.getFontStyle() || font.getSize() != size)) {
                        font = FontUtils.getCachedDerivedFont(font, nextStyle.getFontStyle() == -1 ? font.getStyle() : nextStyle.getFontStyle(), size);
                        nextFm2 = label.getFontMetrics(font);
                    } else {
                        nextFm2 = fm;
                    }
                    if (nextFm2.stringWidth(nextText) > widthLeft - strWidth && nextFm2.stringWidth(nextS = SwingUtilities.layoutCompoundLabel(label, nextFm2, nextText, null, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), new Rectangle(x + strWidth, y, widthLeft - strWidth, labelHeight), new Rectangle(), new Rectangle(), 0)) > widthLeft - strWidth) {
                        s = SwingUtilities.layoutCompoundLabel(label, fm2, s, null, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), new Rectangle(x, y, strWidth - 1, labelHeight), new Rectangle(), new Rectangle(), 0);
                        strWidth = fm2.stringWidth(s);
                        stop = true;
                    }
                }
                if (rowCount > 0 && x == startX && s.startsWith(" ")) {
                    s = s.substring(1);
                    strWidth = fm2.stringWidth(s);
                }
                if (horizontalAlignment == 2 && g != null) {
                    Color textColor;
                    if (style != null && style.isSuperscript()) {
                        y -= fm.getHeight() - fm2.getHeight();
                    }
                    if (style != null && style.getBackgroundColor() != null) {
                        g.setColor(style.getBackgroundColor());
                        g.fillRect(x, y - fm2.getHeight(), strWidth, fm2.getHeight() + 4);
                    }
                    Color color = textColor = style != null && !label.isIgnoreColorSettings() && style.getFontColor() != null ? style.getFontColor() : label.getForeground();
                    if (!label.isEnabled()) {
                        textColor = UIDefaultsLookup.getColor("Label.disabledForeground");
                    }
                    g.setColor(textColor);
                    if (displayMnemonic) {
                        JideSwingUtilities.drawStringUnderlineCharAt(label, g, s, mneIndex, x, y);
                    } else {
                        JideSwingUtilities.drawString(label, g, s, x, y);
                    }
                    if (style != null) {
                        Stroke oldStroke = ((Graphics2D)g).getStroke();
                        if (style.getLineStroke() != null) {
                            ((Graphics2D)g).setStroke(style.getLineStroke());
                        }
                        if (!label.isIgnoreColorSettings() && style.getLineColor() != null) {
                            g.setColor(style.getLineColor());
                        }
                        if (style.isStrikethrough()) {
                            int lineY = y + (fm2.getDescent() - fm2.getAscent()) / 2;
                            g.drawLine(x, lineY, x + strWidth - 1, lineY);
                        }
                        if (style.isDoublestrikethrough()) {
                            int lineY = y + (fm2.getDescent() - fm2.getAscent()) / 2;
                            g.drawLine(x, lineY - 1, x + strWidth - 1, lineY - 1);
                            g.drawLine(x, lineY + 1, x + strWidth - 1, lineY + 1);
                        }
                        if (style.isUnderlined()) {
                            int lineY = y + 1;
                            g.drawLine(x, lineY, x + strWidth - 1, lineY);
                        }
                        if (style.isDotted()) {
                            int dotY = y + 1;
                            for (int dotX = x; dotX < x + strWidth; dotX += 4) {
                                g.drawRect(dotX, dotY, 1, 1);
                            }
                        }
                        if (style.isWaved()) {
                            int waveY = y + 1;
                            for (int waveX = x; waveX < x + strWidth; waveX += 4) {
                                if (waveX + 2 <= x + strWidth - 1) {
                                    g.drawLine(waveX, waveY + 2, waveX + 2, waveY);
                                }
                                if (waveX + 4 > x + strWidth - 1) continue;
                                g.drawLine(waveX + 3, waveY + 1, waveX + 4, waveY + 2);
                            }
                        }
                        if (style.getLineStroke() != null) {
                            ((Graphics2D)g).setStroke(oldStroke);
                        }
                    }
                }
                if (stop) {
                    if (horizontalAlignment != 2 && g != null) {
                        this.paintRow(label, g, startX, x += strWidth, endX, textY, rowStartOffset, label.getText().length(), true);
                    }
                    label.setTruncated(true);
                    break;
                }
                if (wrapped) {
                    boolean lastRow;
                    boolean bl = lastRow = label.getMaxRows() > 0 && rowCount >= label.getMaxRows() - 1 || textY + maxRowHeight + Math.max(0, label.getRowGap()) > labelHeight;
                    if (horizontalAlignment != 2 && g != null) {
                        this.paintRow(label, g, startX, x += strWidth, endX, textY, rowStartOffset, style.getStart() + Math.min(nextRowStartIndex, styledText.text.length()), lastRow);
                    }
                    textY += maxRowHeight + Math.max(0, label.getRowGap());
                    x = startX;
                    --i;
                    ++rowCount;
                    rowStartOffset = style.getStart() + Math.min(nextRowStartIndex, styledText.text.length());
                    if (lastRow) {
                        break;
                    }
                } else {
                    x += strWidth;
                }
                if (i != this._styledTexts.size() - 1 || horizontalAlignment == 2 || g == null) continue;
                this.paintRow(label, g, startX, x, endX, textY, rowStartOffset, -1, true);
            }
            return (int)Math.ceil((double)textY / (double)maxRowHeight);
        }
    }

    private void paintRow(StyledLabel label, Graphics g, int leftAlignmentX, int thisLineEndX, int rightMostX, int textY, int startOffset, int endOffset, boolean lastRow) {
        if (g == null) {
            return;
        }
        int horizontalTextPosition = label.getHorizontalTextPosition();
        int horizontalAlignment = label.getHorizontalAlignment();
        if (horizontalTextPosition == 11 && !label.getComponentOrientation().isLeftToRight() || horizontalTextPosition == 10 && label.getComponentOrientation().isLeftToRight()) {
            horizontalTextPosition = 2;
        }
        if (horizontalTextPosition == 10 && !label.getComponentOrientation().isLeftToRight() || horizontalTextPosition == 11 && label.getComponentOrientation().isLeftToRight()) {
            horizontalTextPosition = 4;
        }
        if (horizontalAlignment == 11 && !label.getComponentOrientation().isLeftToRight() || horizontalAlignment == 10 && label.getComponentOrientation().isLeftToRight()) {
            horizontalAlignment = 2;
        }
        if (horizontalAlignment == 10 && !label.getComponentOrientation().isLeftToRight() || horizontalAlignment == 11 && label.getComponentOrientation().isLeftToRight()) {
            horizontalAlignment = 4;
        }
        Insets insets = label.getInsets();
        int textX = leftAlignmentX;
        int paintWidth = thisLineEndX - leftAlignmentX;
        if (horizontalAlignment == 4) {
            paintWidth = thisLineEndX - textX;
            textX = label.getWidth() - paintWidth;
            if (insets != null) {
                textX -= insets.right;
            }
            if (label.getIcon() != null && horizontalTextPosition == 2) {
                textX -= label.getIcon().getIconWidth() + label.getIconTextGap();
            }
        } else if (horizontalAlignment == 0) {
            int leftMostX = 0;
            if (horizontalTextPosition == 4 && label.getIcon() != null) {
                leftMostX += label.getIcon().getIconWidth() + label.getIconTextGap();
            }
            int labelWidth = label.getWidth();
            if (insets != null) {
                labelWidth -= insets.right + insets.left;
                leftMostX += insets.left;
            }
            if (label.getIcon() != null && horizontalTextPosition != 0) {
                labelWidth -= label.getIcon().getIconWidth() + label.getIconTextGap();
            }
            textX = leftMostX + (labelWidth - paintWidth) / 2;
        }
        paintWidth = Math.min(paintWidth, rightMostX - leftAlignmentX);
        int mnemonicIndex = label.getDisplayedMnemonicIndex();
        if (UIManager.getLookAndFeel() instanceof WindowsLookAndFeel && WindowsLookAndFeel.isMnemonicHidden()) {
            mnemonicIndex = -1;
        }
        int charDisplayed = 0;
        int mneIndex = 0;
        Font font = this.getFont(label);
        FontMetrics fm = label.getFontMetrics(font);
        FontMetrics nextFm2 = null;
        int defaultFontSize = font.getSize();
        int x = textX;
        for (int i = 0; i < this._styledTexts.size() && (endOffset < 0 || charDisplayed < endOffset); ++i) {
            Color textColor;
            int strWidth;
            int widthLeft;
            FontMetrics fm2;
            boolean displayMnemonic;
            StyledText styledText = this._styledTexts.get(i);
            StyleRange style = styledText.styleRange;
            int length = style.getLength();
            if (length < 0) {
                length = styledText.text.length();
            }
            if (style.getStart() + length <= startOffset) {
                charDisplayed += length;
                continue;
            }
            int nextRowStartIndex = style.getStart() >= startOffset ? 0 : startOffset - style.getStart();
            if (mnemonicIndex >= 0 && styledText.text.length() - nextRowStartIndex > mnemonicIndex - (charDisplayed += nextRowStartIndex)) {
                displayMnemonic = true;
                mneIndex = mnemonicIndex - charDisplayed;
            } else {
                displayMnemonic = false;
            }
            int paintLength = styledText.text.length() - nextRowStartIndex;
            if (endOffset >= 0 && charDisplayed + paintLength >= endOffset) {
                paintLength = endOffset - charDisplayed;
            }
            charDisplayed += paintLength;
            int y = textY;
            if (nextFm2 == null) {
                int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / style.getFontShrinkRatio()) : defaultFontSize;
                font = this.getFont(label);
                if (style != null && (style.getFontStyle() != -1 && font.getStyle() != style.getFontStyle() || font.getSize() != size)) {
                    font = FontUtils.getCachedDerivedFont(font, style.getFontStyle() == -1 ? font.getStyle() : style.getFontStyle(), size);
                    fm2 = label.getFontMetrics(font);
                } else {
                    fm2 = fm;
                }
            } else {
                fm2 = nextFm2;
            }
            g.setFont(font);
            String s = styledText.text.substring(Math.min(nextRowStartIndex, styledText.text.length()));
            if (startOffset > 0 && x == textX && s.startsWith(" ")) {
                s = s.substring(1);
            }
            if (s.length() > paintLength) {
                s = s.substring(0, paintLength);
            }
            if (s.contains("\r") || s.contains("\n")) {
                if (styledText.styleRange.getStart() + styledText.styleRange.getLength() >= endOffset) break;
                s = "...";
            }
            if ((widthLeft = paintWidth + textX - x) < (strWidth = fm2.stringWidth(s))) {
                if (strWidth <= 0) {
                    return;
                }
                if (label.isLineWrap() && !lastRow) {
                    int nextRowStartIndexInSubString;
                    int nextWordStartIndex;
                    int availLength = s.length() * widthLeft / strWidth + 1;
                    int loopCount = 0;
                    do {
                        String subStringThisRow;
                        String subString;
                        int firstRowWordEndIndex;
                        int n = nextWordStartIndex = (firstRowWordEndIndex = this.findFirstRowWordEndIndex(subString = s.substring(0, Math.max(0, Math.min(availLength, s.length()))))) < 0 ? 0 : this.findNextWordStartIndex(s, firstRowWordEndIndex);
                        if (firstRowWordEndIndex < 0 && x == textX) {
                            firstRowWordEndIndex = 0;
                            nextWordStartIndex = Math.min(s.length(), availLength);
                        }
                        if ((strWidth = fm2.stringWidth(subStringThisRow = s.substring(0, Math.min(nextRowStartIndexInSubString = firstRowWordEndIndex + 1, s.length())))) > widthLeft) {
                            availLength = subString.length() * widthLeft / strWidth;
                        }
                        if (++loopCount <= 50) continue;
                        System.err.println("Painting Styled Label Error: " + styledText);
                        break;
                    } while (strWidth > widthLeft && availLength > 0);
                    while (nextRowStartIndexInSubString < nextWordStartIndex && (strWidth += fm2.charWidth(s.charAt(nextRowStartIndexInSubString))) < widthLeft) {
                        ++nextRowStartIndexInSubString;
                    }
                    s = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                    strWidth = fm2.stringWidth(s);
                    charDisplayed -= styledText.text.length() - nextRowStartIndex;
                    if (displayMnemonic) {
                        if (mnemonicIndex >= 0 && s.length() > mnemonicIndex - charDisplayed) {
                            displayMnemonic = true;
                            mneIndex = mnemonicIndex - charDisplayed;
                        } else {
                            displayMnemonic = false;
                        }
                    }
                    charDisplayed += s.length();
                    nextRowStartIndex += nextRowStartIndexInSubString;
                } else {
                    s = SwingUtilities.layoutCompoundLabel(label, fm2, s, null, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), new Rectangle(x, y, widthLeft, label.getHeight()), new Rectangle(), new Rectangle(), 0);
                    strWidth = fm2.stringWidth(s);
                }
            } else if (label.isLineWrap()) {
                nextRowStartIndex = 0;
            } else if (i < this._styledTexts.size() - 1) {
                String nextS;
                StyledText nextStyledText = this._styledTexts.get(i + 1);
                String nextText = nextStyledText.text;
                StyleRange nextStyle = nextStyledText.styleRange;
                int size = nextStyle != null && (nextStyle.isSuperscript() || nextStyle.isSubscript()) ? Math.round((float)defaultFontSize / nextStyle.getFontShrinkRatio()) : defaultFontSize;
                font = this.getFont(label);
                if (nextStyle != null && (nextStyle.getFontStyle() != -1 && font.getStyle() != nextStyle.getFontStyle() || font.getSize() != size)) {
                    font = FontUtils.getCachedDerivedFont(font, nextStyle.getFontStyle() == -1 ? font.getStyle() : nextStyle.getFontStyle(), size);
                    nextFm2 = label.getFontMetrics(font);
                } else {
                    nextFm2 = fm;
                }
                if (nextFm2.stringWidth(nextText) > widthLeft - strWidth && nextFm2.stringWidth(nextS = SwingUtilities.layoutCompoundLabel(label, nextFm2, nextText, null, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), new Rectangle(x + strWidth, y, widthLeft - strWidth, label.getHeight()), new Rectangle(), new Rectangle(), 0)) > widthLeft - strWidth) {
                    s = SwingUtilities.layoutCompoundLabel(label, fm2, s, null, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), new Rectangle(x, y, strWidth - 1, label.getHeight()), new Rectangle(), new Rectangle(), 0);
                    strWidth = fm2.stringWidth(s);
                }
            }
            if (style != null && style.isSuperscript()) {
                y -= fm.getHeight() - fm2.getHeight();
            }
            if (style != null && style.getBackgroundColor() != null) {
                g.setColor(style.getBackgroundColor());
                g.fillRect(x, y - fm2.getHeight(), strWidth, fm2.getHeight() + 4);
            }
            Color color = textColor = style != null && !label.isIgnoreColorSettings() && style.getFontColor() != null ? style.getFontColor() : label.getForeground();
            if (!label.isEnabled()) {
                textColor = UIDefaultsLookup.getColor("Label.disabledForeground");
            }
            g.setColor(textColor);
            if (displayMnemonic) {
                JideSwingUtilities.drawStringUnderlineCharAt(label, g, s, mneIndex, x, y);
            } else {
                JideSwingUtilities.drawString(label, g, s, x, y);
            }
            if (style != null) {
                int lineY;
                Stroke oldStroke = ((Graphics2D)g).getStroke();
                if (style.getLineStroke() != null) {
                    ((Graphics2D)g).setStroke(style.getLineStroke());
                }
                if (!label.isIgnoreColorSettings() && style.getLineColor() != null) {
                    g.setColor(style.getLineColor());
                }
                if (style.isStrikethrough()) {
                    lineY = y + (fm2.getDescent() - fm2.getAscent()) / 2;
                    g.drawLine(x, lineY, x + strWidth - 1, lineY);
                }
                if (style.isDoublestrikethrough()) {
                    lineY = y + (fm2.getDescent() - fm2.getAscent()) / 2;
                    g.drawLine(x, lineY - 1, x + strWidth - 1, lineY - 1);
                    g.drawLine(x, lineY + 1, x + strWidth - 1, lineY + 1);
                }
                if (style.isUnderlined()) {
                    lineY = y + 1;
                    g.drawLine(x, lineY, x + strWidth - 1, lineY);
                }
                if (style.isDotted()) {
                    int dotY = y + 1;
                    for (int dotX = x; dotX < x + strWidth; dotX += 4) {
                        g.drawRect(dotX, dotY, 1, 1);
                    }
                }
                if (style.isWaved()) {
                    int waveY = y + 1;
                    for (int waveX = x; waveX < x + strWidth; waveX += 4) {
                        if (waveX + 2 <= x + strWidth - 1) {
                            g.drawLine(waveX, waveY + 2, waveX + 2, waveY);
                        }
                        if (waveX + 4 > x + strWidth - 1) continue;
                        g.drawLine(waveX + 3, waveY + 1, waveX + 4, waveY + 2);
                    }
                }
                if (style.getLineStroke() != null) {
                    ((Graphics2D)g).setStroke(oldStroke);
                }
            }
            x += strWidth;
        }
    }

    private int findNextWordStartIndex(String string, int firstRowEndIndex) {
        boolean skipFirstWord = firstRowEndIndex < 0;
        for (int i = firstRowEndIndex + 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') {
                if (skipFirstWord) continue;
                return i;
            }
            skipFirstWord = false;
        }
        return string.length();
    }

    private int findFirstRowWordEndIndex(String string) {
        boolean spaceFound = false;
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (!spaceFound) {
                if (c != ' ' && c != '\t' && c != '\r' && c != '\n') continue;
                spaceFound = true;
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            return i;
        }
        return -1;
    }

    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        boolean orientationIsLeftToRight = true;
        int hAlign = horizontalAlignment;
        int hTextPos = horizontalTextPosition;
        if (c != null && !c.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        switch (horizontalAlignment) {
            case 10: {
                hAlign = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hAlign = orientationIsLeftToRight ? 4 : 2;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                hTextPos = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hTextPos = orientationIsLeftToRight ? 4 : 2;
            }
        }
        return BasicStyledLabelUI.layoutCompoundLabelImpl(c, fm, text, icon, verticalAlignment, hAlign, verticalTextPosition, hTextPos, viewR, iconR, textR, textIconGap);
    }

    public static String layoutCompoundLabel(FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        return BasicStyledLabelUI.layoutCompoundLabelImpl(null, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
    }

    private static String layoutCompoundLabelImpl(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int gap;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || text.equals("");
        int lsb = 0;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text = "";
            gap = 0;
        } else {
            View v;
            gap = icon == null ? 0 : textIconGap;
            int availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap);
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                textR.width = Math.min(availTextWidth, (int)v.getPreferredSpan(0));
                textR.height = (int)v.getPreferredSpan(1);
            }
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        if (lsb < 0) {
            textR.x -= lsb;
        }
        int maxIconY = viewR.height / 2;
        Insets insets = c.getInsets();
        int leftMostX = viewR.x;
        int rightMostX = viewR.width;
        rightMostX -= iconR.width;
        if (horizontalTextPosition == 0) {
            if (viewR.width < textR.width) {
                iconR.x = (leftMostX + rightMostX) / 2;
            } else {
                int leftMostTextX = textR.x;
                int rightMostTextX = textR.x + textR.width - iconR.width;
                iconR.x = textR.x + (textR.width - iconR.width) / 2;
            }
        } else if (iconR.x < leftMostX) {
            textR.x += leftMostX - iconR.x;
            iconR.x = leftMostX;
        } else if (iconR.x > rightMostX && horizontalAlignment != 2) {
            iconR.x = rightMostX;
            textR.x -= iconR.x - rightMostX;
        }
        if (insets != null) {
            maxIconY -= (insets.bottom + insets.top) / 2;
        }
        if (icon != null) {
            maxIconY -= icon.getIconHeight() / 2;
        }
        if (verticalAlignment == 1) {
            iconR.y = Math.min(maxIconY, iconR.y);
        } else if (verticalAlignment == 3) {
            iconR.y = Math.max(maxIconY, iconR.y);
        }
        return text;
    }

    static {
        styledLabelUI = new BasicStyledLabelUI();
    }

    class StyledText {
        StyleRange styleRange;
        String text;

        public StyledText(String text) {
            this.text = text;
        }

        public StyledText(String text, StyleRange styleRange) {
            this.text = text;
            this.styleRange = styleRange;
        }
    }
}

