/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.astrogrid.samp.DataException;

class JsonReader {
    private static final Object OBJECT_END = new Token("OBJECT_END");
    private static final Object ARRAY_END = new Token("ARRAY_END");
    private static final Object COLON = new Token("COLON");
    private static final Object COMMA = new Token("COMMA");
    public static final int FIRST = 0;
    public static final int CURRENT = 1;
    public static final int NEXT = 2;
    private static Map escapes = new HashMap();
    private CharacterIterator it;
    private char c;
    private Object token;
    private StringBuffer buf = new StringBuffer();

    JsonReader() {
    }

    private char next() {
        if (this.it.getIndex() == this.it.getEndIndex()) {
            throw new DataException("Reached end of input at the " + this.it.getIndex() + "th character.");
        }
        this.c = this.it.next();
        return this.c;
    }

    private char previous() {
        this.c = this.it.previous();
        return this.c;
    }

    private void skipWhiteSpace() {
        do {
            if (Character.isWhitespace(this.c)) continue;
            if (this.c != '/') break;
            this.next();
            if (this.c == '*') {
                while (this.c != '\uffff' && (this.next() != '*' || this.next() != '/')) {
                }
                if (this.c != '\uffff') continue;
                throw new DataException("Unterminated comment while parsing JSON string.");
            }
            if (this.c == '/') {
                while (this.c != '\n' && this.c != '\uffff') {
                    this.next();
                }
            } else {
                this.previous();
                break;
            }
        } while (this.next() != '\uffff');
    }

    public Object read(CharacterIterator ci, int start) {
        this.it = ci;
        switch (start) {
            case 0: {
                this.c = this.it.first();
                break;
            }
            case 1: {
                this.c = this.it.current();
                break;
            }
            case 2: {
                this.c = this.it.next();
            }
        }
        return this.read();
    }

    public Object read(CharacterIterator it) {
        return this.read(it, 2);
    }

    public Object read(String string) {
        return this.read(new StringCharacterIterator(string), 0);
    }

    private Object read() {
        this.skipWhiteSpace();
        char ch = this.c;
        this.next();
        switch (ch) {
            case '\"': {
                this.token = this.readString();
                break;
            }
            case '[': {
                this.token = this.readArray();
                break;
            }
            case ']': {
                this.token = ARRAY_END;
                break;
            }
            case ',': {
                this.token = COMMA;
                break;
            }
            case '{': {
                this.token = this.readObject();
                break;
            }
            case '}': {
                this.token = OBJECT_END;
                break;
            }
            case ':': {
                this.token = COLON;
                break;
            }
            default: {
                throw new DataException("Unexpected character '" + ch + "'");
            }
        }
        return this.token;
    }

    private Map readObject() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        this.read();
        while (true) {
            if (this.token == OBJECT_END) {
                return ret;
            }
            if (!(this.token instanceof String)) {
                throw new DataException("Missing/illegal object key");
            }
            String key = (String)this.token;
            if (this.read() != COLON) {
                throw new DataException("Missing colon in JSON object");
            }
            Object value = this.read();
            ret.put(key, value);
            this.read();
            if (this.token == COMMA) {
                this.read();
                continue;
            }
            if (this.token != OBJECT_END) break;
        }
        throw new DataException("Unexpected token " + this.token);
    }

    private List readArray() {
        ArrayList<Object> ret = new ArrayList<Object>();
        Object value = this.read();
        while (this.token != ARRAY_END) {
            ret.add(value);
            if (this.read() == COMMA) {
                value = this.read();
                continue;
            }
            if (this.token == ARRAY_END) continue;
            throw new DataException("Unexpected token in array " + this.token);
        }
        return ret;
    }

    private String readString() {
        this.buf.setLength(0);
        while (this.c != '\"') {
            if (this.c == '\\') {
                this.next();
                if (this.c == 'u') {
                    this.add(this.unicode());
                    continue;
                }
                Object value = escapes.get(Character.valueOf(this.c));
                if (value == null) continue;
                this.add(((Character)value).charValue());
                continue;
            }
            this.add();
        }
        this.next();
        return this.buf.toString();
    }

    private void add(char cc) {
        this.buf.append(cc);
        this.next();
    }

    private void add() {
        this.add(this.c);
    }

    private char unicode() {
        int value = 0;
        block5: for (int i = 0; i < 4; ++i) {
            switch (this.next()) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = (value << 4) + this.c - 48;
                    continue block5;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    value = (value << 4) + (this.c - 97) + 10;
                    continue block5;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    value = (value << 4) + (this.c - 65) + 10;
                }
            }
        }
        return (char)value;
    }

    static {
        escapes.put(Character.valueOf('\"'), Character.valueOf('\"'));
        escapes.put(Character.valueOf('\\'), Character.valueOf('\\'));
        escapes.put(Character.valueOf('/'), Character.valueOf('/'));
        escapes.put(Character.valueOf('b'), Character.valueOf('\b'));
        escapes.put(Character.valueOf('f'), Character.valueOf('\f'));
        escapes.put(Character.valueOf('n'), Character.valueOf('\n'));
        escapes.put(Character.valueOf('r'), Character.valueOf('\r'));
        escapes.put(Character.valueOf('t'), Character.valueOf('\t'));
    }

    private static class Token {
        private final String name;

        Token(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

