/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.bridge;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.bridge.ProxyManager;
import org.astrogrid.samp.bridge.UrlExporter;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.HubConnector;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.httpd.UtilServer;
import org.astrogrid.samp.xmlrpc.LockInfo;
import org.astrogrid.samp.xmlrpc.StandardClientProfile;
import org.astrogrid.samp.xmlrpc.XmlRpcKit;

public class Bridge {
    private final ProxyManager[] proxyManagers_;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Bridge(ClientProfile[] profiles) throws IOException {
        int ih;
        int nhub = profiles.length;
        this.proxyManagers_ = new ProxyManager[nhub];
        UtilServer server = UtilServer.getInstance();
        for (ih = 0; ih < nhub; ++ih) {
            this.proxyManagers_[ih] = new ProxyManager(profiles[ih], server){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void managerConnectionChanged(boolean isConnected) {
                    super.managerConnectionChanged(isConnected);
                    Bridge bridge = Bridge.this;
                    synchronized (bridge) {
                        Bridge.this.notifyAll();
                    }
                }
            };
        }
        for (ih = 0; ih < nhub; ++ih) {
            this.proxyManagers_[ih].init(this.proxyManagers_);
        }
        for (ih = 0; ih < nhub; ++ih) {
            this.proxyManagers_[ih].getManagerConnector().setAutoconnect(0);
        }
    }

    public ClientProfile[] getProfiles() {
        int nhub = this.proxyManagers_.length;
        ClientProfile[] profiles = new ClientProfile[nhub];
        for (int ih = 0; ih < nhub; ++ih) {
            profiles[ih] = this.proxyManagers_[ih].getProfile();
        }
        return profiles;
    }

    public HubConnector[] getBridgeClients() {
        int nhub = this.proxyManagers_.length;
        HubConnector[] connectors = new HubConnector[nhub];
        for (int ih = 0; ih < nhub; ++ih) {
            connectors[ih] = this.proxyManagers_[ih].getManagerConnector();
        }
        return connectors;
    }

    public void exportUrls(int index, String host) {
        this.proxyManagers_[index].setExporter(new UrlExporter(host, Bridge.isLocalHost(host)));
    }

    public boolean start() {
        HubConnector[] connectors = this.getBridgeClients();
        boolean allConnected = true;
        for (int ih = 0; ih < connectors.length; ++ih) {
            HubConnector connector = connectors[ih];
            connector.setActive(true);
            allConnected = allConnected && connector.isConnected();
        }
        return allConnected;
    }

    public void stop() {
        HubConnector[] connectors = this.getBridgeClients();
        for (int ih = 0; ih < connectors.length; ++ih) {
            connectors[ih].setActive(false);
        }
    }

    private int getConnectionCount() {
        HubConnector[] connectors = this.getBridgeClients();
        int nc = 0;
        for (int ih = 0; ih < connectors.length; ++ih) {
            if (!connectors[ih].isConnected()) continue;
            ++nc;
        }
        return nc;
    }

    private static boolean isLocalHost(String host) {
        if (host == null) {
            return false;
        }
        if (SampUtils.getLocalhost().equals(host)) {
            return true;
        }
        try {
            InetAddress hostAddr = InetAddress.getByName(host);
            return hostAddr != null && (hostAddr.isLoopbackAddress() || hostAddr.equals(InetAddress.getLocalHost()));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static void main(String[] args) throws IOException {
        int status;
        String hostspec = System.getProperty("jsamp.localhost");
        if (hostspec == null) {
            System.setProperty("jsamp.localhost", "[hostname]");
        }
        if ((status = Bridge.runMain(args)) != 0) {
            System.exit(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int runMain(String[] args) throws IOException {
        boolean exporturls;
        String usage = "\n   Usage:" + "\n      " + Bridge.class.getName() + "\n         " + " [-help]" + " [-/+verbose]" + " [-[no]exporturls]" + "\n         " + " [-nostandard]" + " [-sampdir <lockfile-dir>]" + " [-sampfile <lockfile>]" + " [-sampurl <lockurl>]" + "\n         " + " [-keys <xmlrpc-url> <secret>]" + " [-profile <clientprofile-class>]" + "\n";
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        int verbAdjust = 0;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-v") || arg.equals("-verbose")) {
                it.remove();
                --verbAdjust;
                continue;
            }
            if (arg.equals("+v") || arg.equals("+verbose")) {
                it.remove();
                ++verbAdjust;
                continue;
            }
            if (!arg.equals("-h") && !arg.equals("-help") && !arg.equals("--help")) continue;
            it.remove();
            System.out.println(usage);
            return 0;
        }
        int logLevel = Level.WARNING.intValue() + 100 * verbAdjust;
        Logger.getLogger("org.astrogrid.samp").setLevel(Level.parse(Integer.toString(logLevel)));
        ArrayList<ClientProfile> profileList = new ArrayList<ClientProfile>();
        XmlRpcKit xmlrpcKit = XmlRpcKit.getInstance();
        ClientProfile standardProfile = new ClientProfile(){

            public boolean isHubRunning() {
                return StandardClientProfile.getInstance().isHubRunning();
            }

            public HubConnection register() throws SampException {
                return StandardClientProfile.getInstance().register();
            }

            public String toString() {
                return "standard";
            }
        };
        profileList.add(standardProfile);
        Boolean reqExportUrls = null;
        Iterator it2 = argList.iterator();
        while (it2.hasNext()) {
            File lockfile;
            String arg = (String)it2.next();
            if (arg.equals("-exporturls")) {
                reqExportUrls = Boolean.TRUE;
                continue;
            }
            if (arg.equals("-noexporturls")) {
                reqExportUrls = Boolean.FALSE;
                continue;
            }
            if (arg.equals("-standard")) {
                it2.remove();
                profileList.remove(standardProfile);
                profileList.add(standardProfile);
                continue;
            }
            if (arg.equals("-nostandard")) {
                it2.remove();
                profileList.remove(standardProfile);
                continue;
            }
            if (arg.equals("-sampfile") && it2.hasNext()) {
                it2.remove();
                String fname = (String)it2.next();
                it2.remove();
                lockfile = new File(fname);
                profileList.add(new StandardClientProfile(xmlrpcKit){

                    public LockInfo getLockInfo() throws IOException {
                        return LockInfo.readLockFile(SampUtils.fileToUrl(lockfile));
                    }

                    public String toString() {
                        return lockfile.toString();
                    }
                });
                continue;
            }
            if (arg.equals("-sampdir") && it2.hasNext()) {
                it2.remove();
                final String dirname = (String)it2.next();
                it2.remove();
                lockfile = new File(dirname, ".samp");
                profileList.add(new StandardClientProfile(xmlrpcKit){

                    public LockInfo getLockInfo() throws IOException {
                        return LockInfo.readLockFile(SampUtils.fileToUrl(lockfile));
                    }

                    public String toString() {
                        return dirname;
                    }
                });
                continue;
            }
            if (arg.equals("-sampurl") && it2.hasNext()) {
                it2.remove();
                final URL lockUrl = new URL((String)it2.next());
                it2.remove();
                profileList.add(new StandardClientProfile(xmlrpcKit){

                    public LockInfo getLockInfo() throws IOException {
                        return LockInfo.readLockFile(lockUrl);
                    }

                    public String toString() {
                        return lockUrl.toString();
                    }
                });
                continue;
            }
            if (arg.equals("-keys") && it2.hasNext()) {
                URL url;
                it2.remove();
                String endpoint = (String)it2.next();
                try {
                    url = new URL(endpoint);
                }
                catch (MalformedURLException e) {
                    System.err.println("Not a URL: " + endpoint);
                    System.err.println(usage);
                    return 1;
                }
                it2.remove();
                if (!it2.hasNext()) {
                    System.err.println(usage);
                    return 1;
                }
                final String secret = (String)it2.next();
                it2.remove();
                profileList.add(new StandardClientProfile(xmlrpcKit){

                    public LockInfo getLockInfo() throws IOException {
                        return new LockInfo(secret, url.toString());
                    }

                    public String toString() {
                        return url.toString();
                    }
                });
                continue;
            }
            if (arg.equals("-profile") && it2.hasNext()) {
                ClientProfile profile;
                it2.remove();
                String cname = (String)it2.next();
                it2.remove();
                try {
                    profile = (ClientProfile)Class.forName(cname).newInstance();
                }
                catch (Exception e) {
                    System.err.println("Error instantiating class " + cname + "; " + e);
                    System.err.println(usage);
                    return 1;
                }
                profileList.add(profile);
                continue;
            }
            it2.remove();
            System.err.println(usage);
            return 1;
        }
        if (!$assertionsDisabled && !argList.isEmpty()) {
            throw new AssertionError();
        }
        ClientProfile[] profiles = profileList.toArray(new ClientProfile[0]);
        if (profiles.length < 2) {
            System.err.println((profiles.length == 0 ? "No" : "Only one") + " hub specified - no bridging to be done");
            if (args.length == 0) {
                System.err.println(usage);
            }
            return 1;
        }
        boolean allLocal = true;
        String[] hosts = new String[profiles.length];
        for (int ip = 0; ip < profiles.length; ++ip) {
            URL xurl;
            ClientProfile profile = profiles[ip];
            String host = null;
            if (profile == standardProfile) {
                host = SampUtils.getLocalhost();
            } else if (profile instanceof StandardClientProfile && (xurl = ((StandardClientProfile)profile).getLockInfo().getXmlrpcUrl()) != null) {
                host = xurl.getHost();
            }
            allLocal = allLocal && Bridge.isLocalHost(host);
            hosts[ip] = host;
        }
        if (reqExportUrls == null) {
            if (allLocal) {
                logger_.info("All hubs apparently on local host; no URL exporting will be attempted");
                exporturls = false;
            } else {
                logger_.info("Bridge apparently running between hosts; URL exporting will be attempted");
                exporturls = true;
            }
        } else {
            exporturls = reqExportUrls;
            logger_.info("By request, URL exporting " + (exporturls ? "will" : "will not") + " be attempted");
        }
        Bridge bridge = new Bridge(profiles);
        if (exporturls) {
            for (int ip = 0; ip < profiles.length; ++ip) {
                String host = hosts[ip];
                if (host == null) continue;
                try {
                    InetAddress addr = InetAddress.getByName(host);
                    if (addr.isLoopbackAddress()) {
                        addr = InetAddress.getByName(SampUtils.getLocalhost());
                    }
                    String ehost = addr.getCanonicalHostName();
                    bridge.exportUrls(ip, ehost);
                    continue;
                }
                catch (UnknownHostException e) {
                    logger_.log(Level.WARNING, "Can't export URLs for host " + host, e);
                }
            }
        }
        if (!bridge.start()) {
            System.err.println("Couldn't contact all hubs");
            return 1;
        }
        try {
            Bridge bridge2 = bridge;
            synchronized (bridge2) {
                while (bridge.getConnectionCount() > 1) {
                    bridge.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return 0;
    }

    static {
        $assertionsDisabled = !Bridge.class.desiredAssertionStatus();
        logger_ = Logger.getLogger(Bridge.class.getName());
    }
}

