/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.gui.SampThread;
import org.astrogrid.samp.hub.BasicHubService;
import org.astrogrid.samp.hub.HubClient;

class HubClientPopupListener
implements MouseListener {
    private final BasicHubService hub_;
    private static final Message PING_MSG = new Message("samp.app.ping");

    public HubClientPopupListener(BasicHubService hub) {
        this.hub_ = hub;
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        this.maybeShowPopup(evt);
    }

    public void mouseReleased(MouseEvent evt) {
        this.maybeShowPopup(evt);
    }

    private void maybeShowPopup(MouseEvent evt) {
        Object item;
        JList jlist;
        int index;
        if (evt.isPopupTrigger() && evt.getSource() instanceof JList && (index = (jlist = (JList)evt.getSource()).locationToIndex(evt.getPoint())) >= 0 && (item = jlist.getModel().getElementAt(index)) instanceof HubClient) {
            HubClient client = (HubClient)item;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jlist.setSelectedIndex(index);
                }
            });
            Component comp = evt.getComponent();
            JPopupMenu popper = this.createPopup(comp, client);
            popper.show(comp, evt.getX(), evt.getY());
        }
    }

    private JPopupMenu createPopup(Component parent, HubClient client) {
        JPopupMenu popper = new JPopupMenu();
        popper.add(new CallAction(parent, client, "Ping", PING_MSG, true));
        popper.add(new DisconnectAction(parent, client));
        return popper;
    }

    private class CallAction
    extends AbstractAction {
        private final Component parent_;
        private final HubClient client_;
        private final String name_;
        private final Message msg_;
        private final boolean isCall_;

        public CallAction(Component parent, HubClient client, String name, Message msg, boolean isCall) {
            super(name);
            this.parent_ = parent;
            this.client_ = client;
            this.name_ = name;
            this.msg_ = msg;
            this.isCall_ = isCall;
            String mtype = msg.getMType();
            this.putValue("ShortDescription", "Send " + mtype + (isCall ? " call" : " notification") + " to client " + client);
            this.setEnabled(this.client_.isSubscribed(mtype));
        }

        public void actionPerformed(ActionEvent evt) {
            final HubConnection connection = HubClientPopupListener.this.hub_.getServiceConnection();
            final String recipientId = this.client_.getId();
            new SampThread(this.parent_, this.name_ + " Error", "Error attempting to send message " + this.msg_.getMType() + " to client " + this.client_){

                protected void sampRun() throws SampException {
                    if (CallAction.this.isCall_) {
                        connection.call(recipientId, CallAction.this.name_ + "-tag", CallAction.this.msg_);
                    } else {
                        connection.notify(recipientId, CallAction.this.msg_);
                    }
                }
            }.start();
        }
    }

    private class DisconnectAction
    extends AbstractAction {
        private final Component parent_;
        private final HubClient client_;

        public DisconnectAction(Component parent, HubClient client) {
            super("Disconnect");
            this.parent_ = parent;
            this.client_ = client;
            this.putValue("ShortDescription", "Forcibly disconnect client " + this.client_ + " from hub");
            this.setEnabled(!client.getId().equals(HubClientPopupListener.this.hub_.getServiceConnection().getRegInfo().getSelfId()));
        }

        public void actionPerformed(ActionEvent evt) {
            new SampThread(this.parent_, "Disconnect Error", "Error disconnecting client " + this.client_){

                protected void sampRun() throws SampException {
                    HubClientPopupListener.this.hub_.disconnect(DisconnectAction.this.client_.getId(), "GUI hub user requested ejection");
                }
            }.start();
        }
    }
}

