/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Metadata;

public class IconStore {
    private final Icon defaultIcon_;
    private static final Map urlIconMap_ = new HashMap();
    private static final Logger logger_ = Logger.getLogger(IconStore.class.getName());

    public IconStore(Icon defaultIcon) {
        this.defaultIcon_ = defaultIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIcon(String url) {
        Icon icon;
        if (!urlIconMap_.containsKey(url)) {
            try {
                icon = IconStore.readIcon(url, 5);
                Map map = urlIconMap_;
                synchronized (map) {
                    urlIconMap_.put(url, icon);
                }
            }
            catch (IOException e) {
                logger_.warning("Icon not found \"" + url + "\" " + e);
                Map map = urlIconMap_;
                synchronized (map) {
                    urlIconMap_.put(url, this.defaultIcon_);
                }
            }
        }
        if ((icon = (Icon)urlIconMap_.get(url)).getIconWidth() < 0) {
            icon = this.defaultIcon_;
        }
        return icon;
    }

    public Icon getIcon(Client client) {
        Object url;
        Metadata meta = client.getMetadata();
        if (meta != null && (url = meta.get("samp.icon.url")) instanceof String) {
            return this.getIcon((String)url);
        }
        return this.defaultIcon_;
    }

    public static Icon createEmptyIcon(final int size) {
        return new Icon(){

            public int getIconWidth() {
                return size;
            }

            public int getIconHeight() {
                return size;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
            }
        };
    }

    public static Icon createMinimalIcon(int size) {
        return new Icon(){
            int gap = 2;
            int size = 24;

            public int getIconWidth() {
                return this.size;
            }

            public int getIconHeight() {
                return this.size;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                Color color = g.getColor();
                int nl = 5;
                for (int i = 0; i < nl; ++i) {
                    int lo = this.gap + i;
                    int dim = this.size - 2 * (this.gap + i);
                    if (dim <= 0) break;
                    int glevel = 255 * (i + 1) / (nl + 1);
                    g.setColor(new Color(glevel, glevel, glevel));
                    g.drawRect(x + lo, y + lo, dim, dim);
                }
                g.setColor(color);
            }
        };
    }

    static Icon createResourceIcon(String fileName) {
        String relLoc;
        URL resource = Client.class.getResource(relLoc = "images/" + fileName);
        if (resource != null) {
            return new ImageIcon(resource);
        }
        logger_.warning("Failed to load icon " + relLoc);
        return new Icon(){

            public int getIconWidth() {
                return 24;
            }

            public int getIconHeight() {
                return 24;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
            }
        };
    }

    public static Icon sizeIcon(Icon icon, final int size) {
        if (icon == null) {
            return new Icon(){

                public int getIconWidth() {
                    return size;
                }

                public int getIconHeight() {
                    return size;
                }

                public void paintIcon(Component c, Graphics g, int x, int y) {
                }
            };
        }
        if (icon.getIconWidth() == size && icon.getIconHeight() == size) {
            return icon;
        }
        return new SizedIcon(icon, size);
    }

    public static Icon scaleIcon(final Icon icon, int fixDim, double maxAspect, boolean fixVertical) {
        double aspect;
        double factor;
        final int w = icon.getIconWidth();
        final int h = icon.getIconHeight();
        if ((fixVertical ? h : w) == fixDim) {
            double d = fixVertical ? (double)h / (double)w : (double)w / (double)h;
            if (d <= maxAspect) {
                return icon;
            }
        }
        if ((factor = (double)fixDim / (double)(fixVertical ? h : w)) > 1.0 && factor < 2.0) {
            factor = 1.0;
        }
        if ((aspect = factor * (double)(fixVertical ? h : w) / (double)fixDim) > maxAspect) {
            factor *= maxAspect / aspect;
        }
        final int width = fixVertical ? (int)Math.ceil(factor * (double)w) : fixDim;
        final int height = fixVertical ? fixDim : (int)Math.ceil(factor * (double)h);
        final double fact = factor;
        return new Icon(){

            public int getIconWidth() {
                return width;
            }

            public int getIconHeight() {
                return height;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (fact == 1.0) {
                    icon.paintIcon(c, g, x + (width - w) / 2, y + (height - h) / 2);
                } else {
                    Graphics2D g2 = (Graphics2D)g;
                    AffineTransform trans = g2.getTransform();
                    g2.translate((double)x + ((double)width - (double)w * fact) / 2.0, (double)y + ((double)height - (double)h * fact) / 2.0);
                    g2.scale(fact, fact);
                    icon.paintIcon(c, g2, 0, 0);
                    g2.setTransform(trans);
                }
            }
        };
    }

    private static Icon readIcon(String url, int waitSecs) throws IOException {
        final URL urlLoc = new URL(url);
        final Icon[] icons = new Icon[1];
        Thread loader = new Thread("IconLoader " + url){

            public void run() {
                icons[0] = new ImageIcon(urlLoc);
            }
        };
        loader.start();
        try {
            loader.join(waitSecs * 1000);
            Icon icon = icons[0];
            if (icon != null) {
                return icon;
            }
            throw new IOException("Icon load timeout (" + waitSecs + "s)");
        }
        catch (InterruptedException e) {
            throw (IOException)new IOException("Load interrupted").initCause(e);
        }
    }

    private static class SizedIcon
    implements Icon {
        private final Icon icon_;
        private final int size_;
        private final double factor_;

        public SizedIcon(Icon icon, int size) {
            this.icon_ = icon;
            this.size_ = size;
            this.factor_ = Math.min(1.0, Math.min((double)size / (double)icon.getIconWidth(), (double)size / (double)icon.getIconHeight()));
        }

        public int getIconWidth() {
            return this.size_;
        }

        public int getIconHeight() {
            return this.size_;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int iw = this.icon_.getIconWidth();
            int ih = this.icon_.getIconHeight();
            if (this.factor_ == 1.0) {
                this.icon_.paintIcon(c, g, x + (this.size_ - iw) / 2, y + (this.size_ - ih) / 2);
            } else {
                Graphics2D g2 = (Graphics2D)g;
                AffineTransform trans = g2.getTransform();
                g2.translate((double)x + ((double)this.size_ - (double)iw * this.factor_) / 2.0, (double)y + ((double)this.size_ - (double)ih * this.factor_) / 2.0);
                g2.scale(this.factor_, this.factor_);
                this.icon_.paintIcon(c, g2, 0, 0);
                g2.setTransform(trans);
            }
        }
    }
}

