/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.util.Arrays;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.astrogrid.samp.Client;

public abstract class SelectiveClientListModel
extends AbstractListModel {
    private final ListModel baseModel_;
    private final ListDataListener listDataListener_;
    private int[] map_;

    public SelectiveClientListModel(ListModel clientListModel) {
        this.baseModel_ = clientListModel;
        this.listDataListener_ = new ListDataListener(){

            public void contentsChanged(ListDataEvent evt) {
                int[] oldMap = SelectiveClientListModel.this.map_;
                SelectiveClientListModel.access$002(SelectiveClientListModel.this, SelectiveClientListModel.this.calculateMap());
                if (Arrays.equals(oldMap, SelectiveClientListModel.this.map_) && evt.getIndex0() == evt.getIndex1() && evt.getIndex0() >= 0) {
                    int index = evt.getIndex0();
                    for (int i = 0; i < SelectiveClientListModel.this.map_.length; ++i) {
                        if (SelectiveClientListModel.this.map_[i] != index) continue;
                        SelectiveClientListModel.this.fireContentsChanged(this, index, index);
                    }
                } else {
                    SelectiveClientListModel.this.fireContentsChanged(this, -1, -1);
                }
            }

            public void intervalAdded(ListDataEvent evt) {
                int[] oldMap = SelectiveClientListModel.this.map_;
                SelectiveClientListModel.access$002(SelectiveClientListModel.this, SelectiveClientListModel.this.calculateMap());
                if (!Arrays.equals(oldMap, SelectiveClientListModel.this.map_)) {
                    int leng = Math.min(SelectiveClientListModel.this.map_.length, oldMap.length);
                    int index0 = -1;
                    for (int i = 0; i < leng; ++i) {
                        if (oldMap[i] == SelectiveClientListModel.this.map_[i]) continue;
                        index0 = i;
                        break;
                    }
                    int index1 = -1;
                    for (int i = 0; i < leng; ++i) {
                        if (oldMap[oldMap.length - 1 - i] == SelectiveClientListModel.this.map_[SelectiveClientListModel.this.map_.length - 1 - i]) continue;
                        index1 = SelectiveClientListModel.this.map_.length - 1 - i;
                        break;
                    }
                    if (index0 >= 0 && index1 >= 0) {
                        SelectiveClientListModel.this.fireIntervalAdded(this, index0, index1);
                    } else {
                        SelectiveClientListModel.this.fireContentsChanged(this, -1, -1);
                    }
                }
            }

            public void intervalRemoved(ListDataEvent evt) {
                int[] oldMap = SelectiveClientListModel.this.map_;
                SelectiveClientListModel.access$002(SelectiveClientListModel.this, SelectiveClientListModel.this.calculateMap());
                if (!Arrays.equals(oldMap, SelectiveClientListModel.this.map_)) {
                    SelectiveClientListModel.this.fireContentsChanged(this, -1, -1);
                }
            }
        };
    }

    protected abstract boolean isIncluded(Client var1);

    protected void init() {
        this.refresh();
        this.baseModel_.addListDataListener(this.listDataListener_);
    }

    protected void refresh() {
        this.map_ = this.calculateMap();
    }

    public int getSize() {
        return this.map_.length;
    }

    public Object getElementAt(int index) {
        return this.baseModel_.getElementAt(this.map_[index]);
    }

    public void dispose() {
        this.baseModel_.removeListDataListener(this.listDataListener_);
    }

    private int[] calculateMap() {
        int nc = this.baseModel_.getSize();
        int[] map = new int[nc];
        int ij = 0;
        for (int ic = 0; ic < nc; ++ic) {
            Client client = (Client)this.baseModel_.getElementAt(ic);
            if (!this.isIncluded(client)) continue;
            map[ij++] = ic;
        }
        int[] map1 = new int[ij];
        System.arraycopy(map, 0, map1, 0, ij);
        return map1;
    }

    static /* synthetic */ int[] access$002(SelectiveClientListModel x0, int[] x1) {
        x0.map_ = x1;
        return x1;
    }
}

