/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.DefaultClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.gui.HubMonitor;
import org.astrogrid.samp.test.Calculator;
import org.astrogrid.samp.test.TestException;
import org.astrogrid.samp.test.Tester;

public class CalcStorm {
    private final ClientProfile profile_;
    private final Random random_;
    private final int nClient_;
    private final int nQuery_;
    private final Calculator.SendMode sendMode_;
    private static final Logger logger_ = Logger.getLogger(CalcStorm.class.getName());

    public CalcStorm(ClientProfile profile, Random random, int nClient, int nQuery, Calculator.SendMode sendMode) {
        this.profile_ = profile;
        this.random_ = random;
        this.nClient_ = nClient;
        this.nQuery_ = nQuery;
        this.sendMode_ = sendMode;
    }

    public void run() throws IOException {
        int ic;
        Calculator[] calcs = new Calculator[this.nClient_];
        final String[] ids = new String[this.nClient_];
        Random[] randoms = new Random[this.nClient_];
        for (int ic2 = 0; ic2 < this.nClient_; ++ic2) {
            HubConnection conn = this.profile_.register();
            if (conn == null) {
                throw new IOException("No hub is running");
            }
            randoms[ic2] = new Random(this.random_.nextLong());
            ids[ic2] = conn.getRegInfo().getSelfId();
            calcs[ic2] = new Calculator(conn, randoms[ic2]);
        }
        Thread[] calcThreads = new Thread[this.nClient_];
        final Throwable[] errors = new Throwable[1];
        for (ic = 0; ic < this.nClient_; ++ic) {
            final Calculator calc = calcs[ic];
            final Random random = randoms[ic];
            calcThreads[ic] = new Thread("Calc" + ic){

                public void run() {
                    try {
                        for (int iq = 0; iq < CalcStorm.this.nQuery_ && errors[0] == null; ++iq) {
                            calc.sendMessage(ids[random.nextInt(CalcStorm.this.nClient_)], CalcStorm.this.sendMode_);
                        }
                        calc.flush();
                    }
                    catch (Throwable e) {
                        errors[0] = e;
                    }
                }
            };
        }
        for (ic = 0; ic < this.nClient_; ++ic) {
            calcThreads[ic].start();
        }
        try {
            for (ic = 0; ic < this.nClient_; ++ic) {
                calcThreads[ic].join();
            }
        }
        catch (InterruptedException e) {
            throw new TestException("Interrupted", e);
        }
        if (this.sendMode_ == Calculator.NOTIFY_MODE || this.sendMode_ == Calculator.RANDOM_MODE) {
            boolean done = false;
            while (!done) {
                int totCalc = 0;
                for (int ic3 = 0; ic3 < this.nClient_; ++ic3) {
                    totCalc += calcs[ic3].getReceiveCount();
                }
                done = totCalc >= this.nClient_ * this.nQuery_;
                if (done) continue;
                Thread.yield();
            }
        }
        for (ic = 0; ic < this.nClient_; ++ic) {
            calcs[ic].getConnection().unregister();
        }
        if (errors[0] != null) {
            throw new TestException("Error in calculator thread: " + errors[0].getMessage(), errors[0]);
        }
        int totCalc = 0;
        for (int ic4 = 0; ic4 < this.nClient_; ++ic4) {
            Calculator calc = calcs[ic4];
            Tester.assertEquals(this.nQuery_, calc.getSendCount());
            totCalc += calc.getReceiveCount();
        }
        Tester.assertEquals(totCalc, this.nClient_ * this.nQuery_);
    }

    public static int runMain(String[] args) throws IOException {
        JFrame frame;
        String usage = "\n   Usage:" + "\n      " + CalcStorm.class.getName() + "\n           " + " [-help]" + " [-/+verbose]" + "\n           " + " [-gui]" + " [-nclient <n>]" + " [-nquery <n>]" + "\n           " + " [-mode sync|async|notify|random]" + "\n";
        Random random = new Random(2333333L);
        int nClient = 20;
        int nQuery = 100;
        Calculator.SendMode sendMode = Calculator.RANDOM_MODE;
        int verbAdjust = 0;
        boolean gui = false;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        try {
            Iterator it = argList.iterator();
            while (it.hasNext()) {
                String arg = (String)it.next();
                if (arg.startsWith("-nc") && it.hasNext()) {
                    it.remove();
                    String snc = (String)it.next();
                    it.remove();
                    nClient = Integer.parseInt(snc);
                    continue;
                }
                if (arg.startsWith("-nq") && it.hasNext()) {
                    it.remove();
                    String snq = (String)it.next();
                    it.remove();
                    nQuery = Integer.parseInt(snq);
                    continue;
                }
                if (arg.equals("-mode") && it.hasNext()) {
                    Calculator.SendMode sm;
                    it.remove();
                    String smode = (String)it.next();
                    it.remove();
                    if (smode.toLowerCase().startsWith("sync")) {
                        sm = Calculator.SYNCH_MODE;
                    } else if (smode.toLowerCase().startsWith("async")) {
                        sm = Calculator.ASYNCH_MODE;
                    } else if (smode.toLowerCase().startsWith("notif")) {
                        sm = Calculator.NOTIFY_MODE;
                    } else if (smode.toLowerCase().startsWith("rand")) {
                        sm = Calculator.RANDOM_MODE;
                    } else {
                        System.err.println(usage);
                        return 1;
                    }
                    sendMode = sm;
                    continue;
                }
                if (arg.equals("-gui")) {
                    it.remove();
                    gui = true;
                    continue;
                }
                if (arg.equals("-nogui")) {
                    it.remove();
                    gui = false;
                    continue;
                }
                if (arg.startsWith("-v")) {
                    it.remove();
                    --verbAdjust;
                    continue;
                }
                if (arg.startsWith("+v")) {
                    it.remove();
                    ++verbAdjust;
                    continue;
                }
                if (arg.startsWith("-h")) {
                    System.out.println(usage);
                    return 0;
                }
                System.err.println(usage);
                return 1;
            }
        }
        catch (RuntimeException e) {
            System.err.println(usage);
            return 1;
        }
        if (!argList.isEmpty()) {
            System.err.println(usage);
            return 1;
        }
        int logLevel = Level.WARNING.intValue() + 100 * verbAdjust;
        Logger.getLogger("org.astrogrid.samp").setLevel(Level.parse(Integer.toString(logLevel)));
        ClientProfile profile = DefaultClientProfile.getProfile();
        if (gui) {
            frame = new JFrame("CalcStorm Monitor");
            frame.getContentPane().add(new HubMonitor(profile, true, 1));
            frame.pack();
            frame.setVisible(true);
        } else {
            frame = null;
        }
        long start = System.currentTimeMillis();
        new CalcStorm(profile, random, nClient, nQuery, sendMode).run();
        long time = System.currentTimeMillis() - start;
        System.out.println("Elapsed time: " + time + " ms (" + (int)((double)time * 1000.0 / (double)(nClient * nQuery)) + " us per message)");
        if (frame != null) {
            frame.dispose();
        }
        return 0;
    }

    public static void main(String[] args) throws IOException {
        int status = CalcStorm.runMain(args);
        if (status != 0) {
            System.exit(status);
        }
    }
}

