/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.web.Callback;

abstract class ClientCallbackOperation {
    private final String fqName_;
    private final Class[] sampSig_;
    private static final Map OPERATION_MAP = ClientCallbackOperation.createOperationMap();

    private ClientCallbackOperation(String methodName, Class[] sampSig) {
        this.fqName_ = "" + methodName;
        this.sampSig_ = sampSig;
    }

    abstract void dispatch(CallableClient var1, List var2) throws Exception;

    public static void invoke(Callback callback, CallableClient client) throws Exception {
        callback.check();
        String methodName = callback.getMethodName();
        List paramList = callback.getParams();
        ClientCallbackOperation op = (ClientCallbackOperation)OPERATION_MAP.get(methodName);
        if (op == null) {
            throw new UnsupportedOperationException("Unknown callback operation " + methodName);
        }
        boolean sigOk = op.sampSig_.length == paramList.size();
        for (int i = 0; sigOk && i < op.sampSig_.length; ++i) {
            sigOk = sigOk && op.sampSig_[i].isAssignableFrom(paramList.get(i).getClass());
        }
        if (!sigOk) {
            throw new IllegalArgumentException(methodName + " callback signature mismatch");
        }
        op.dispatch(client, paramList);
    }

    private static Map createOperationMap() {
        ClientCallbackOperation[] operations = new ClientCallbackOperation[]{new ClientCallbackOperation("receiveNotification", new Class[]{String.class, Map.class}){

            public void dispatch(CallableClient client, List params) throws Exception {
                client.receiveNotification((String)params.get(0), new Message((Map)params.get(1)));
            }
        }, new ClientCallbackOperation("receiveCall", new Class[]{String.class, String.class, Map.class}){

            public void dispatch(CallableClient client, List params) throws Exception {
                client.receiveCall((String)params.get(0), (String)params.get(1), new Message((Map)params.get(2)));
            }
        }, new ClientCallbackOperation("receiveResponse", new Class[]{String.class, String.class, Map.class}){

            public void dispatch(CallableClient client, List params) throws Exception {
                client.receiveResponse((String)params.get(0), (String)params.get(1), new Response((Map)params.get(2)));
            }
        }};
        HashMap<String, ClientCallbackOperation> opMap = new HashMap<String, ClientCallbackOperation>();
        for (int i = 0; i < operations.length; ++i) {
            ClientCallbackOperation op = operations[i];
            opMap.put(op.fqName_, op);
        }
        return Collections.unmodifiableMap(opMap);
    }
}

