/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.web.OriginAuthorizer;

public class CorsHttpServer
extends HttpServer {
    private final OriginAuthorizer authorizer_;
    private static final String ORIGIN_KEY = "Origin";
    private static final String ALLOW_ORIGIN_KEY = "Access-Control-Allow-Origin";
    private static final String REQUEST_METHOD_KEY = "Access-Control-Request-Method";
    private static final String ALLOW_METHOD_KEY = "Access-Control-Allow-Methods";
    private static final String ALLOW_HEADERS_KEY = "Access-Control-Allow-Headers";
    private static final String REQUEST_PRIVATE_NETWORK_KEY = "Access-Control-Request-Private-Network";
    private static final String ALLOW_PRIVATE_NETWORK_KEY = "Access-Control-Allow-Private-Network";
    private static final Pattern ORIGIN_REGEX = Pattern.compile("[A-Za-z][A-Za-z0-9+.-]*://.+");
    private static final InetAddress localHostAddress_ = CorsHttpServer.getLocalHostAddress();
    private static final Logger logger_ = Logger.getLogger(CorsHttpServer.class.getName());
    public static final String EXTRAHOSTS_PROP = "jsamp.web.extrahosts";
    private static final Set extraAddrSet_ = new HashSet<InetAddress>(Arrays.asList(CorsHttpServer.getExtraHostAddresses()));

    public CorsHttpServer(ServerSocket socket, OriginAuthorizer authorizer) throws IOException {
        super(socket);
        this.authorizer_ = authorizer;
    }

    public HttpServer.Response serve(HttpServer.Request request) {
        if (!this.isPermittedHost(request.getRemoteAddress())) {
            return CorsHttpServer.createNonLocalErrorResponse(request);
        }
        Map hdrMap = request.getHeaderMap();
        String method = request.getMethod();
        String originTxt = CorsHttpServer.getHeader(hdrMap, ORIGIN_KEY);
        if (originTxt != null) {
            String reqMethod = CorsHttpServer.getHeader(hdrMap, REQUEST_METHOD_KEY);
            if (method.equals("OPTIONS") && reqMethod != null) {
                return this.servePreflightOriginRequest(request, originTxt, reqMethod);
            }
            return this.serveSimpleOriginRequest(request, originTxt);
        }
        return super.serve(request);
    }

    private HttpServer.Response serveSimpleOriginRequest(HttpServer.Request request, String originTxt) {
        Map headerMap;
        HttpServer.Response response = super.serve(request);
        if (this.isAuthorized(originTxt) && CorsHttpServer.getHeader(headerMap = response.getHeaderMap(), ALLOW_ORIGIN_KEY) == null) {
            headerMap.put(ALLOW_ORIGIN_KEY, originTxt);
        }
        return response;
    }

    private HttpServer.Response servePreflightOriginRequest(HttpServer.Request request, String originTxt, String reqMethod) {
        LinkedHashMap<String, String> hdrMap = new LinkedHashMap<String, String>();
        hdrMap.put("Content-Length", "0");
        if (this.isAuthorized(originTxt)) {
            hdrMap.put(ALLOW_ORIGIN_KEY, originTxt);
            hdrMap.put(ALLOW_METHOD_KEY, reqMethod);
            hdrMap.put(ALLOW_HEADERS_KEY, "Content-Type");
        }
        if ("true".equals(CorsHttpServer.getHeader(request.getHeaderMap(), REQUEST_PRIVATE_NETWORK_KEY))) {
            hdrMap.put(ALLOW_PRIVATE_NETWORK_KEY, "true");
        }
        return new HttpServer.Response(200, "OK", hdrMap){

            public void writeBody(OutputStream out) {
            }
        };
    }

    public static HttpServer.Response createNonLocalErrorResponse(HttpServer.Request request) {
        byte[] mbuf;
        int status = 403;
        String msg = "Forbidden";
        String method = request.getMethod();
        if ("HEAD".equals(method)) {
            return CorsHttpServer.createErrorResponse(status, msg);
        }
        LinkedHashMap<String, String> hdrMap = new LinkedHashMap<String, String>();
        hdrMap.put("Content-Type", "text/plain");
        try {
            mbuf = "Access to server from non-local hosts is not permitted.\r\n".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger_.warning("Unsupported UTF-8??");
            mbuf = new byte[]{};
        }
        final byte[] mbuf1 = mbuf;
        hdrMap.put("Content-Length", Integer.toString(mbuf1.length));
        return new HttpServer.Response(status, msg, hdrMap){

            public void writeBody(OutputStream out) throws IOException {
                out.write(mbuf1);
                out.flush();
            }
        };
    }

    private boolean isAuthorized(String originTxt) {
        boolean hasLegalOrigin;
        try {
            CorsHttpServer.checkOriginList(originTxt);
            hasLegalOrigin = true;
        }
        catch (RuntimeException e) {
            logger_.warning("Origin header: " + e.getMessage());
            hasLegalOrigin = false;
        }
        return hasLegalOrigin && this.authorizer_.authorize(originTxt);
    }

    public boolean isPermittedHost(SocketAddress address) {
        return CorsHttpServer.isLocalHost(address) || CorsHttpServer.isExtraHost(address);
    }

    public static boolean isLocalHost(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetAddress iAddress = ((InetSocketAddress)address).getAddress();
            return iAddress != null && (iAddress.isLoopbackAddress() || iAddress.equals(localHostAddress_));
        }
        return false;
    }

    private static InetAddress getLocalHostAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            logger_.log(Level.WARNING, "Can't determine local host address", e);
            return null;
        }
    }

    private static InetAddress[] getExtraHostAddresses() {
        String list;
        try {
            list = System.getProperty(EXTRAHOSTS_PROP);
        }
        catch (SecurityException e) {
            list = null;
        }
        String[] names = list != null ? ((list = list.trim()).length() > 0 ? list.split(", *") : new String[]{}) : new String[]{};
        int naddr = names.length;
        ArrayList<InetAddress> addrList = new ArrayList<InetAddress>();
        for (int i = 0; i < naddr; ++i) {
            String name = names[i];
            try {
                addrList.add(InetAddress.getByName(name));
                logger_.warning("Adding web hub exception for host \"" + name + "\"");
                continue;
            }
            catch (UnknownHostException e) {
                logger_.warning("Unknown host \"" + name + "\" - not adding web hub exception");
            }
        }
        return addrList.toArray(new InetAddress[0]);
    }

    public static boolean isExtraHost(SocketAddress addr) {
        return addr instanceof InetSocketAddress && extraAddrSet_.contains(((InetSocketAddress)addr).getAddress());
    }

    private static void checkOriginList(String originTxt) {
        String[] origins = originTxt.split(" +");
        if (origins.length > 0) {
            for (int i = 0; i < origins.length; ++i) {
                if (ORIGIN_REGEX.matcher(origins[i]).matches()) continue;
                throw new IllegalArgumentException("Bad origin syntax: \"" + origins[i] + "\"");
            }
        } else {
            throw new IllegalArgumentException("No origins supplied");
        }
    }
}

