/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.web.OriginAuthorizer;
import org.astrogrid.samp.web.SwingOriginAuthorizer;

public class OriginAuthorizers {
    public static final OriginAuthorizer FALSE = OriginAuthorizers.createFixedOriginAuthorizer(false, false);
    public static final OriginAuthorizer TRUE = OriginAuthorizers.createFixedOriginAuthorizer(true, true);
    public static final OriginAuthorizer SWING = OriginAuthorizers.createMemoryOriginAuthorizer(OriginAuthorizers.createLoggingOriginAuthorizer(new SwingOriginAuthorizer(null), Level.INFO, Level.WARNING));
    private static final Logger logger_ = Logger.getLogger(OriginAuthorizers.class.getName());

    private OriginAuthorizers() {
    }

    public static OriginAuthorizer createFixedOriginAuthorizer(final boolean individualPolicy, final boolean generalPolicy) {
        return new OriginAuthorizer(){

            public boolean authorize(String origin) {
                return individualPolicy;
            }

            public boolean authorizeAll() {
                return generalPolicy;
            }
        };
    }

    public static OriginAuthorizer createLoggingOriginAuthorizer(final OriginAuthorizer auth, final Level acceptLevel, final Level refuseLevel) {
        return new OriginAuthorizer(){

            public synchronized boolean authorize(String origin) {
                boolean accept = auth.authorize(origin);
                this.log(accept, "\"" + origin + "\"");
                return accept;
            }

            public synchronized boolean authorizeAll() {
                boolean accept = auth.authorizeAll();
                this.log(accept, "all origins");
                return accept;
            }

            private void log(boolean accept, String domain) {
                if (accept) {
                    logger_.log(acceptLevel, "Accepted cross-origin requests for " + domain);
                } else {
                    logger_.log(refuseLevel, "Rejected cross-origin requests for " + domain);
                }
            }
        };
    }

    public static OriginAuthorizer createMemoryOriginAuthorizer(final OriginAuthorizer auth) {
        return new OriginAuthorizer(){
            private final OriginAuthorizer baseAuth_;
            private final Set acceptedSet_;
            private final Set refusedSet_;
            private Boolean authorizeAll_;
            {
                this.baseAuth_ = auth;
                this.acceptedSet_ = new HashSet();
                this.refusedSet_ = new HashSet();
            }

            public synchronized boolean authorize(String origin) {
                if (this.refusedSet_.contains(origin)) {
                    return false;
                }
                if (this.acceptedSet_.contains(origin)) {
                    return true;
                }
                boolean accepted = this.baseAuth_.authorize(origin);
                (accepted ? this.acceptedSet_ : this.refusedSet_).add(origin);
                return accepted;
            }

            public synchronized boolean authorizeAll() {
                if (this.authorizeAll_ == null) {
                    this.authorizeAll_ = this.baseAuth_.authorizeAll();
                }
                return this.authorizeAll_;
            }
        };
    }
}

