/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry;

import java.util.ArrayList;
import skyview.Component;
import skyview.geometry.Rotater;
import skyview.geometry.Scaler;
import skyview.geometry.TransformationException;
import skyview.geometry.Transformer;

public class Converter
extends Transformer
implements Component {
    private ArrayList<Transformer> components = new ArrayList();
    private Transformer[] compArr;
    private double[][] datArr;
    private double[] d2 = new double[2];
    private double[] d3 = new double[3];
    private boolean checked = false;
    private static boolean doDebug = false;

    public String getName() {
        return "Converter";
    }

    public String getDescription() {
        return "A compound set of transformations";
    }

    public void printElements() {
        System.err.println("Converter:" + this);
        for (int i = 0; i < this.components.size(); ++i) {
            System.err.println(i + 1 + ":" + this.components.get(i).getName());
        }
    }

    public void debug(boolean flag) {
        doDebug = flag;
    }

    public int getInputDimension() {
        if (this.components.size() > 0) {
            return this.components.get(0).getInputDimension();
        }
        return 0;
    }

    public int getOutputDimension() {
        if (this.components.size() > 0) {
            return this.components.get(this.components.size() - 1).getOutputDimension();
        }
        return 0;
    }

    public void add(Transformer trans) throws TransformationException {
        if (trans == null) {
            return;
        }
        if (this.components.size() > 0 && trans.getInputDimension() != this.getOutputDimension()) {
            throw new TransformationException("Incompatible adjacent components: " + this.components.get(this.components.size() - 1).getName() + " -> " + trans.getName());
        }
        if (trans instanceof Converter) {
            Converter c = (Converter)trans;
            this.components.addAll(c.components);
        } else {
            this.components.add(trans);
        }
        this.checked = false;
    }

    public void transform(double[] in, double[] out) {
        if (!this.checked) {
            this.check();
        }
        if (this.compArr.length == 0) {
            if (in != out) {
                System.arraycopy(in, 0, out, 0, in.length);
            }
            return;
        }
        double[] from = in;
        double[] to = null;
        for (int i = 0; i < this.compArr.length; ++i) {
            Transformer t = this.compArr[i];
            if (doDebug) {
                this.log(i, t, from);
            }
            to = i == this.compArr.length - 1 ? out : this.datArr[i];
            t.transform(from, to);
            from = to;
        }
        if (doDebug && this.compArr.length > 0) {
            this.log(this.compArr.length, null, to);
        }
    }

    private void log(int index, Transformer t, double[] arr) {
        String label;
        if (t == null) {
            label = "Returns:";
        } else {
            label = t.getClass().getName();
            int per = label.lastIndexOf(".");
            if (per > 0) {
                label = label.substring(per + 1);
            }
            label = label + ":";
        }
        if (arr.length == 3) {
            double ra = Math.toDegrees(Math.atan2(arr[1], arr[0]));
            double dec = Math.toDegrees(Math.asin(arr[2]));
            System.err.printf("%2d %-20s %10.5f %10.5f   %10.6f %10.6f %10.5f\n", index, label, ra, dec, arr[0], arr[1], arr[2]);
        } else if (arr.length == 2) {
            System.err.printf("%2d %-20s %10.6f %10.6f   %10.5f %10.5f\n", index, label, arr[0], arr[1], Math.toDegrees(arr[0]), Math.toDegrees(arr[1]));
        } else {
            System.err.printf("%2d %-20s Vector length: %d\n", index, label, arr.length);
        }
    }

    public void check() {
        block0: while (this.components.size() > 0) {
            if (doDebug) {
                System.err.println("Converter: deleter: " + this.components.size());
            }
            Transformer last = this.components.get(0);
            for (int i = 1; i < this.components.size(); ++i) {
                Transformer comb;
                Transformer curr;
                if (doDebug) {
                    System.err.println("Check: compLoop" + i);
                }
                if (last.isInverse(curr = this.components.get(i))) {
                    this.components.remove(i);
                    this.components.remove(i - 1);
                    if (!doDebug) continue block0;
                    System.err.println("inverse");
                    continue block0;
                }
                if (last instanceof Rotater && curr instanceof Rotater) {
                    comb = ((Rotater)last).add((Rotater)curr);
                    this.components.remove(i);
                    this.components.remove(i - 1);
                    this.components.add(i - 1, comb);
                    if (!doDebug) continue block0;
                    System.err.println("rotation");
                    continue block0;
                }
                if (last instanceof Scaler && curr instanceof Scaler) {
                    comb = ((Scaler)last).add((Scaler)curr);
                    this.components.remove(i);
                    this.components.remove(i - 1);
                    this.components.add(i - 1, comb);
                    if (!doDebug) continue block0;
                    System.err.println("scalers");
                    continue block0;
                }
                last = curr;
                if (!doDebug) continue;
                System.err.println("Check: endcomploop");
            }
        }
        this.compArr = this.components.toArray(new Transformer[0]);
        this.datArr = new double[this.compArr.length][];
        for (int i = 0; i < this.datArr.length; ++i) {
            this.datArr[i] = this.compArr[i].getOutputDimension() == 2 ? this.d2 : this.d3;
        }
        this.checked = true;
        if (doDebug) {
            System.err.println("Check: exit " + this.compArr.length);
        }
    }

    public Converter inverse() {
        Converter x = new Converter();
        for (int i = this.components.size() - 1; i >= 0; --i) {
            try {
                x.add(this.components.get(i).inverse());
                continue;
            }
            catch (TransformationException e) {
                return null;
            }
        }
        return x;
    }

    public boolean isInverse(Transformer t) {
        this.check();
        if (t == null && this.components.size() == 0) {
            return true;
        }
        if (!(t instanceof Converter)) {
            if (this.components.size() != 1) {
                return false;
            }
            return this.components.get(0).isInverse(t);
        }
        Converter c = (Converter)t;
        c.check();
        if (c.components.size() != this.components.size()) {
            return false;
        }
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            if (this.components.get(n - i).isInverse(c.components.get(i))) continue;
            return false;
        }
        return true;
    }
}

