/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;

public class Ait
extends Projecter {
    public String getName() {
        return "Ait";
    }

    public String getDescription() {
        return "Project to an Hammer-Aitoff projection (often used for all sky data)";
    }

    public Deprojecter inverse() {
        return new AitDeproj();
    }

    public boolean isInverse(Transformer trans) {
        return trans.getName().equals("AitDeproj");
    }

    public final void transform(double[] sphere, double[] plane) {
        if (Double.isNaN(sphere[2])) {
            plane[0] = Double.NaN;
            plane[1] = Double.NaN;
        } else {
            double cos_l2;
            double cos_b = Math.sqrt(1.0 - sphere[2] * sphere[2]);
            double cos_l = 0.0;
            if (1.0 - Math.abs(sphere[2]) > 1.0E-10) {
                cos_l = sphere[0] / cos_b;
            }
            cos_l2 = (cos_l2 = 0.5 * (1.0 + cos_l)) > 0.0 ? Math.sqrt(cos_l2) : 0.0;
            double sin_l2 = 0.5 * (1.0 - cos_l);
            sin_l2 = sin_l2 > 0.0 ? Math.sqrt(sin_l2) : 0.0;
            if (sphere[1] < 0.0) {
                sin_l2 = -sin_l2;
            }
            double gamma = Math.sqrt(2.0 / (1.0 + cos_b * cos_l2));
            plane[0] = 2.0 * gamma * cos_b * sin_l2;
            plane[1] = gamma * sphere[2];
        }
    }

    public boolean validPosition(double[] plane) {
        return super.validPosition(plane) && plane[0] * plane[0] / 8.0 + plane[1] * plane[1] / 2.0 <= 1.0;
    }

    public class AitDeproj
    extends Deprojecter {
        public String getName() {
            return "AitDeproj";
        }

        public String getDescription() {
            return "Deproject from a Hammer-Aitoff ellipse back to the sphere.";
        }

        public Projecter inverse() {
            return Ait.this;
        }

        public boolean isInverse(Transformer trans) {
            return trans.getName().equals("Ait");
        }

        public final void transform(double[] plane, double[] sphere) {
            if (!Ait.this.validPosition(plane)) {
                sphere[0] = Double.NaN;
                sphere[1] = Double.NaN;
                sphere[2] = Double.NaN;
            } else {
                double z = 1.0 - plane[0] * plane[0] / 16.0 - plane[1] * plane[1] / 4.0;
                z = z > 0.0 ? Math.sqrt(z) : 0.0;
                sphere[2] = plane[1] * z;
                double cos_b = Math.sqrt(1.0 - sphere[2] * sphere[2]);
                if (Math.abs(cos_b) > 1.0E-12) {
                    double sl2 = z * plane[0] / (2.0 * cos_b);
                    double cl2 = (2.0 * z * z - 1.0) / cos_b;
                    double cl = 2.0 * cl2 * cl2 - 1.0;
                    double sl = 2.0 * sl2 * cl2;
                    sphere[0] = cl * cos_b;
                    sphere[1] = sl * cos_b;
                } else {
                    sphere[0] = 0.0;
                    sphere[1] = 0.0;
                }
            }
        }
    }
}

