/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;

public class Stg
extends Projecter {
    public String getName() {
        return "Stg";
    }

    public String getDescription() {
        return "Project from antipodes to a tanget plane touching the sphere";
    }

    public final void transform(double[] sphere, double[] plane) {
        if (Double.isNaN(sphere[2]) || sphere[2] < 0.0) {
            plane[0] = Double.NaN;
            plane[1] = Double.NaN;
        } else {
            double fac = 2.0 / (1.0 + sphere[2]);
            plane[0] = fac * sphere[0];
            plane[1] = fac * sphere[1];
        }
    }

    public boolean allValid() {
        return true;
    }

    public Deprojecter inverse() {
        return new StgDeproj();
    }

    public boolean isInverse(Transformer t) {
        return t.getName().equals("StgDeproj");
    }

    public class StgDeproj
    extends Deprojecter {
        public String getName() {
            return "StgDeproj";
        }

        public String getDescription() {
            return "Transform from the stereoscopic tangent plane to the sphere";
        }

        public Projecter inverse() {
            return Stg.this;
        }

        public boolean isInverse(Transformer t) {
            return t.getName().equals("Stg");
        }

        public final void transform(double[] plane, double[] sphere) {
            if (!Stg.this.validPosition(plane)) {
                sphere[0] = Double.NaN;
                sphere[1] = Double.NaN;
                sphere[2] = Double.NaN;
            } else {
                double z;
                double x = plane[0];
                double y = plane[1];
                double r = Math.sqrt(x * x + y * y);
                double theta = 2.0 * Math.atan2(r, 2.0);
                sphere[2] = z = Math.cos(theta);
                if (Math.abs(z) != 1.0) {
                    sphere[0] = plane[0] * (1.0 + z) / 2.0;
                    sphere[1] = plane[1] * (1.0 + z) / 2.0;
                } else {
                    sphere[0] = 0.0;
                    sphere[1] = 0.0;
                }
            }
        }
    }
}

