/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.gbin;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import uk.ac.starlink.gbin.DefaultGbinTableProfile;
import uk.ac.starlink.gbin.GbinMeta;
import uk.ac.starlink.gbin.GbinMetadataReader;
import uk.ac.starlink.gbin.GbinObjectReader;
import uk.ac.starlink.gbin.GbinStarTable;
import uk.ac.starlink.gbin.GbinTableProfile;
import uk.ac.starlink.gbin.Representation;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.formats.DocumentedTableBuilder;
import uk.ac.starlink.util.ConfigMethod;
import uk.ac.starlink.util.DataSource;

public class GbinTableBuilder
extends DocumentedTableBuilder {
    private final MutableGbinTableProfile profile_;
    public static final ValueInfo CLASSNAME_INFO = new DefaultValueInfo("GbinClass", String.class, "Classname of GBIN objects");
    public static final ValueInfo GAIATABLENAME_INFO = new DefaultValueInfo("GaiaTableName", String.class, "Well-known name of Gaia table");
    public static final ValueInfo DESCRIP_INFO = new DefaultValueInfo("Description", String.class, "Table description from Gaia data model");
    public static final ValueInfo COLDETAIL_INFO = new DefaultValueInfo("GaiaDetail", String.class, "Detailed column description from Gaia data model");
    public static final ValueInfo BUILDDESCRIP_INFO = new DefaultValueInfo("GbinDescription", String.class, "GBIN build description");

    public GbinTableBuilder() {
        this(new DefaultGbinTableProfile());
    }

    public GbinTableBuilder(GbinTableProfile profile) {
        super(new String[]{"gbin"});
        this.profile_ = new MutableGbinTableProfile(profile);
    }

    public GbinTableProfile getProfile() {
        return this.profile_;
    }

    @Override
    public String getFormatName() {
        return "GBIN";
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void streamStarTable(InputStream in, TableSink sink, String pos) throws IOException {
        try {
            GbinObjectReader reader = GbinObjectReader.createReader(in);
            if (!reader.hasNext()) {
                throw new IOException("No objects in GBIN file");
            }
            Object gobj0 = reader.next();
            GbinStarTable table = new GbinStarTable(this.profile_, gobj0.getClass()){

                @Override
                public long getRowCount() {
                    return -1L;
                }

                @Override
                public RowSequence getRowSequence() {
                    throw new UnsupportedOperationException();
                }
            };
            sink.acceptMetadata(table);
            RowSequence rseq = table.createRowSequence(reader, gobj0);
            while (rseq.next()) {
                sink.acceptRow(rseq.getRow());
            }
            sink.endRows();
            rseq.close();
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StarTable makeStarTable(final DataSource datsrc, boolean wantRandom, StoragePolicy storage) throws IOException {
        long nrow;
        if (this.profile_.isTestMagic() && !GbinObjectReader.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Not GBIN");
        }
        BufferedInputStream in = new BufferedInputStream(datsrc.getInputStream());
        GbinObjectReader rdr = GbinObjectReader.createReader(in);
        if (!rdr.hasNext()) {
            throw new IOException("No objects in GBIN file");
        }
        Class<?> gobjClazz = rdr.next().getClass();
        ((InputStream)in).close();
        ArrayList<DescribedValue> params = new ArrayList<DescribedValue>();
        if (this.profile_.isReadMeta()) {
            Long nrowObj;
            try (BufferedInputStream metaIn = new BufferedInputStream(datsrc.getInputStream());){
                Object gbinRdrObj = GbinObjectReader.createGbinReaderObject(metaIn);
                GbinMeta meta = GbinMetadataReader.attemptReadMetadata(gbinRdrObj);
                nrowObj = meta.getTotalElementCount();
                params.add(new DescribedValue(BUILDDESCRIP_INFO, meta.buildDescription(false)));
            }
            nrow = nrowObj == null ? -1L : nrowObj;
        } else {
            nrow = -1L;
        }
        GbinStarTable table = new GbinStarTable(this.profile_, gobjClazz){

            @Override
            public RowSequence getRowSequence() throws IOException {
                final BufferedInputStream in = new BufferedInputStream(datsrc.getInputStream());
                GbinObjectReader reader = GbinObjectReader.createReader(in);
                if (!reader.hasNext()) {
                    throw new IOException("No objects in GBIN file");
                }
                Object gobj0 = reader.next();
                RowSequence baseSeq = this.createRowSequence(reader, gobj0);
                if (nrow >= 0L) {
                    return new WrapperRowSequence(baseSeq){
                        long irow_;

                        @Override
                        public boolean next() throws IOException {
                            boolean isNext = super.next();
                            if (isNext) {
                                ++this.irow_;
                            } else if (this.irow_ != nrow) {
                                String msg = new StringBuffer().append("Too few rows read (").append(this.irow_).append("<").append(nrow).append(") - probable zstd-jni bug").append(" [could try readMeta=false]").toString();
                                throw new IOException(msg);
                            }
                            return isNext;
                        }

                        @Override
                        public void close() throws IOException {
                            in.close();
                        }
                    };
                }
                return new WrapperRowSequence(baseSeq){

                    @Override
                    public void close() throws IOException {
                        in.close();
                    }
                };
            }

            @Override
            public long getRowCount() {
                return nrow;
            }
        };
        for (DescribedValue param : params) {
            table.setParameter(param);
        }
        return table;
    }

    @Override
    public boolean canStream() {
        return true;
    }

    @Override
    public boolean docIncludesExample() {
        return false;
    }

    @Override
    public String getXmlDescription() {
        return this.readText("GbinTableBuilder.xml");
    }

    @ConfigMethod(property="readMeta", doc="<p>Configures whether the GBIN metadata will be read prior to reading the data. This may slow things down slightly, but means the row count can be determined up front, which may have benefits for downstream processing.</p>\n<p>Setting this false can prevent failing on an error related to a broken version of the zStd-jni library in GaiaTools.\nNote however that in this case the data read, though not reporting an error, will silently be missing some rows from the GBIN file.</p>\n", example="false")
    public void setReadMeta(boolean isReadMeta) {
        this.profile_.isReadMeta_ = isReadMeta;
    }

    public boolean getReadMeta() {
        return this.profile_.isReadMeta_;
    }

    @ConfigMethod(property="hierarchicalNames", doc="<p>Configures whether column names in the output table should be forced to reflect the compositional hierarchy of their position in the element objects.\nIf set true, columns will have names like \"<code>Astrometry_Alpha</code>\", if false they may just be called \"<code>Alpha</code>\".\nIn case of name duplication however, the hierarchical form is always used.</p>\n", example="true")
    public void setHierarchicalNames(boolean isHierarchicalNames) {
        this.profile_.isHierarchicalNames_ = isHierarchicalNames;
    }

    public boolean getHierarchicalNames() {
        return this.profile_.isHierarchicalNames_;
    }

    public void setTestMagic(boolean isTestMagic) {
        this.profile_.isTestMagic_ = isTestMagic;
    }

    public void isSortedMethods(boolean isSortedMethods) {
        this.profile_.isSortedMethods_ = isSortedMethods;
    }

    private static class MutableGbinTableProfile
    implements GbinTableProfile {
        private final GbinTableProfile base_;
        boolean isReadMeta_;
        boolean isTestMagic_;
        boolean isHierarchicalNames_;
        boolean isSortedMethods_;

        public MutableGbinTableProfile(GbinTableProfile base) {
            this.base_ = base;
            this.isReadMeta_ = base.isReadMeta();
            this.isTestMagic_ = base.isTestMagic();
            this.isHierarchicalNames_ = base.isHierarchicalNames();
            this.isSortedMethods_ = base.isSortedMethods();
        }

        @Override
        public boolean isReadMeta() {
            return this.isReadMeta_;
        }

        @Override
        public boolean isTestMagic() {
            return this.isTestMagic_;
        }

        @Override
        public boolean isHierarchicalNames() {
            return this.isHierarchicalNames_;
        }

        @Override
        public boolean isSortedMethods() {
            return this.isSortedMethods_;
        }

        @Override
        public String getNameSeparator() {
            return this.base_.getNameSeparator();
        }

        @Override
        public String[] getIgnoreMethodNames() {
            return this.base_.getIgnoreMethodNames();
        }

        @Override
        public String[] getIgnoreMethodDeclaringClasses() {
            return this.base_.getIgnoreMethodDeclaringClasses();
        }

        @Override
        public Representation<?> createRepresentation(Class<?> clazz) {
            return this.base_.createRepresentation(clazz);
        }
    }
}

