/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Moc;
import cds.moc.Moc1D;
import cds.moc.MocCell;
import cds.moc.Range;
import cds.moc.Range2;
import cds.moc.SMoc;
import java.io.OutputStream;
import java.util.Iterator;

public abstract class Moc2D
extends Moc {
    public Range2 range;
    protected Moc1D protoDim1;
    protected Moc1D protoDim2;
    public static long MASK_T = Long.MIN_VALUE;
    public static long UNMASK_T = MASK_T ^ 0xFFFFFFFFFFFFFFFFL;
    private StringBuilder buf = null;
    private Moc1D moc1 = null;
    private boolean inDim1 = false;

    protected Moc2D(Moc1D protoDim1, Moc1D protoDim2) {
        this.protoDim1 = protoDim1;
        this.protoDim2 = protoDim2;
        this.clear();
    }

    @Override
    public String toDebug() {
        this.flush();
        String so1 = "" + this.getMocOrder1();
        if (this.protoDim1.mocOrder == -1) {
            so1 = "(" + so1 + ")";
        }
        char c1 = Character.toUpperCase(this.cDim1());
        String so2 = "" + this.getMocOrder2();
        if (this.protoDim2.mocOrder == -1) {
            so2 = "(" + so2 + ")";
        }
        char c2 = Character.toUpperCase(this.cDim2());
        return String.valueOf(c1) + c2 + "MOC mocOrder=" + so1 + "/" + so2 + " nbRanges=" + this.getNbRanges() + " nbCells=" + this.getNbCells() + " mem=" + Moc2D.getUnitDisk(this.getMem()) + " => " + this.lowAscii(4);
    }

    protected String lowAscii(int n) {
        StringBuilder s = new StringBuilder();
        n *= 2;
        boolean flagCont = false;
        int i = 0;
        while (i < this.range.sz && i < n) {
            String t;
            if (s.length() > 0) {
                s.append(' ');
            }
            String string = t = flagCont ? "" : "t";
            if (this.range.r[i + 1] - 1L == this.range.r[i]) {
                s.append(String.valueOf(t) + this.range.r[i]);
            } else {
                s.append(String.valueOf(t) + this.range.r[i] + "-" + (this.range.r[i + 1] - 1L));
            }
            if (i < this.range.sz - 2 && this.range.rr[i / 2].equals(this.range.rr[i / 2 + 1])) {
                flagCont = true;
            } else {
                flagCont = false;
                SMoc m = new SMoc();
                m.setRangeList(this.range.rr[i / 2]);
                s.append(" s" + m.lowAscii(3));
            }
            i += 2;
        }
        if (i != this.range.sz) {
            s.append("...");
        }
        return s.toString();
    }

    public int maxOrder1() {
        return this.protoDim1.maxOrder();
    }

    public int maxOrder2() {
        return this.protoDim2.maxOrder();
    }

    public int shiftOrder1() {
        return this.protoDim1.shiftOrder();
    }

    public int shiftOrder2() {
        return this.protoDim2.shiftOrder();
    }

    public char cDim1() {
        return this.protoDim1.cDim();
    }

    public char cDim2() {
        return this.protoDim2.cDim();
    }

    @Override
    public Range seeRangeList() {
        this.flush();
        return this.range;
    }

    @Override
    public void setRangeList(Range range) {
        this.range = (Range2)range;
    }

    public int getMocOrder1() {
        return this.protoDim1.getMocOrder();
    }

    public int getMocOrder2() {
        return this.protoDim2.getMocOrder();
    }

    public void setMocOrder(int order1, int order2) throws Exception {
        if (order1 < -1 || order1 > this.protoDim1.maxOrder()) {
            throw new Exception("MocOrder error (" + order1 + " not in [0.." + this.protoDim1.maxOrder() + "])");
        }
        if (order2 < -1 || order2 > this.protoDim2.maxOrder()) {
            throw new Exception("MocOrder error (" + order2 + " not in [0.." + this.protoDim2.maxOrder() + "])");
        }
        if (order1 != -1 || order2 != -1) {
            if (order1 != -1 && this.protoDim1.mocOrder == -1) {
                this.protoDim1.mocOrder = this.protoDim1.maxOrder();
            }
            if (order2 != -1 && this.protoDim2.mocOrder == -1) {
                this.protoDim2.mocOrder = this.protoDim2.maxOrder();
            }
            if (order1 < this.protoDim1.mocOrder || order2 < this.protoDim2.mocOrder) {
                int shift1 = order1 == -1 ? 0 : this.protoDim1.maxOrder() - order1;
                int shift2 = order2 == -1 ? 0 : this.protoDim2.maxOrder() - order2;
                this.range = this.range.degrade(shift1 * this.protoDim1.shiftOrder(), shift2 * this.protoDim2.shiftOrder());
                this.resetCache();
            }
        }
        this.protoDim1.mocOrder = order1;
        this.protoDim2.mocOrder = order2;
    }

    public void setMocOrder1(int order1) throws Exception {
        this.setMocOrder(order1, this.protoDim2.mocOrder);
    }

    public void setMocOrder2(int order2) throws Exception {
        this.setMocOrder(this.protoDim1.mocOrder, order2);
    }

    public long getStart1(int order, long val) {
        return this.protoDim1.getStart(order, val);
    }

    public long getEnd1(int order, long val) {
        return this.protoDim1.getEnd(order, val);
    }

    public long getStart2(int order, long val) {
        return this.protoDim2.getStart(order, val);
    }

    public long getEnd2(int order, long val) {
        return this.protoDim2.getEnd(order, val);
    }

    public void add(long val1, long val2, Range r) {
        int mocOrder1 = this.protoDim1.mocOrder;
        if (mocOrder1 != -1) {
            int shift = (this.maxOrder1() - mocOrder1) * this.shiftOrder1();
            val1 = val1 >>> shift << shift;
            val2 = ((val2 >>> shift) + 1L << shift) - 1L;
        }
        this.range.add(val1, val2 + 1L, r);
        this.resetCache();
    }

    public void add(int order1, long val1, int order2, long val2) throws Exception {
        this.add(order1, val1, val1, order2, val2, val2);
    }

    public void add(int order1, long firstVal1, long lastVal1, int order2, long firstVal2, long lastVal2) throws Exception {
        int shift;
        int mocOrder1 = this.protoDim1.mocOrder;
        if (mocOrder1 != -1 && mocOrder1 < order1) {
            shift = (order1 - mocOrder1) * this.shiftOrder1();
            firstVal1 = firstVal1 >>> shift << shift;
            lastVal1 = ((lastVal1 >>> shift) + 1L << shift) - 1L;
        }
        shift = (this.maxOrder1() - order1) * this.shiftOrder1();
        long start1 = firstVal1 << shift;
        long end1 = lastVal1 + 1L << shift;
        int mocOrder2 = this.protoDim2.mocOrder;
        if (mocOrder2 != -1 && mocOrder2 < order2) {
            shift = (order2 - mocOrder2) * this.shiftOrder2();
            firstVal2 = firstVal2 >>> shift << shift;
            lastVal2 = ((lastVal2 >>> shift) + 1L << shift) - 1L;
        }
        shift = (this.maxOrder2() - order2) * this.shiftOrder2();
        long start2 = firstVal2 << shift;
        long end2 = lastVal2 + 1L << shift;
        Range r = new Range();
        r.append(start2, end2);
        this.range.add(start1, end1, r);
        this.resetCache();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Moc2D)) {
            return false;
        }
        Moc2D moc = (Moc2D)o;
        if (this.cDim1() != moc.cDim1()) {
            return false;
        }
        if (this.cDim2() != moc.cDim2()) {
            return false;
        }
        return this.range.equals(((Moc2D)o).range);
    }

    public int hashCode() {
        if (this.cacheHashCode == -1) {
            this.cacheHashCode = this.range.hashCode();
        }
        return this.cacheHashCode;
    }

    @Override
    protected void clone1(Moc moc) throws CloneNotSupportedException {
        if (!(moc instanceof Moc2D)) {
            throw new CloneNotSupportedException("Uncompatible type of MOC for clone. Must derived from Moc2D");
        }
        super.clone1(moc);
        Moc2D m = (Moc2D)moc;
        m.protoDim1 = (Moc1D)this.protoDim1.clone();
        m.protoDim2 = (Moc1D)this.protoDim2.clone();
        m.range = this.range == null ? null : new Range2(this.range);
    }

    @Override
    public boolean isEmpty() {
        this.flush();
        return this.range.sz == 0;
    }

    @Override
    public boolean isFull() {
        this.flush();
        if (this.range.sz != 2 || this.range.r[0] != 0L || this.range.r[1] != this.protoDim1.maxVal()) {
            return false;
        }
        Moc1D m = (Moc1D)this.protoDim2.dup();
        m.setRangeList(this.range.rr[0]);
        return m.isFull();
    }

    @Override
    public double getCoverage() {
        return -1.0;
    }

    @Override
    protected void computeHierarchy() {
        this.flush();
        int nb = 0;
        int deep = 0;
        for (MocCell mc : this) {
            nb += mc.moc.getNbCells();
            int d = mc.moc.getDeepestOrder();
            if (d <= deep) continue;
            deep = d;
        }
        this.cacheNbCells = nb;
        this.cacheDeepestOrder = deep;
    }

    @Override
    public int getNbRanges() {
        this.flush();
        return this.range.sz / 2;
    }

    @Override
    public long getMem() {
        this.flush();
        return this.range.getMem();
    }

    @Override
    public void clear() {
        super.clear();
        this.buf = null;
        this.moc1 = null;
        this.inDim1 = false;
        this.range = new Range2();
        if (this.protoDim1 != null) {
            this.protoDim1.sys = null;
        }
        if (this.protoDim2 != null) {
            this.protoDim2.sys = null;
        }
    }

    @Override
    public boolean reduction(long maxSize) throws Exception {
        return this.reduction(maxSize, null);
    }

    public boolean reduction(long maxMB, String priority) throws Exception {
        this.flush();
        boolean rep = false;
        if (maxMB <= 0L) {
            throw new Exception("negative or null size not allowed");
        }
        if (priority == null || priority.trim().length() == 0) {
            int mocOrder1 = this.getMocOrder1();
            int mocOrder2 = this.getMocOrder2();
            priority = (double)mocOrder2 / (double)this.protoDim2.maxOrder() > (double)mocOrder1 / (double)this.protoDim1.maxOrder() ? String.valueOf(this.cDim2()) + this.cDim1() : String.valueOf(this.cDim1()) + this.cDim2();
        }
        while (this.getMem() > maxMB && (this.getMocOrder1() > 0 || this.getMocOrder2() > 0)) {
            char c = priority.charAt(0);
            if (c == this.cDim1() && this.getMocOrder1() > 0) {
                this.setMocOrder1(this.getMocOrder1() - 1);
            } else if (c == this.cDim2() && this.getMocOrder2() > 0) {
                this.setMocOrder2(this.getMocOrder2() - 1);
            } else {
                throw new Exception("Unknown MOC signature [" + c + "]");
            }
            priority = String.valueOf(priority.substring(1)) + c;
            rep = true;
        }
        return rep;
    }

    @Override
    public boolean isCompatible(Moc moc) {
        if (!this.getClass().equals(moc.getClass())) {
            return false;
        }
        Moc2D m = (Moc2D)moc;
        return this.protoDim1.isCompatible(m.protoDim1) && this.protoDim2.isCompatible(m.protoDim2);
    }

    @Override
    protected Moc2D operation(Moc moc, int op) throws Exception {
        if (!this.isCompatible(moc)) {
            throw new Exception("Uncompatible MOC");
        }
        this.flush();
        moc.flush();
        Moc2D m = (Moc2D)moc;
        Moc2D res = (Moc2D)this.dup();
        res.setMocOrder1(this.getMocOrder4op(this.getMocOrder1(), m.getMocOrder1()));
        res.setMocOrder2(this.getMocOrder4op(this.getMocOrder2(), m.getMocOrder2()));
        switch (op) {
            case 0: {
                res.range = this.range.union(m.range);
                break;
            }
            case 1: {
                res.range = this.range.intersection(m.range);
                break;
            }
            case 2: {
                res.range = this.range.difference(m.range);
            }
        }
        res.range.trimSize();
        return res;
    }

    @Override
    public void writeASCII(OutputStream out) throws Exception {
        this.flush();
        if (this.isEmpty()) {
            return;
        }
        int maxOrder2 = 0;
        int maxOrder1 = 0;
        int nbRanges = this.getNbRanges();
        boolean flagNL = nbRanges > 20;
        boolean first = true;
        StringBuilder res = new StringBuilder(1000);
        int i = 0;
        while (i < nbRanges) {
            Range r1 = new Range();
            r1.push(this.range.r[i * 2]);
            r1.push(this.range.r[i * 2 + 1]);
            while (i < nbRanges - 1 && this.range.rr[i].equals(this.range.rr[i + 1])) {
                r1.push(this.range.r[++i * 2]);
                r1.push(this.range.r[i * 2 + 1]);
            }
            Moc1D mocDim1 = (Moc1D)this.protoDim1.dup();
            mocDim1.setRangeList(r1);
            if (!first) {
                res.append(flagNL ? CR : " ");
            } else {
                first = false;
            }
            res.append(this.cDim1());
            Moc2D.writeASCIIFlush(out, res, false);
            int order = Moc2D.writeASCII(out, mocDim1, flagNL, true);
            if (order > maxOrder1) {
                maxOrder1 = order;
            }
            res.append(flagNL ? CR : " ");
            res.append(this.cDim2());
            Moc2D.writeASCIIFlush(out, res, false);
            Moc1D mocDim2 = (Moc1D)this.protoDim2.dup();
            mocDim2.setRangeList(this.range.rr[i]);
            order = Moc2D.writeASCII(out, mocDim2, flagNL, true);
            if (order > maxOrder2) {
                maxOrder2 = order;
            }
            ++i;
        }
        if (maxOrder1 != this.getMocOrder1() || maxOrder2 != this.getMocOrder2()) {
            res.append(flagNL ? CR : " ");
            res.append(String.valueOf(this.cDim1()) + this.getMocOrder1() + "/ " + this.cDim2() + this.getMocOrder2() + "/");
            if (flagNL) {
                res.append(CR);
            }
        }
        Moc2D.writeASCIIFlush(out, res, false);
    }

    @Override
    public void writeJSON(OutputStream out) throws Exception {
        this.flush();
        if (this.isEmpty()) {
            return;
        }
        int maxOrder2 = 0;
        int maxOrder1 = 0;
        int nbRanges = this.getNbRanges();
        boolean flagNL = this.getNbCells() > 20;
        boolean first = true;
        StringBuilder res = new StringBuilder(1000);
        res.append("[");
        res.append(flagNL ? CR : " ");
        int i = 0;
        while (i < nbRanges) {
            Range r1 = new Range();
            r1.push(this.range.r[i * 2]);
            r1.push(this.range.r[i * 2 + 1]);
            while (i < nbRanges - 1 && this.range.rr[i].equals(this.range.rr[i + 1])) {
                r1.push(this.range.r[++i * 2]);
                r1.push(this.range.r[i * 2 + 1]);
            }
            Moc1D mocDim1 = (Moc1D)this.protoDim1.dup();
            mocDim1.setRangeList(r1);
            if (!first) {
                res.append(",");
                res.append(flagNL ? CR : " ");
            } else {
                first = false;
            }
            res.append(" { \"" + this.cDim1() + "\":");
            Moc2D.writeASCIIFlush(out, res, false);
            boolean flagNL1 = !flagNL ? false : mocDim1.getNbCells() > 20;
            int order = mocDim1.writeJSON(out, flagNL1);
            if (order > maxOrder1) {
                maxOrder1 = order;
            }
            res.append(flagNL1 ? CR : "");
            res.append(flagNL ? " , " : ", ");
            res.append("\"" + this.cDim2() + "\":");
            Moc2D.writeASCIIFlush(out, res, false);
            Moc1D mocDim2 = (Moc1D)this.protoDim2.dup();
            mocDim2.setRangeList(this.range.rr[i]);
            flagNL1 = !flagNL ? false : mocDim2.getNbCells() > 20;
            order = mocDim2.writeJSON(out, flagNL1);
            if (order > maxOrder2) {
                maxOrder2 = order;
            }
            res.append(" }");
            ++i;
        }
        if (maxOrder1 != this.getMocOrder1() || maxOrder2 != this.getMocOrder2()) {
            res.append(", ");
            res.append(flagNL ? CR : " ");
            res.append(" { \"" + this.cDim1() + "\":{ \"" + this.getMocOrder1() + "\":[] },");
            res.append(flagNL ? String.valueOf(CR) + "   " : " ");
            res.append("\"" + this.cDim2() + "\":{ \"" + this.getMocOrder2() + "\":[] }");
            res.append(flagNL ? String.valueOf(CR) + " " : " ");
            res.append("}");
            res.append(flagNL ? CR : " ");
        }
        res.append("]");
        res.append(flagNL ? CR : "");
        Moc2D.writeASCIIFlush(out, res, false);
    }

    @Override
    public int sizeOfCoding() {
        return 8;
    }

    @Override
    public int getNbCoding() {
        int nb = 0;
        int i = 0;
        while (i < this.range.sz) {
            nb += 2;
            if (i <= 0 || !this.range.rr[i / 2].equals(this.range.rr[i / 2 - 1])) {
                nb += this.range.rr[i / 2].sz;
            }
            i += 2;
        }
        return nb;
    }

    @Override
    public Iterator<MocCell> cellIterator(boolean flagRange) {
        this.flush();
        return new Dim2Iterator();
    }

    protected boolean isCodedTime(long a) {
        return (a & MASK_T) != 0L;
    }

    protected long codeTime(long a) {
        return a | MASK_T;
    }

    protected long decodeTime(long a) {
        return a & UNMASK_T;
    }

    protected abstract boolean isCodedDim1(long var1);

    protected abstract long codeDim1(long var1);

    protected abstract long decodeDim1(long var1);

    @Override
    public int writeSpecificDataRange(OutputStream out, int mode) throws Exception {
        int size = 0;
        Moc1D m1 = (Moc1D)this.protoDim1.dup();
        Moc1D m2 = (Moc1D)this.protoDim2.dup();
        Range r1 = new Range(500);
        int i = 0;
        while (i < this.range.sz) {
            r1.push(this.codeDim1(this.range.r[i]));
            r1.push(this.codeDim1(this.range.r[i + 1]));
            if (i >= this.range.sz - 2 || !this.range.rr[i / 2].equals(this.range.rr[i / 2 + 1])) {
                m1.setRangeList(r1);
                size += m1.writeSpecificDataRange(out, mode);
                r1.sz = 0;
                m2.setRangeList(this.range.rr[i / 2]);
                size += m2.writeSpecificDataRange(out, mode);
            }
            i += 2;
        }
        return size;
    }

    @Override
    public void readSpecificDataRange(int nval, byte[] t, int mode) throws Exception {
        Range m1 = new Range(500);
        Range m2 = new Range(500);
        long u1 = 1L << (this.maxOrder1() - this.getMocOrder1()) * this.shiftOrder1();
        long u2 = 1L << (this.maxOrder2() - this.getMocOrder2()) * this.shiftOrder2();
        int k = 0;
        while (k <= nval) {
            long val;
            long l = val = k == nval ? 0L : Moc2D.readLong(t, k * 8);
            if (k == nval || this.isCodedDim1(val)) {
                if (!m2.isEmpty()) {
                    if (mode == 1) {
                        m1 = this.uncompressRange(m1.r, m1.sz, u1);
                        m2 = this.uncompressRange(m2.r, m2.sz, u2);
                    } else {
                        m2.trimSize();
                    }
                    int j = 0;
                    while (j < m1.sz) {
                        this.range.push(m1.r[j], m1.r[j + 1], m2);
                        j += 2;
                    }
                    m1.sz = 0;
                    m2 = new Range(500);
                }
                if (k < nval) {
                    val = this.decodeDim1(val);
                    m1.push(val);
                }
            } else {
                m2.push(val);
            }
            ++k;
        }
    }

    @Override
    public void flush() {
        if (this.buf != null) {
            try {
                this.addToken(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void addToken(String token) throws Exception {
        if (token == null || token.charAt(0) == this.cDim1()) {
            if (token != null) {
                if (this.inDim1) {
                    throw new Exception("Moc syntax error");
                }
                boolean bl = this.inDim1 = !this.inDim1;
            }
            if (this.moc1 != null) {
                Moc1D moc2 = (Moc1D)this.protoDim2.dup();
                moc2.add(this.buf.toString());
                this.protoDim2.biggestOrder = Math.max(this.protoDim2.biggestOrder, moc2.biggestOrder);
                int i = 0;
                while (i < this.moc1.range.sz) {
                    this.range.add(this.moc1.range.r[i], this.moc1.range.r[i + 1], moc2.range);
                    i += 2;
                }
                this.moc1 = null;
                this.buf = null;
            }
            if (token != null) {
                this.buf = new StringBuilder(token.substring(1));
            }
        } else if (token.charAt(0) == this.cDim2()) {
            if (!this.inDim1) {
                throw new Exception("Moc syntax error");
            }
            this.inDim1 = !this.inDim1;
            this.moc1 = (Moc1D)this.protoDim1.dup();
            this.moc1.biggestOrder = this.protoDim1.biggestOrder;
            this.moc1.add(this.buf.toString());
            this.protoDim1.biggestOrder = Math.max(this.protoDim1.biggestOrder, this.moc1.biggestOrder);
            this.buf = new StringBuilder(token.substring(1));
        } else {
            if (this.buf == null) {
                throw new Exception("Moc syntax error => token [" + token + "]");
            }
            this.buf.append(' ');
            this.buf.append(token);
        }
    }

    private class Dim2Iterator
    implements Iterator<MocCell> {
        int i = 0;
        int order;
        long shift;
        char cdim;

        Dim2Iterator() {
            this.order = Moc2D.this.getMocOrder1();
            this.shift = (Moc2D.this.maxOrder1() - this.order) * Moc2D.this.shiftOrder1();
            this.cdim = Moc2D.this.cDim1();
        }

        @Override
        public boolean hasNext() {
            return this.i < Moc2D.this.range.sz / 2;
        }

        @Override
        public MocCell next() {
            if (!this.hasNext()) {
                return null;
            }
            Moc1D moc = (Moc1D)Moc2D.this.protoDim2.dup();
            moc.setRangeList(Moc2D.this.range.rr[this.i]);
            MocCell cell = new MocCell();
            cell.dim = this.cdim;
            cell.order = this.order;
            cell.start = Moc2D.this.range.r[this.i * 2] >>> (int)this.shift;
            cell.end = Moc2D.this.range.r[this.i * 2 + 1] >>> (int)this.shift;
            cell.moc = moc;
            ++this.i;
            return cell;
        }

        @Override
        public void remove() {
        }
    }
}

