/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import uk.ac.starlink.fits.BasicInput;

public abstract class BlockInput
implements BasicInput {
    private final int nblock_;
    private int iblock_;
    private ByteBuffer buffer_;

    protected BlockInput(int nblock) {
        this.nblock_ = nblock;
        this.iblock_ = -1;
        this.buffer_ = ByteBuffer.allocate(0);
    }

    @Override
    public byte readByte() throws IOException {
        try {
            return this.buffer_.get();
        }
        catch (BufferUnderflowException e) {
            return this.getAssuredBuffer(1).get();
        }
    }

    @Override
    public short readShort() throws IOException {
        try {
            return this.buffer_.getShort();
        }
        catch (BufferUnderflowException e) {
            return this.getAssuredBuffer(2).getShort();
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            return this.buffer_.getInt();
        }
        catch (BufferUnderflowException e) {
            return this.getAssuredBuffer(4).getInt();
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            return this.buffer_.getLong();
        }
        catch (BufferUnderflowException e) {
            return this.getAssuredBuffer(8).getLong();
        }
    }

    @Override
    public float readFloat() throws IOException {
        try {
            return this.buffer_.getFloat();
        }
        catch (BufferUnderflowException e) {
            return this.getAssuredBuffer(4).getFloat();
        }
    }

    @Override
    public double readDouble() throws IOException {
        try {
            return this.buffer_.getDouble();
        }
        catch (BufferUnderflowException e) {
            return this.getAssuredBuffer(8).getDouble();
        }
    }

    @Override
    public void readBytes(byte[] bbuf) throws IOException {
        try {
            this.buffer_.get(bbuf);
        }
        catch (BufferUnderflowException e) {
            this.getAssuredBuffer(bbuf.length).get(bbuf);
        }
    }

    @Override
    public void close() {
        this.iblock_ = -1;
        this.buffer_ = null;
    }

    @Override
    public boolean isRandom() {
        return true;
    }

    public abstract int[] getBlockPos(long var1);

    public abstract long getBlockOffset(int var1, int var2);

    protected abstract ByteBuffer acquireBlock(int var1) throws IOException;

    @Override
    public void seek(long offset) throws IOException {
        int[] blockPos = this.getBlockPos(offset);
        int ib = blockPos[0];
        int ioff = blockPos[1];
        if (ib != this.iblock_) {
            if (ioff > 0) {
                this.setCurrentBlock(ib);
            } else if (ioff == 0) {
                if (ib == this.iblock_ + 1) {
                    ib = this.iblock_;
                    ioff = this.buffer_.limit();
                } else if (ib == this.nblock_) {
                    this.setCurrentBlock(this.nblock_ - 1);
                    ib = this.iblock_;
                    ioff = this.buffer_.limit();
                } else {
                    this.setCurrentBlock(ib);
                }
            } else {
                throw new IllegalArgumentException(ioff + " < 0");
            }
        }
        assert (ib == this.iblock_);
        assert (this.getBlockOffset(ib, ioff) == offset || ib == -1 && this.buffer_.limit() == 0 && this.buffer_.position() == 0);
        try {
            this.buffer_.position(ioff);
        }
        catch (IllegalArgumentException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public long getOffset() {
        if (this.iblock_ >= 0) {
            return this.getBlockOffset(this.iblock_, this.buffer_.position());
        }
        assert (this.iblock_ == -1);
        assert (this.buffer_.limit() == 0 && this.buffer_.position() == 0);
        return 0L;
    }

    @Override
    public void skip(long nbyte) throws IOException {
        this.seek(this.getOffset() + nbyte);
    }

    public int getBlockCount() {
        return this.nblock_;
    }

    private ByteBuffer getAssuredBuffer(int count) throws IOException {
        int nr;
        if (!this.buffer_.hasRemaining()) {
            this.setCurrentBlock(this.iblock_ + 1);
            if (this.buffer_.remaining() >= count) {
                return this.buffer_;
            }
        }
        byte[] array = new byte[count];
        for (int i = 0; i < count; i += nr) {
            if (!this.buffer_.hasRemaining()) {
                this.setCurrentBlock(this.iblock_ + 1);
            }
            nr = Math.min(count - i, this.buffer_.remaining());
            this.buffer_.get(array, i, nr);
        }
        return ByteBuffer.wrap(array);
    }

    private void setCurrentBlock(int iblock) throws IOException {
        ByteBuffer buf;
        if (iblock < this.nblock_) {
            buf = this.acquireBlock(iblock);
            assert (buf.position() == 0);
        } else {
            throw new EOFException();
        }
        this.buffer_ = buf;
        this.iblock_ = iblock;
    }
}

