/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.util.logging.Logger;
import uk.ac.starlink.fits.CardImage;
import uk.ac.starlink.fits.FitsUtil;

public class CardFactory {
    private final Config config_;
    public static final CardFactory CLASSIC = new CardFactory(new Config(){

        @Override
        public boolean allowHierarch() {
            return false;
        }

        @Override
        public boolean allowTrim() {
            return true;
        }

        @Override
        public String sanitiseText(String txt) {
            return CardFactory.sanitiseByReplacement(txt, '?');
        }
    });
    public static final CardFactory HIERARCH = new CardFactory(new Config(){

        @Override
        public boolean allowHierarch() {
            return true;
        }

        @Override
        public boolean allowTrim() {
            return true;
        }

        @Override
        public String sanitiseText(String txt) {
            return CardFactory.sanitiseByReplacement(txt, '?');
        }
    });
    public static final CardFactory STRICT = new CardFactory(new Config(){

        @Override
        public boolean allowHierarch() {
            return false;
        }

        @Override
        public boolean allowTrim() {
            return false;
        }

        @Override
        public String sanitiseText(String txt) {
            return CardFactory.sanitiseAsError(txt);
        }
    });
    public static final CardFactory DEFAULT = CLASSIC;
    public static final CardImage END_CARD = CardFactory.createImmutableCard(DEFAULT.createPlainCard("END"));
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    public CardFactory(Config config) {
        this.config_ = config;
    }

    public Config getConfig() {
        return this.config_;
    }

    public CardImage createPlainCard(String txt) {
        StringBuffer sbuf = new StringBuffer(80);
        if (txt.length() <= 80) {
            sbuf.append(txt);
        } else {
            throw new IllegalArgumentException("Text too long");
        }
        while (sbuf.length() < 80) {
            sbuf.append(' ');
        }
        return new CardImage(sbuf);
    }

    public CardImage createCommentCard(String txt) {
        String ctxt = "COMMENT " + this.sanitiseText(txt);
        if (ctxt.length() > 80 && this.config_.allowTrim()) {
            ctxt = ctxt.substring(0, 80);
        }
        return this.createPlainCard(ctxt);
    }

    public CardImage createStringCard(String key, String value, String comment) {
        StringBuffer content = new StringBuffer().append('\'').append(this.sanitiseText(value).replace("'", "''"));
        if (comment == null || comment.length() < 50) {
            while (content.length() < 9) {
                content.append(' ');
            }
        }
        content.append('\'');
        return this.createLiteralCard(key, content.toString(), this.sanitiseText(comment));
    }

    public CardImage createIntegerCard(String key, long value, String comment) {
        return this.createLiteralCard(key, Long.toString(value), this.sanitiseText(comment));
    }

    public CardImage createRealCard(String key, double value, String comment) {
        return this.createLiteralCard(key, Double.toString(value), this.sanitiseText(comment));
    }

    public CardImage createLogicalCard(String key, boolean value, String comment) {
        return this.createLiteralCard(key, value ? "T" : "F", this.sanitiseText(comment));
    }

    public CardImage createLiteralCard(String key, String literal, String comment) {
        if (this.config_.allowHierarch() && key.startsWith("HIERARCH ")) {
            return this.createLiteralHierarchCard(key, literal, comment);
        }
        if (key.length() > 8) {
            throw new IllegalArgumentException("Key too long: " + key);
        }
        if (!key.matches("[A-Z0-9_-]+")) {
            throw new IllegalArgumentException("Bad characters in key: " + key);
        }
        StringBuffer sbuf = new StringBuffer(80);
        sbuf.append(key);
        while (sbuf.length() < 8) {
            sbuf.append(' ');
        }
        sbuf.append("= ");
        if (literal.charAt(0) != '\'' && literal.length() <= 21 && (comment == null || comment.length() <= 46)) {
            while (sbuf.length() + literal.length() < 30) {
                sbuf.append(' ');
            }
        }
        if (sbuf.length() + literal.length() <= 80) {
            sbuf.append(literal);
        } else if (this.config_.allowTrim()) {
            String trimmed = this.trimLiteralString(literal, 80 - sbuf.length());
            logger_.info("Trim overlength value for " + key + " (" + literal + " -> " + trimmed + ")");
            sbuf.append(trimmed);
        } else {
            throw new IllegalArgumentException("Value too long: " + literal);
        }
        if (comment != null && comment.length() > 0) {
            if (comment.length() + 33 < 80) {
                while (sbuf.length() < 30) {
                    sbuf.append(' ');
                }
            }
            if (sbuf.length() + 3 < 80) {
                sbuf.append(" / ");
                for (int i = 0; i < comment.length() && sbuf.length() < 80; ++i) {
                    sbuf.append(comment.charAt(i));
                }
            }
        }
        while (sbuf.length() < 80) {
            sbuf.append(' ');
        }
        assert (sbuf.length() == 80);
        return new CardImage(sbuf);
    }

    private CardImage createLiteralHierarchCard(String key, String literal, String comment) {
        if (!key.matches("[ A-Z0-9_-]+")) {
            throw new IllegalArgumentException("Bad characters in key: " + key);
        }
        StringBuffer sbuf = new StringBuffer(80);
        sbuf.append(key);
        sbuf.append(" = ");
        if (sbuf.length() + literal.length() <= 80) {
            sbuf.append(literal);
        } else if (this.config_.allowTrim() && sbuf.length() < 75) {
            String trimmed = this.trimLiteralString(literal, 80 - sbuf.length());
            logger_.warning("Trim overlength value for key " + key + " (" + literal + " -> " + trimmed + ")");
            sbuf.append(trimmed);
        } else {
            throw new IllegalArgumentException("key + value too long: " + key + " = " + literal);
        }
        assert (sbuf.length() <= 80);
        if (comment != null && comment.trim().length() > 0 && sbuf.length() + comment.length() + 3 < 80) {
            sbuf.append(" / ");
            for (int i = 0; i < comment.length() && sbuf.length() < 80; ++i) {
                sbuf.append(comment.charAt(i));
            }
        }
        while (sbuf.length() < 80) {
            sbuf.append(' ');
        }
        assert (sbuf.length() == 80);
        return new CardImage(sbuf);
    }

    private String trimLiteralString(String literal, int maxleng) {
        String content;
        int leng0 = literal.length();
        if (leng0 <= maxleng) {
            return literal;
        }
        if (leng0 == 0 || literal.charAt(0) != '\'' || literal.charAt(literal.length() - 1) != '\'') {
            throw new IllegalArgumentException("Can't trim non-string literal \"" + literal + "\"");
        }
        if (leng0 < 5) {
            throw new IllegalArgumentException("Too short to trim");
        }
        boolean useEllipsis = false;
        String string = content = useEllipsis ? literal.substring(1, maxleng - 4) : literal.substring(1, maxleng - 1);
        if (content.charAt(content.length() - 1) == '\'' && content.charAt(content.length() - 2) != '\'') {
            content = content.substring(0, content.length() - 1);
        }
        return "'" + content + (useEllipsis ? "..." : "") + "'";
    }

    private String sanitiseText(String txt) {
        return txt == null ? null : this.config_.sanitiseText(txt);
    }

    private static CardImage createImmutableCard(CardImage template) {
        return new CardImage(template.getBytes()){

            @Override
            public byte[] getBytes() {
                return (byte[])super.getBytes().clone();
            }
        };
    }

    public static String sanitiseByReplacement(String txt, char replaceChar) {
        int nc = txt.length();
        int nr = 0;
        StringBuffer sbuf = new StringBuffer(txt);
        for (int i = 0; i < nc; ++i) {
            if (FitsUtil.isFitsCharacter(sbuf.charAt(i))) continue;
            sbuf.setCharAt(i, replaceChar);
            ++nr;
        }
        if (nr > 0) {
            logger_.info("Replace " + nr + " non-FITS " + (nr == 1 ? "char" : "chars") + " with '" + replaceChar + "' in \"" + txt + "\"");
        }
        return nr == 0 ? txt : sbuf.toString();
    }

    public static String sanitiseAsError(String txt) {
        int nc = txt.length();
        for (int ic = 0; ic < nc; ++ic) {
            char ch = txt.charAt(ic);
            if (FitsUtil.isFitsCharacter(ch)) continue;
            throw new IllegalArgumentException("Illegal FITS character 0x" + Integer.toHexString(ch) + " in \"" + txt + "\"");
        }
        return txt;
    }

    public static interface Config {
        public boolean allowHierarch();

        public boolean allowTrim();

        public String sanitiseText(String var1);
    }
}

