/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.IOException;
import java.io.OutputStream;
import uk.ac.starlink.fits.AbstractFitsTableWriter;
import uk.ac.starlink.fits.ColFitsTableSerializer;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.fits.FitsTableSerializerConfig;
import uk.ac.starlink.fits.FitsUtil;
import uk.ac.starlink.fits.StandardFitsTableSerializer;
import uk.ac.starlink.fits.VariableFitsTableSerializer;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.util.IOConsumer;

public class FitsTableWriter
extends AbstractFitsTableWriter {
    private boolean isColfits_ = false;
    private PrimaryType primaryType_ = PrimaryType.BASIC;
    private VarArrayMode varArray_ = VarArrayMode.FALSE;
    private StoragePolicy storage_ = StoragePolicy.getDefaultPolicy();

    public FitsTableWriter() {
        super("fits-basic");
    }

    @Deprecated
    public FitsTableWriter(String name, boolean allowSignedByte, WideFits wide) {
        this();
        this.setFormatName(name);
        this.setAllowSignedByte(allowSignedByte);
        this.setWide(wide);
    }

    @Override
    public boolean looksLikeFile(String location) {
        int dotPos = location.lastIndexOf(46);
        if (dotPos > 0) {
            String ext = location.substring(dotPos + 1).toLowerCase();
            return this.isColfits_ ? "colfits".equalsIgnoreCase(ext) : "fit".equalsIgnoreCase(ext) || "fits".equalsIgnoreCase(ext);
        }
        return false;
    }

    public void setPrimaryType(PrimaryType primaryType) {
        this.primaryType_ = primaryType;
    }

    public PrimaryType getPrimaryType() {
        return this.primaryType_;
    }

    public void setColfits(boolean colfits) {
        this.isColfits_ = colfits;
    }

    public boolean isColfits() {
        return this.isColfits_;
    }

    public void setVarArray(VarArrayMode varArray) {
        this.varArray_ = varArray;
    }

    public VarArrayMode getVarArray() {
        return this.varArray_;
    }

    public void setStoragePolicy(StoragePolicy storage) {
        this.storage_ = storage;
    }

    public StoragePolicy getStoragePolicy() {
        return this.storage_;
    }

    @Override
    public boolean getAllowSignedByte() {
        return super.getAllowSignedByte() && this.primaryType_.allowSignedByte();
    }

    @Override
    public FitsTableSerializer createSerializer(StarTable table) throws IOException {
        FitsTableSerializerConfig config = this.getConfig();
        if (this.isColfits_) {
            return new ColFitsTableSerializer(config, table);
        }
        if (this.varArray_.isVarArray_) {
            Boolean longIndexing = this.varArray_.longIndexing_;
            VariableFitsTableSerializer fitser = new VariableFitsTableSerializer(config, table, this.storage_);
            if (longIndexing != null) {
                fitser.set64BitMode(longIndexing);
            }
            return fitser;
        }
        return new StandardFitsTableSerializer(config, table);
    }

    @Override
    public void writeStarTables(TableSequence tableSeq, OutputStream out) throws IOException {
        this.primaryType_.writeTables(this, tableSeq, out);
    }

    private static PrimaryType createStaticPrimaryType(String name, final IOConsumer<OutputStream> primaryWriter) {
        return new PrimaryType(name){

            @Override
            public boolean allowSignedByte() {
                return true;
            }

            @Override
            public void writeTables(FitsTableWriter fitsWriter, TableSequence tseq, OutputStream out) throws IOException {
                StarTable table;
                primaryWriter.accept((Object)out);
                while ((table = tseq.nextTable()) != null) {
                    fitsWriter.writeTableHDU(table, fitsWriter.createSerializer(table), out);
                }
            }
        };
    }

    static /* synthetic */ PrimaryType access$200(String x0, IOConsumer x1) {
        return FitsTableWriter.createStaticPrimaryType(x0, (IOConsumer<OutputStream>)x1);
    }

    public static abstract class PrimaryType {
        private final String name_;
        public static final PrimaryType BASIC = FitsTableWriter.access$200("basic", out -> FitsUtil.writeEmptyPrimary(out));
        public static final PrimaryType NONE = FitsTableWriter.access$200("none", out -> {});

        protected PrimaryType(String name) {
            this.name_ = name;
        }

        public abstract boolean allowSignedByte();

        public abstract void writeTables(FitsTableWriter var1, TableSequence var2, OutputStream var3) throws IOException;

        public String toString() {
            return this.name_;
        }
    }

    public static enum VarArrayMode {
        FALSE(false, null),
        TRUE(true, null),
        P(true, Boolean.FALSE),
        Q(true, Boolean.TRUE);

        private final boolean isVarArray_;
        private final Boolean longIndexing_;

        private VarArrayMode(boolean isVarArray, Boolean longIndexing) {
            this.isVarArray_ = isVarArray;
            this.longIndexing_ = longIndexing;
        }
    }
}

