/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.nio.ByteBuffer;
import java.util.Arrays;
import uk.ac.starlink.fits.BlockInput;

public class MultiByteBufferInput
extends BlockInput {
    private final ByteBuffer[] bufs_;
    private final long[] istarts_;

    public MultiByteBufferInput(ByteBuffer[] bufs) {
        super(bufs.length);
        this.bufs_ = bufs;
        int nb = bufs.length;
        this.istarts_ = new long[nb + 1];
        for (int ib = 0; ib < nb; ++ib) {
            this.istarts_[ib + 1] = this.istarts_[ib] + (long)bufs[ib].capacity();
        }
    }

    @Override
    public int[] getBlockPos(long offset) {
        int[] nArray;
        int ip = Arrays.binarySearch(this.istarts_, offset);
        if (ip < 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = -2 - ip;
            nArray = nArray2;
            nArray2[1] = (int)(offset - this.istarts_[-2 - ip]);
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = ip;
            nArray = nArray3;
            nArray3[1] = 0;
        }
        return nArray;
    }

    @Override
    public long getBlockOffset(int iblock, int offsetInBlock) {
        return this.istarts_[iblock] + (long)offsetInBlock;
    }

    @Override
    protected ByteBuffer acquireBlock(int iblock) {
        return this.bufs_[iblock];
    }

    @Override
    public void close() {
        super.close();
    }
}

