/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.fits.AbstractWideFits;
import uk.ac.starlink.fits.ArrayWriter;
import uk.ac.starlink.fits.BintableColumnHeader;
import uk.ac.starlink.fits.CardFactory;
import uk.ac.starlink.fits.CardImage;
import uk.ac.starlink.fits.ColumnWriter;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.fits.FitsTableSerializerConfig;
import uk.ac.starlink.fits.FitsUtil;
import uk.ac.starlink.fits.ScalarColumnWriter;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.CountCheckRowSequence;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.HealpixTableInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.Tables;

public class StandardFitsTableSerializer
implements FitsTableSerializer {
    private static Logger logger = Logger.getLogger("uk.ac.starlink.fits");
    private final FitsTableSerializerConfig config_;
    private StarTable table_;
    private ColumnWriter[] colWriters_;
    private ColumnInfo[] colInfos_;
    private long rowCount_;

    StandardFitsTableSerializer(FitsTableSerializerConfig config) {
        this.config_ = config;
    }

    public StandardFitsTableSerializer(FitsTableSerializerConfig config, StarTable table) throws IOException {
        this(config);
        this.init(table);
    }

    public FitsTableSerializerConfig getConfig() {
        return this.config_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void init(StarTable table) throws IOException {
        if (this.table_ != null) {
            throw new IllegalStateException("Table already initialised");
        }
        this.table_ = table;
        int ncol = table.getColumnCount();
        long nrow = table.getRowCount();
        this.colInfos_ = Tables.getColumnInfos(table);
        boolean hasVarShapes = false;
        boolean checkForNullableInts = false;
        int[][] shapes = new int[ncol][];
        int[] maxChars = new int[ncol];
        int[] maxElements = new int[ncol];
        long[] totalElements = new long[ncol];
        boolean[] useCols = new boolean[ncol];
        boolean[] varShapes = new boolean[ncol];
        boolean[] varChars = new boolean[ncol];
        boolean[] varElementChars = new boolean[ncol];
        boolean[] mayHaveNullableInts = new boolean[ncol];
        Arrays.fill(useCols, true);
        boolean[] hasNulls = new boolean[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnInfo colinfo = this.colInfos_[icol];
            Class<?> clazz = colinfo.getContentClass();
            if (clazz.isArray()) {
                shapes[icol] = (int[])colinfo.getShape().clone();
                int[] shape = shapes[icol];
                if (shape[shape.length - 1] < 0) {
                    varShapes[icol] = true;
                    hasVarShapes = true;
                } else {
                    int nel = shape.length > 0 ? 1 : 0;
                    for (int id = 0; id < shape.length; ++id) {
                        nel *= shape[id];
                    }
                    assert (nel >= 0);
                    maxElements[icol] = nel;
                }
                if (!clazz.getComponentType().equals(String.class)) continue;
                maxChars[icol] = colinfo.getElementSize();
                if (maxChars[icol] > 0) continue;
                varElementChars[icol] = true;
                hasVarShapes = true;
                continue;
            }
            if (clazz.equals(String.class)) {
                maxChars[icol] = colinfo.getElementSize();
                if (maxChars[icol] > 0) continue;
                varChars[icol] = true;
                hasVarShapes = true;
                continue;
            }
            if (!colinfo.isNullable() || clazz != Byte.class && clazz != Short.class && clazz != Integer.class && clazz != Long.class) continue;
            mayHaveNullableInts[icol] = true;
            if (colinfo.getAuxDatumValue(Tables.NULL_VALUE_INFO, Number.class) != null) {
                hasNulls[icol] = true;
                continue;
            }
            checkForNullableInts = true;
        }
        if (hasVarShapes || checkForNullableInts || nrow < 0L) {
            int icol;
            StringBuffer sbuf = new StringBuffer("First pass needed: ");
            if (hasVarShapes) {
                sbuf.append("(variable array shapes) ");
            }
            if (checkForNullableInts) {
                sbuf.append("(nullable ints) ");
            }
            if (nrow < 0L) {
                sbuf.append("(unknown row count) ");
            }
            logger.config(sbuf.toString());
            long drow = nrow;
            nrow = 0L;
            try (RowSequence rseq = table.getRowSequence();){
                while (rseq.next()) {
                    ++nrow;
                    for (icol = 0; icol < ncol; ++icol) {
                        if (!useCols[icol] || !varShapes[icol] && !varChars[icol] && !varElementChars[icol] && (!mayHaveNullableInts[icol] || hasNulls[icol])) continue;
                        Object cell = rseq.getCell(icol);
                        if (cell == null) {
                            if (!mayHaveNullableInts[icol]) continue;
                            hasNulls[icol] = true;
                            continue;
                        }
                        if (varChars[icol]) {
                            int leng = ((String)cell).length();
                            maxChars[icol] = Math.max(maxChars[icol], leng);
                        } else if (varElementChars[icol]) {
                            String[] svals = (String[])cell;
                            for (int i = 0; i < svals.length; ++i) {
                                String sv = svals[i];
                                if (sv == null) continue;
                                maxChars[icol] = Math.max(maxChars[icol], sv.length());
                            }
                        }
                        if (!varShapes[icol]) continue;
                        int nel = Array.getLength(cell);
                        maxElements[icol] = Math.max(maxElements[icol], nel);
                        int n = icol;
                        totalElements[n] = totalElements[n] + (long)nel;
                    }
                }
            }
            if (drow >= 0L && drow != nrow) {
                logger.warning("Row count discrepancy in FITS output: " + drow + " rows declared, " + nrow + " rows found/written.");
            }
            for (icol = 0; icol < ncol; ++icol) {
                if (maxChars[icol] >= 0) continue;
                maxChars[icol] = 0;
            }
            if (!this.config_.allowZeroLengthString()) {
                for (icol = 0; icol < ncol; ++icol) {
                    if (maxChars[icol] != 0) continue;
                    maxChars[icol] = 1;
                }
            }
            if (hasVarShapes) {
                for (icol = 0; icol < ncol; ++icol) {
                    if (!useCols[icol] || !varShapes[icol]) continue;
                    int[] shape = shapes[icol];
                    int ndim = shape.length;
                    assert (shape[ndim - 1] <= 0);
                    int nel = 1;
                    for (int i = 0; i < ndim - 1; ++i) {
                        nel *= shape[i];
                    }
                    shape[ndim - 1] = Math.max(1, (maxElements[icol] + nel - 1) / nel);
                }
            }
        }
        assert (nrow >= 0L);
        this.rowCount_ = nrow;
        this.colWriters_ = new ColumnWriter[ncol];
        boolean rbytes = false;
        int nUseCol = 0;
        for (int icol = 0; icol < ncol; ++icol) {
            if (!useCols[icol]) continue;
            ColumnInfo cinfo = this.colInfos_[icol];
            ColumnWriter writer = this.createColumnWriter(cinfo, shapes[icol], varShapes[icol], maxChars[icol], maxElements[icol], totalElements[icol], mayHaveNullableInts[icol] && hasNulls[icol]);
            if (writer == null) {
                logger.warning("Ignoring column " + cinfo.getName() + " - don't know how to write to FITS");
            } else {
                ++nUseCol;
            }
            this.colWriters_[icol] = writer;
        }
        FitsUtil.checkColumnCount(this.config_.getWide(), nUseCol);
    }

    ColumnWriter[] getColumnWriters() {
        return this.colWriters_;
    }

    @Override
    public CardImage[] getHeader() {
        List<DescribedValue> tparams;
        int rowLength = 0;
        int extLength = 0;
        int nUseCol = 0;
        int ncol = this.table_.getColumnCount();
        WideFits wide = this.config_.getWide();
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnWriter writer = this.colWriters_[icol];
            if (writer == null) continue;
            int leng = writer.getLength();
            rowLength += leng;
            if (wide == null || ++nUseCol < wide.getContainerColumnIndex()) continue;
            extLength += leng;
        }
        int nStdCol = wide != null && nUseCol > wide.getContainerColumnIndex() ? wide.getContainerColumnIndex() : nUseCol;
        boolean hasExtCol = nUseCol > nStdCol;
        CardFactory cfact = CardFactory.DEFAULT;
        ArrayList<CardImage> cards = new ArrayList<CardImage>();
        cards.addAll(Arrays.asList(cfact.createStringCard("XTENSION", "BINTABLE", "binary table extension"), cfact.createIntegerCard("BITPIX", 8L, "8-bit bytes"), cfact.createIntegerCard("NAXIS", 2L, "2-dimensional table"), cfact.createIntegerCard("NAXIS1", rowLength, "width of table in bytes"), cfact.createIntegerCard("NAXIS2", this.rowCount_, "number of rows in table"), cfact.createIntegerCard("PCOUNT", 0L, "size of special data area"), cfact.createIntegerCard("GCOUNT", 1L, "one data group"), cfact.createIntegerCard("TFIELDS", nStdCol, "number of columns")));
        String tname = this.table_.getName();
        if (tname != null && tname.trim().length() > 0) {
            cards.add(cfact.createStringCard("EXTNAME", tname, "table name"));
        }
        if (hasExtCol) {
            cards.addAll(Arrays.asList(wide.getExtensionCards(nUseCol)));
            AbstractWideFits.logWideWrite(logger, nStdCol, nUseCol);
        }
        if (HealpixTableInfo.isHealpix(tparams = this.table_.getParameters())) {
            HealpixTableInfo hpxInfo = HealpixTableInfo.fromParams(tparams);
            CardImage[] hpxCards = null;
            try {
                hpxCards = this.getHealpixHeaders(hpxInfo);
            }
            catch (TableFormatException e) {
                logger.log(Level.WARNING, "Failed to write HEALPix-specific FITS headers: " + e.getMessage(), e);
            }
            if (hpxCards != null && hpxCards.length > 0) {
                logger.info("Adding HEALPix-specific FITS headers");
                cards.addAll(Arrays.asList(hpxCards));
            }
        }
        int jcol = 0;
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnWriter colwriter = this.colWriters_[icol];
            if (colwriter == null) continue;
            if (hasExtCol && ++jcol == nStdCol) {
                cards.addAll(Arrays.asList(wide.getContainerColumnCards(extLength, 0L)));
            }
            BintableColumnHeader colhead = hasExtCol && jcol >= nStdCol ? wide.createExtendedHeader(nStdCol, jcol) : BintableColumnHeader.createStandardHeader(jcol);
            cards.addAll(Arrays.asList(this.getHeaders(colhead, this.colInfos_[icol], colwriter, jcol)));
        }
        return cards.toArray(new CardImage[0]);
    }

    private CardImage[] getHeaders(BintableColumnHeader colhead, ColumnInfo colinfo, ColumnWriter colwriter, int jcol) {
        String xtype;
        String utype;
        String ucd;
        String comm;
        int[] dims;
        Number bad;
        CardFactory cfact = colhead.getCardFactory();
        String forcol = " for column " + jcol;
        ArrayList<CardImage> cards = new ArrayList<CardImage>();
        String name = colinfo.getName();
        if (name != null && name.trim().length() > 0) {
            cards.add(cfact.createStringCard(colhead.getKeyName("TTYPE"), name, "label" + forcol));
        }
        String form = colwriter.getFormat();
        cards.add(cfact.createStringCard(colhead.getKeyName("TFORM"), form, "format" + forcol));
        String unit = colinfo.getUnitString();
        if (unit != null && unit.trim().length() > 0) {
            cards.add(cfact.createStringCard(colhead.getKeyName("TUNIT"), unit, "units" + forcol));
        }
        if ((bad = colwriter.getBadNumber()) != null) {
            cards.add(cfact.createIntegerCard(colhead.getKeyName("TNULL"), bad.longValue(), "blank value" + forcol));
        }
        if ((dims = colwriter.getDims()) != null && dims.length > 1) {
            StringBuffer sbuf = new StringBuffer();
            for (int i = 0; i < dims.length; ++i) {
                sbuf.append(i == 0 ? (char)'(' : ',');
                sbuf.append(dims[i]);
            }
            sbuf.append(')');
            cards.add(cfact.createStringCard(colhead.getKeyName("TDIM"), sbuf.toString(), "dimensions" + forcol));
        }
        BigDecimal zero = colwriter.getZero();
        double scale = colwriter.getScale();
        if (zero != null && !BigDecimal.ZERO.equals(zero)) {
            cards.add(cfact.createLiteralCard(colhead.getKeyName("TZERO"), zero.toString(), "base" + forcol));
        }
        if (scale != 1.0) {
            cards.add(cfact.createRealCard(colhead.getKeyName("TSCALE"), scale, "factor" + forcol));
        }
        if ((comm = colinfo.getDescription()) != null && comm.trim().length() > 0) {
            cards.add(cfact.createStringCard(colhead.getKeyName("TCOMM"), comm, null));
        }
        if ((ucd = colinfo.getUCD()) != null && ucd.trim().length() > 0) {
            cards.add(cfact.createStringCard(colhead.getKeyName("TUCD"), ucd, "VO Unified Content Descriptor" + forcol));
        }
        if ((utype = colinfo.getUtype()) != null && utype.trim().length() > 0) {
            cards.add(cfact.createStringCard(colhead.getKeyName("TUTYP"), utype, "VO Utype" + forcol));
        }
        if ((xtype = colinfo.getXtype()) != null && xtype.trim().length() > 0) {
            cards.add(cfact.createStringCard(colhead.getKeyName("TXTYP"), xtype, "VO/DALI extended type" + forcol));
        }
        return cards.toArray(new CardImage[0]);
    }

    @Override
    public void writeData(DataOutput strm) throws IOException {
        long nWritten = this.writeDataOnly(strm);
        int extra = (int)(nWritten % 2880L);
        if (extra > 0) {
            strm.write(new byte[2880 - extra]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeDataOnly(DataOutput strm) throws IOException {
        int rowBytes = 0;
        int ncol = this.table_.getColumnCount();
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnWriter writer = this.colWriters_[icol];
            if (writer == null) continue;
            rowBytes += writer.getLength();
        }
        long nWritten = 0L;
        try (RowSequence rseq = CountCheckRowSequence.getSafeRowSequence(this.table_.getRowSequence(), this.table_.getColumnCount(), this.rowCount_);){
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                for (int icol = 0; icol < ncol; ++icol) {
                    ColumnWriter writer = this.colWriters_[icol];
                    if (writer == null) continue;
                    writer.writeValue(strm, row[icol]);
                }
                nWritten += (long)rowBytes;
            }
        }
        return nWritten;
    }

    @Override
    public char getFormatChar(int icol) {
        if (this.colWriters_[icol] == null) {
            return '\u0000';
        }
        return this.colWriters_[icol].getFormatChar();
    }

    @Override
    public int[] getDimensions(int icol) {
        if (this.colWriters_[icol] == null) {
            return null;
        }
        int[] dims = this.colWriters_[icol].getDims();
        return dims == null ? new int[]{} : dims;
    }

    @Override
    public String getBadValue(int icol) {
        if (this.colWriters_[icol] == null) {
            return null;
        }
        Number badnum = this.colWriters_[icol].getBadNumber();
        return badnum == null ? null : badnum.toString();
    }

    @Override
    public long getRowCount() {
        return this.rowCount_;
    }

    ColumnWriter createColumnWriter(ColumnInfo cinfo, int[] shape, boolean varShape, int eSize, final int maxEls, long totalEls, boolean nullableInt) {
        byte padChar;
        Class<?> clazz = cinfo.getContentClass();
        BigInteger longOffset = ScalarColumnWriter.getLongOffset(cinfo);
        if (clazz == String.class && longOffset == null) {
            final int maxChars = eSize;
            final int[] dims = new int[]{maxChars};
            final byte[] buf = new byte[maxChars];
            final byte[] blankBuf = new byte[maxChars];
            final byte padByte = this.config_.getPadCharacter();
            Arrays.fill(blankBuf, padByte);
            return new ColumnWriter(){

                @Override
                public void writeValue(DataOutput out, Object value) throws IOException {
                    byte[] bytes;
                    if (value == null) {
                        bytes = blankBuf;
                    } else {
                        int i;
                        bytes = buf;
                        String sval = (String)value;
                        int leng = Math.min(sval.length(), maxChars);
                        for (i = 0; i < leng; ++i) {
                            bytes[i] = (byte)sval.charAt(i);
                        }
                        for (i = leng; i < maxChars; ++i) {
                            bytes[i] = padByte;
                        }
                    }
                    out.write(bytes);
                }

                @Override
                public String getFormat() {
                    return Integer.toString(maxChars) + 'A';
                }

                @Override
                public char getFormatChar() {
                    return 'A';
                }

                @Override
                public int getLength() {
                    return maxChars;
                }

                @Override
                public int[] getDims() {
                    return dims;
                }

                @Override
                public BigDecimal getZero() {
                    return BigDecimal.ZERO;
                }

                @Override
                public double getScale() {
                    return 1.0;
                }

                @Override
                public Number getBadNumber() {
                    return null;
                }
            };
        }
        if (clazz == String[].class && longOffset == null) {
            final int maxChars = eSize;
            final int[] charDims = new int[shape.length + 1];
            charDims[0] = maxChars;
            System.arraycopy(shape, 0, charDims, 1, shape.length);
            final byte[] buf = new byte[maxChars];
            final byte padByte = this.config_.getPadCharacter();
            return new ColumnWriter(){

                @Override
                public void writeValue(DataOutput out, Object value) throws IOException {
                    int is;
                    if (value != null) {
                        String[] svals = (String[])value;
                        int leng = Math.min(svals.length, maxEls);
                        for (is = 0; is < leng; ++is) {
                            int ic;
                            String str = svals[is];
                            if (str != null) {
                                int sleng = Math.min(str.length(), maxChars);
                                for (ic = 0; ic < sleng; ++ic) {
                                    buf[ic] = (byte)str.charAt(ic);
                                }
                            }
                            Arrays.fill(buf, ic, maxChars, padByte);
                            out.write(buf);
                        }
                    }
                    if (is < maxEls) {
                        Arrays.fill(buf, padByte);
                        while (is < maxEls) {
                            out.write(buf);
                            ++is;
                        }
                    }
                }

                @Override
                public String getFormat() {
                    return Integer.toString(maxChars * maxEls) + 'A';
                }

                @Override
                public char getFormatChar() {
                    return 'A';
                }

                @Override
                public int getLength() {
                    return maxChars * maxEls;
                }

                @Override
                public int[] getDims() {
                    return charDims;
                }

                @Override
                public BigDecimal getZero() {
                    return BigDecimal.ZERO;
                }

                @Override
                public double getScale() {
                    return 1.0;
                }

                @Override
                public Number getBadNumber() {
                    return null;
                }
            };
        }
        boolean allowSignedByte = this.config_.allowSignedByte();
        ScalarColumnWriter cw = ScalarColumnWriter.createColumnWriter(cinfo, nullableInt, allowSignedByte, padChar = this.config_.getPadCharacter());
        if (cw != null) {
            return cw;
        }
        ArrayWriter aw = ArrayWriter.createArrayWriter(cinfo, allowSignedByte);
        if (aw != null) {
            return new FixedArrayColumnWriter(aw, shape);
        }
        return null;
    }

    protected CardImage[] getHealpixHeaders(HealpixTableInfo hpxInfo) throws TableFormatException {
        long npix;
        int clevel;
        boolean isExplicit;
        String ipixColName = hpxInfo.getPixelColumnName();
        int level = hpxInfo.getLevel();
        String ordering = hpxInfo.isNest() ? "NESTED" : "RING";
        HealpixTableInfo.HpxCoordSys csys = hpxInfo.getCoordSys();
        if (ipixColName == null) {
            isExplicit = false;
        } else if (ipixColName.equals(this.table_.getColumnInfo(0).getName())) {
            isExplicit = true;
        } else {
            throw new TableFormatException("HEALPix pixel index column \"" + ipixColName + "\" is not first column");
        }
        long nrow = this.rowCount_;
        assert (nrow >= 0L);
        if (level < 0 && !isExplicit && 12L * (1L << 2 * (clevel = Long.numberOfTrailingZeros(nrow / 12L) / 2)) == nrow) {
            level = clevel;
            logger.warning("Inferred HEALPix level " + clevel);
        }
        if (level < 0) {
            throw new TableFormatException("No HEALPix level specified");
        }
        if (!isExplicit && (npix = 12L * (1L << 2 * level)) != nrow) {
            throw new TableFormatException("Row count does not match level for implicitly indexed HEALPix table (" + nrow + " != " + npix + ")");
        }
        npix = 12L * (1L << 2 * level);
        long nside = 1L << level;
        ArrayList<CardImage> cards = new ArrayList<CardImage>();
        CardFactory cfact = CardFactory.DEFAULT;
        cards.addAll(Arrays.asList(cfact.createStringCard("PIXTYPE", "HEALPIX", "HEALPix map"), cfact.createIntegerCard("NSIDE", nside, "HEALPix level parameter"), cfact.createStringCard("ORDERING", ordering, "HEALPix index ordering scheme")));
        if (csys != null) {
            cards.add(cfact.createStringCard("COORDSYS", csys.getCharString(), "HEALPix coordinate system " + csys.getWord()));
        }
        if (isExplicit) {
            cards.add(cfact.createStringCard("INDXSCHM", "EXPLICIT", "HEALPix indices given explicitly"));
            cards.add(cfact.createIntegerCard("OBS_NPIX", nrow, "HEALPix pixel count"));
            if (nrow < npix) {
                cards.add(cfact.createStringCard("OBJECT", "PARTIAL", "HEALPix sky coverage is partial"));
            }
        } else {
            cards.addAll(Arrays.asList(cfact.createStringCard("INDXSCHM", "IMPLICIT", "HEALPix indices given implicitly"), cfact.createIntegerCard("FIRSTPIX", 0L, "First HEALPix index"), cfact.createIntegerCard("LASTPIX", npix - 1L, "Last HEALPix index"), cfact.createStringCard("OBJECT", "FULLSKY", "HEALPix sky coverage is full")));
        }
        return cards.toArray(new CardImage[0]);
    }

    static class FixedArrayColumnWriter
    implements ColumnWriter {
        private final ArrayWriter arrayWriter_;
        private final int[] shape_;
        private final int nel_;

        FixedArrayColumnWriter(ArrayWriter arrayWriter, int[] shape) {
            this.arrayWriter_ = arrayWriter;
            this.shape_ = shape;
            int nel = 1;
            if (shape != null) {
                for (int i = 0; i < shape.length; ++i) {
                    nel *= shape[i];
                }
            }
            this.nel_ = nel;
        }

        @Override
        public void writeValue(DataOutput out, Object value) throws IOException {
            int i;
            int leng = Math.min(value == null ? 0 : Array.getLength(value), this.nel_);
            for (i = 0; i < leng; ++i) {
                this.arrayWriter_.writeElement(out, value, i);
            }
            for (i = leng; i < this.nel_; ++i) {
                this.arrayWriter_.writePad(out);
            }
        }

        @Override
        public char getFormatChar() {
            return this.arrayWriter_.getFormatChar();
        }

        @Override
        public String getFormat() {
            String fc = new String(new char[]{this.getFormatChar()});
            return this.nel_ == 1 ? fc : Integer.toString(this.nel_) + fc;
        }

        @Override
        public int getLength() {
            return this.nel_ * this.arrayWriter_.getByteCount();
        }

        @Override
        public int[] getDims() {
            return this.shape_;
        }

        @Override
        public BigDecimal getZero() {
            return this.arrayWriter_.getZero();
        }

        @Override
        public double getScale() {
            return 1.0;
        }

        @Override
        public Number getBadNumber() {
            return null;
        }
    }
}

