/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import uk.ac.starlink.fits.ArrayWriter;
import uk.ac.starlink.fits.CardFactory;
import uk.ac.starlink.fits.CardImage;
import uk.ac.starlink.fits.ColumnWriter;
import uk.ac.starlink.fits.FitsTableSerializerConfig;
import uk.ac.starlink.fits.FitsUtil;
import uk.ac.starlink.fits.ParsedCard;
import uk.ac.starlink.fits.StandardFitsTableSerializer;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.DataBufferedOutputStream;

public class VariableFitsTableSerializer
extends StandardFitsTableSerializer {
    private final StoragePolicy storagePolicy_;

    public VariableFitsTableSerializer(FitsTableSerializerConfig config, StarTable table, StoragePolicy storagePolicy) throws IOException {
        super(config);
        this.storagePolicy_ = storagePolicy;
        this.init(table);
        this.set64BitMode(this.getHeapSize() > Integer.MAX_VALUE);
    }

    public void set64BitMode(boolean useQ) {
        PQMode pqMode = useQ ? PQMode.Q : PQMode.P;
        VariableArrayColumnWriter[] vcws = this.getVariableArrayColumnWriters();
        for (int iv = 0; iv < vcws.length; ++iv) {
            vcws[iv].setPQMode(pqMode);
        }
    }

    @Override
    public CardImage[] getHeader() {
        CardImage[] cards = super.getHeader();
        long heapSize = this.getHeapSize();
        for (int ic = 0; ic < cards.length; ++ic) {
            ParsedCard<?> card = FitsUtil.parseCard(cards[ic].getBytes());
            if (card == null || !"PCOUNT".equals(card.getKey())) continue;
            cards[ic] = CardFactory.DEFAULT.createIntegerCard("PCOUNT", heapSize, "heap size (no gap)");
        }
        return cards;
    }

    private VariableArrayColumnWriter[] getVariableArrayColumnWriters() {
        ColumnWriter[] colWriters = this.getColumnWriters();
        ArrayList<VariableArrayColumnWriter> vcwList = new ArrayList<VariableArrayColumnWriter>();
        for (int icol = 0; icol < colWriters.length; ++icol) {
            if (!(colWriters[icol] instanceof VariableArrayColumnWriter)) continue;
            vcwList.add((VariableArrayColumnWriter)colWriters[icol]);
        }
        return vcwList.toArray(new VariableArrayColumnWriter[0]);
    }

    private final long getHeapSize() {
        long count = 0L;
        VariableArrayColumnWriter[] vcws = this.getVariableArrayColumnWriters();
        for (int iv = 0; iv < vcws.length; ++iv) {
            VariableArrayColumnWriter vcw = vcws[iv];
            count += vcw.totalElements_ * (long)vcw.arrayWriter_.getByteCount();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeData(DataOutput out) throws IOException {
        VariableArrayColumnWriter[] vcws = this.getVariableArrayColumnWriters();
        ByteStore byteStore = this.storagePolicy_.makeByteStore();
        long[] counter = new long[1];
        DataBufferedOutputStream dataOut = new DataBufferedOutputStream(byteStore.getOutputStream());
        for (int iv = 0; iv < vcws.length; ++iv) {
            vcws[iv].setDataOutput((DataOutput)dataOut, counter);
        }
        long nWritten = 0L;
        try {
            nWritten += super.writeDataOnly(out);
            dataOut.flush();
            byteStore.copy(VariableFitsTableSerializer.toStream(out));
            nWritten += byteStore.getLength();
            assert (byteStore.getLength() == this.getHeapSize());
        }
        finally {
            byteStore.close();
        }
        int over = (int)(nWritten % 2880L);
        if (over > 0) {
            out.write(new byte[2880 - over]);
        }
        for (int iv = 0; iv < vcws.length; ++iv) {
            vcws[iv].setDataOutput(null, null);
        }
    }

    @Override
    ColumnWriter createColumnWriter(ColumnInfo cinfo, int[] shape, boolean varShape, int eSize, int maxEls, long totalEls, boolean nullableInt) {
        Class<?> clazz = cinfo.getContentClass();
        if (!varShape || clazz == String.class || clazz == String[].class) {
            return super.createColumnWriter(cinfo, shape, varShape, eSize, maxEls, totalEls, nullableInt);
        }
        assert (clazz.isArray());
        boolean allowSignedByte = this.getConfig().allowSignedByte();
        ArrayWriter aw = ArrayWriter.createArrayWriter(cinfo, allowSignedByte);
        return new VariableArrayColumnWriter(aw, maxEls, totalEls);
    }

    private static OutputStream toStream(final DataOutput dataOut) {
        if (dataOut instanceof OutputStream) {
            return (OutputStream)((Object)dataOut);
        }
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                dataOut.write(b);
            }

            @Override
            public void write(byte[] buf) throws IOException {
                dataOut.write(buf);
            }

            @Override
            public void write(byte[] buf, int off, int leng) throws IOException {
                dataOut.write(buf, off, leng);
            }
        };
    }

    private static abstract class PQMode {
        private final char formatChar_;
        private final int intLength_;
        public static final PQMode P = new PQMode('P', 4){

            @Override
            public void writeInteger(DataOutput out, long value) throws IOException {
                out.writeInt(Tables.checkedLongToInt(value));
            }
        };
        public static final PQMode Q = new PQMode('Q', 8){

            @Override
            public void writeInteger(DataOutput out, long value) throws IOException {
                out.writeLong(value);
            }
        };

        private PQMode(char formatChar, int intLength) {
            this.formatChar_ = formatChar;
            this.intLength_ = intLength;
        }

        public abstract void writeInteger(DataOutput var1, long var2) throws IOException;

        public char getFormatChar() {
            return this.formatChar_;
        }

        public int getIntegerLength() {
            return this.intLength_;
        }
    }

    private static class VariableArrayColumnWriter
    implements ColumnWriter {
        private final ArrayWriter arrayWriter_;
        private final int maxElements_;
        private final long totalElements_;
        private final int elSize_;
        private PQMode pqMode_;
        private DataOutput dataOut_;
        private long[] counter_;

        VariableArrayColumnWriter(ArrayWriter arrayWriter, int maxElements, long totalElements) {
            this.arrayWriter_ = arrayWriter;
            this.maxElements_ = maxElements;
            this.totalElements_ = totalElements;
            this.elSize_ = arrayWriter.getByteCount();
        }

        public void setPQMode(PQMode pqMode) {
            this.pqMode_ = pqMode;
        }

        public void setDataOutput(DataOutput dataOut, long[] counter) {
            this.dataOut_ = dataOut;
            this.counter_ = counter;
        }

        @Override
        public void writeValue(DataOutput out, Object value) throws IOException {
            int leng = value == null ? 0 : Array.getLength(value);
            this.pqMode_.writeInteger(out, leng);
            this.pqMode_.writeInteger(out, leng == 0 ? 0L : this.counter_[0]);
            for (int i = 0; i < leng; ++i) {
                this.arrayWriter_.writeElement(this.dataOut_, value, i);
            }
            this.counter_[0] = this.counter_[0] + (long)(leng * this.elSize_);
        }

        @Override
        public char getFormatChar() {
            return this.arrayWriter_.getFormatChar();
        }

        @Override
        public String getFormat() {
            return new StringBuffer().append(this.pqMode_.getFormatChar()).append(this.arrayWriter_.getFormatChar()).append('(').append(this.maxElements_).append(')').toString();
        }

        @Override
        public int getLength() {
            return 2 * this.pqMode_.getIntegerLength();
        }

        @Override
        public int[] getDims() {
            return new int[]{-1};
        }

        @Override
        public BigDecimal getZero() {
            return this.arrayWriter_.getZero();
        }

        @Override
        public double getScale() {
            return 1.0;
        }

        @Override
        public Number getBadNumber() {
            return null;
        }
    }
}

