/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.Domain;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.tfcat.Geometry;
import uk.ac.starlink.tfcat.LinearRing;
import uk.ac.starlink.tfcat.Position;
import uk.ac.starlink.tfcat.TfcatObject;
import uk.ac.starlink.tfcat.TfcatUtil;
import uk.ac.starlink.ttools.Area;
import uk.ac.starlink.ttools.AreaMapper;
import uk.ac.starlink.util.DoubleList;
import uk.ac.starlink.util.LongList;

public class AreaDomain
implements Domain<AreaMapper> {
    public static final AreaDomain INSTANCE = new AreaDomain();
    public static final AreaMapper STCS_MAPPER = AreaDomain.createStcsMapper();
    public static final AreaMapper CIRCLE_MAPPER = AreaDomain.createSimpleNumericDaliMapper(Area.Type.CIRCLE, "3-element array (<code>x</code>, <code>y</code>, <code>r</code>)", "3-element array (<code>ra</code>, <code>dec</code>, <code>r</code>)");
    public static final AreaMapper POLYGON_MAPPER = AreaDomain.createPolygonMapper();
    public static final AreaMapper POINT_MAPPER = AreaDomain.createSimpleNumericDaliMapper(Area.Type.POINT, "2-element array (<code>x</code>,<code>y</code>)", "2-element array (<code>ra</code>,<code>dec</code>)");
    public static final AreaMapper ASCIIMOC_MAPPER = AreaDomain.createAsciiMocMapper();
    public static final AreaMapper UNIQ_MAPPER = AreaDomain.createUniqMapper();
    public static final AreaMapper TFCAT_MAPPER = AreaDomain.createTfcatMapper();
    private static final String WORDS_REGEX = "\\s*([A-Za-z]+)\\s+([A-Za-z][A-Za-z0-9]*\\s+)*";
    private static final String NUMBER_REGEX = "\\s*([-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?)";
    private static final Pattern WORDS_PATTERN = Pattern.compile("\\s*([A-Za-z]+)\\s+([A-Za-z][A-Za-z0-9]*\\s+)*");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\s*([-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?)");
    private static final Pattern PARENTHESIS_PATTERN = Pattern.compile("\\s*\\((.*)\\)\\s*");
    private static final Pattern SMOC_TOKENS_PATTERN = Pattern.compile("(?:\\s*s)?\\s*([^\\s]+)");
    private static final Pattern MOC_PATTERN = Pattern.compile("(?:([0-9]+)/)?(?:([0-9]+)(?:-([0-9]+))?)?");
    private static final Pattern TERM_PATTERN = Pattern.compile("(\\s*([A-Za-z]+)\\s+([A-Za-z][A-Za-z0-9]*\\s+)*)+(\\s*([-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?))++");

    private AreaDomain() {
    }

    public String getDomainName() {
        return "Area";
    }

    public AreaMapper[] getMappers() {
        return new AreaMapper[]{POINT_MAPPER, CIRCLE_MAPPER, POLYGON_MAPPER, ASCIIMOC_MAPPER, UNIQ_MAPPER, STCS_MAPPER, TFCAT_MAPPER};
    }

    public AreaMapper getProbableMapper(ValueInfo info) {
        if (info == null) {
            return null;
        }
        for (DomainMapper mapper : info.getDomainMappers()) {
            if (!(mapper instanceof AreaMapper)) continue;
            return (AreaMapper)mapper;
        }
        Class clazz = info.getContentClass();
        String name = info.getName();
        String xtype = info.getXtype();
        String ucd = info.getUCD();
        if (clazz.equals(String.class)) {
            if ("moc".equalsIgnoreCase(xtype) || "smoc".equalsIgnoreCase(xtype)) {
                return ASCIIMOC_MAPPER;
            }
            if ("stc-s".equalsIgnoreCase(xtype) || "stc".equalsIgnoreCase(xtype)) {
                return STCS_MAPPER;
            }
            if ("s_region".equals(name) || "pos.outline;obs.field".equals(ucd) || ucd != null && ucd.startsWith("pos.outline")) {
                return STCS_MAPPER;
            }
            if ("tfcat".equals(name) || "tfcat".equalsIgnoreCase(xtype)) {
                return TFCAT_MAPPER;
            }
            return null;
        }
        if (AreaDomain.isNumArray(clazz)) {
            if ("circle".equalsIgnoreCase(xtype)) {
                return CIRCLE_MAPPER;
            }
            if ("polygon".equalsIgnoreCase(xtype)) {
                return POLYGON_MAPPER;
            }
            if ("point".equalsIgnoreCase(xtype)) {
                return POINT_MAPPER;
            }
            return null;
        }
        if (Integer.class.equals((Object)clazz) || Long.class.equals((Object)clazz)) {
            if ("UNIQ".equalsIgnoreCase(name)) {
                return UNIQ_MAPPER;
            }
            return null;
        }
        return null;
    }

    public AreaMapper getPossibleMapper(ValueInfo info) {
        if (info == null) {
            return null;
        }
        for (DomainMapper mapper : info.getDomainMappers()) {
            if (!(mapper instanceof AreaMapper)) continue;
            return (AreaMapper)mapper;
        }
        Class clazz = info.getContentClass();
        if (String.class.equals((Object)clazz)) {
            return STCS_MAPPER;
        }
        if (AreaDomain.isNumArray(clazz)) {
            int[] shape = info.getShape();
            if (shape != null && shape.length == 1) {
                int nel = shape[0];
                if (nel == 3) {
                    return CIRCLE_MAPPER;
                }
                if (nel == 2) {
                    return POINT_MAPPER;
                }
                if (nel % 2 == 0 && nel >= 6 || nel < 0) {
                    return POLYGON_MAPPER;
                }
                return null;
            }
            if (shape == null) {
                return POLYGON_MAPPER;
            }
            return null;
        }
        if (Integer.class.equals((Object)clazz) || Long.class.equals((Object)clazz)) {
            return UNIQ_MAPPER;
        }
        return null;
    }

    private static boolean isNumArray(Class<?> clazz) {
        return double[].class.equals(clazz) || float[].class.equals(clazz);
    }

    private static AreaMapper createStcsMapper() {
        String descrip = new StringBuffer().append("Region description using STC-S syntax;\n").append("see <webref ").append("url='http://www.ivoa.net/documents/TAP/20100327/'>").append("TAP 1.0</webref>, section 6.\n").append("Note there are some restrictions:\n").append("<code>&lt;frame&gt;</code>, ").append("<code>&lt;refpos&gt;</code> and ").append("<code>&lt;flavor&gt;</code> metadata are ignored,\n").append("polygon winding direction is ignored ").append("(small polygons are assumed)\n").append("and the <code>INTERSECTION</code> and <code>NOT</code> ").append("constructions are not supported.\n").append("The non-standard <code>MOC</code> construction ").append("is supported.").toString();
        return new AreaMapper("STC-S", descrip, (Class)String.class){

            @Override
            public Function<Object, Area> areaFunction(Class<?> clazz) {
                if (String.class.equals(clazz)) {
                    return obj -> obj instanceof String ? AreaDomain.stcsArea((String)obj, true) : null;
                }
                return null;
            }
        };
    }

    private static AreaMapper createAsciiMocMapper() {
        String descrip = new StringBuffer().append("Region description using ASCII MOC syntax;\n").append("see <webref ").append("url='http://www.ivoa.net/documents/MOC/'>").append("MOC 2.0</webref> sec 4.3.2.\n").append("Note there are currently a few issues\n").append("with MOC plotting, especially for large pixels.").toString();
        return new AreaMapper("MOC-ASCII", descrip, (Class)String.class){

            @Override
            public Function<Object, Area> areaFunction(Class<?> clazz) {
                if (String.class.equals(clazz)) {
                    return obj -> obj instanceof String ? AreaDomain.mocArea((String)obj) : null;
                }
                return null;
            }
        };
    }

    private static AreaMapper createUniqMapper() {
        String descrip = String.join((CharSequence)"\n", "Region description representing a single HEALPix cell", "as defined by an UNIQ value, see", "<webref url='http://www.ivoa.net/documents/MOC/'>MOC 2.0</webref>", "sec 4.3.1.");
        return new AreaMapper("UNIQ", descrip, (Class)Number.class){

            @Override
            public Function<Object, Area> areaFunction(Class<?> clazz) {
                if (Integer.class.equals(clazz) || Long.class.equals(clazz)) {
                    return obj -> {
                        if (obj instanceof Integer || obj instanceof Long) {
                            long uniq = ((Number)obj).longValue();
                            double duniq = Double.longBitsToDouble(uniq);
                            return new Area(Area.Type.MOC, new double[]{duniq});
                        }
                        return null;
                    };
                }
                return null;
            }
        };
    }

    private static AreaMapper createTfcatMapper() {
        String stdUrl = "https://doi.org/10.25935/6068-8528";
        String descrip = String.join((CharSequence)"\n", "Time-Frequency region defined by the", "<webref url='https://doi.org/10.25935/6068-8528'>TFCat standard</webref>.", "Support is currently incomplete;", "holes in Polygons and MultiPolygons are not displayed correctly,", "single Points may not be displayed,", "and Coordinate Reference System information is ignored.", "");
        return new AreaMapper("TFCAT", descrip, (Class)String.class){

            @Override
            public Function<Object, Area> areaFunction(Class<?> clazz) {
                if (String.class.equals(clazz)) {
                    return obj -> obj instanceof String ? AreaDomain.tfcatArea((String)obj) : null;
                }
                return null;
            }

            @Override
            public String getSkySourceDescription() {
                return null;
            }
        };
    }

    private static AreaMapper createSimpleNumericDaliMapper(final Area.Type areaType, String descrip, final String skyDescrip) {
        return new AreaMapper(areaType.toString(), descrip, Object.class){

            @Override
            public Function<Object, Area> areaFunction(Class<?> clazz) {
                if (double[].class.equals(clazz)) {
                    return obj -> {
                        double[] data;
                        if (obj instanceof double[] && areaType.isLegalArrayLength((data = (double[])obj).length) && AreaDomain.allDefinite(data)) {
                            return new Area(areaType, data);
                        }
                        return null;
                    };
                }
                if (float[].class.equals(clazz)) {
                    return obj -> {
                        float[] fdata;
                        int nd;
                        if (obj instanceof float[] && areaType.isLegalArrayLength(nd = (fdata = (float[])obj).length) && AreaDomain.allDefinite(fdata)) {
                            double[] ddata = new double[nd];
                            for (int i = 0; i < nd; ++i) {
                                ddata[i] = fdata[i];
                            }
                            return new Area(areaType, ddata);
                        }
                        return null;
                    };
                }
                return null;
            }

            @Override
            public String getSkySourceDescription() {
                return skyDescrip;
            }
        };
    }

    private static AreaMapper createPolygonMapper() {
        final Area.Type polygonType = Area.Type.POLYGON;
        String descrip = "2n-element array (<code>x1</code>,<code>y1</code>, <code>x2</code>,<code>y2</code>,...);\na <code>NaN</code>,<code>NaN</code> pair can be used to delimit distinct polygons.";
        final String skyDescrip = "2n-element array (<code>ra1</code>,<code>dec1</code>, <code>ra2</code>,<code>dec2</code>,...);\na <code>NaN</code>,<code>NaN</code> pair can be used to delimit distinct polygons.";
        return new AreaMapper("POLYGON", descrip, Object.class){

            @Override
            public Function<Object, Area> areaFunction(Class<?> clazz) {
                if (double[].class.equals(clazz)) {
                    return obj -> {
                        if (obj instanceof double[]) {
                            double[] data = (double[])obj;
                            int nd = data.length;
                            if (polygonType.isLegalArrayLength(nd)) {
                                int ndef = 0;
                                for (int i = nd - 1; i >= ndef; --i) {
                                    if (Double.isNaN(data[i])) continue;
                                    ndef = i + 1;
                                }
                                if (polygonType.isLegalArrayLength(ndef)) {
                                    double[] pdata;
                                    if (ndef == nd) {
                                        pdata = data;
                                    } else {
                                        pdata = new double[ndef];
                                        System.arraycopy(data, 0, pdata, 0, ndef);
                                    }
                                    return new Area(polygonType, pdata);
                                }
                                return null;
                            }
                            return null;
                        }
                        return null;
                    };
                }
                if (float[].class.equals(clazz)) {
                    return obj -> {
                        if (obj instanceof float[]) {
                            float[] data = (float[])obj;
                            int nd = data.length;
                            if (polygonType.isLegalArrayLength(nd)) {
                                int ndef = 0;
                                for (int i = nd - 1; i >= ndef; --i) {
                                    if (Float.isNaN(data[i])) continue;
                                    ndef = i + 1;
                                }
                                if (polygonType.isLegalArrayLength(ndef)) {
                                    double[] pdata = new double[ndef];
                                    for (int i = 0; i < ndef; ++i) {
                                        pdata[i] = data[i];
                                    }
                                    return new Area(polygonType, pdata);
                                }
                                return null;
                            }
                            return null;
                        }
                        return null;
                    };
                }
                return null;
            }

            @Override
            public String getSkySourceDescription() {
                return skyDescrip;
            }
        };
    }

    private static Area stcsArea(CharSequence stcs, boolean allowPoint) {
        Matcher w0matcher = WORDS_PATTERN.matcher(stcs);
        if (w0matcher.lookingAt()) {
            String word0 = w0matcher.group(1).toUpperCase();
            CharSequence remainder = stcs.subSequence(w0matcher.end(), stcs.length());
            if ("CIRCLE".equals(word0)) {
                Area.Type circleType = Area.Type.CIRCLE;
                double[] numbers = AreaDomain.getNumbers(remainder);
                return circleType.isLegalArrayLength(numbers.length) ? new Area(circleType, numbers) : null;
            }
            if ("POLYGON".equals(word0)) {
                Area.Type polygonType = Area.Type.POLYGON;
                double[] numbers = AreaDomain.getNumbers(remainder);
                return polygonType.isLegalArrayLength(numbers.length) ? new Area(polygonType, numbers) : null;
            }
            if ("BOX".equals(word0)) {
                Area.Type polygonType = Area.Type.POLYGON;
                double[] numbers = AreaDomain.getNumbers(remainder);
                if (numbers.length == 4) {
                    double x1 = numbers[0];
                    double y1 = numbers[1];
                    double x2 = x1 + numbers[2];
                    double y2 = y1 + numbers[3];
                    double[] vertices = new double[]{x1, y1, x2, y1, x2, y2, x1, y2};
                    return new Area(Area.Type.POLYGON, vertices);
                }
                return null;
            }
            if (allowPoint && "POSITION".equals(word0)) {
                Area.Type pointType = Area.Type.POINT;
                double[] numbers = AreaDomain.getNumbers(remainder);
                return pointType.isLegalArrayLength(numbers.length) ? new Area(pointType, numbers) : null;
            }
            if ("UNION".equals(word0)) {
                Matcher parenMatcher = PARENTHESIS_PATTERN.matcher(remainder);
                if (!parenMatcher.matches()) {
                    return null;
                }
                Matcher termMatcher = TERM_PATTERN.matcher(parenMatcher.group(1));
                ArrayList<Area> shapes = new ArrayList<Area>();
                while (termMatcher.find()) {
                    Area termArea = AreaDomain.stcsArea(termMatcher.group(), allowPoint);
                    if (termArea != null) {
                        shapes.add(termArea);
                        continue;
                    }
                    return null;
                }
                return Area.createMultishape(shapes.toArray(new Area[0]));
            }
            if ("MOC".equals(word0)) {
                return AreaDomain.mocArea(remainder);
            }
            return null;
        }
        return null;
    }

    private static Area mocArea(CharSequence txt) {
        LongList list = new LongList();
        Area.Type mocType = Area.Type.MOC;
        Matcher tokenMatcher = SMOC_TOKENS_PATTERN.matcher(txt);
        long order = -1L;
        long kOrder = Integer.MIN_VALUE;
        while (tokenMatcher.find()) {
            String token = tokenMatcher.group(1);
            assert (token.length() > 0);
            Matcher matcher = MOC_PATTERN.matcher(token);
            if (!matcher.matches()) continue;
            String orderTxt = matcher.group(1);
            String ipix0Txt = matcher.group(2);
            String ipixnTxt = matcher.group(3);
            if (orderTxt != null) {
                order = Long.parseLong(orderTxt);
                kOrder = 4L << (int)(2L * order);
            }
            if (order < 0L || ipix0Txt == null) continue;
            long ipix0 = Long.parseLong(ipix0Txt);
            long ipixn = ipixnTxt == null ? ipix0 : Long.parseLong(ipixnTxt);
            for (long ipix = ipix0; ipix <= ipixn; ++ipix) {
                long nuniq = kOrder + ipix;
                list.add(nuniq);
            }
        }
        int n = list.size();
        if (n > 0) {
            double[] data = new double[n];
            for (int i = 0; i < n; ++i) {
                data[i] = Double.longBitsToDouble(list.get(i));
            }
            return new Area(Area.Type.MOC, data);
        }
        return null;
    }

    private static Area tfcatArea(CharSequence txt) {
        TfcatObject tfcat = TfcatUtil.parseTfcat((String)txt.toString(), null);
        if (tfcat == null) {
            return null;
        }
        List geoms = TfcatUtil.getAllGeometries((TfcatObject)tfcat);
        TfcatPointList plist = new TfcatPointList();
        for (Geometry geom : geoms) {
            Object shape = geom.getShape();
            if (shape instanceof Position) {
                plist.addPosition((Position)shape);
                plist.addBreak();
                continue;
            }
            if (shape instanceof Position[]) {
                plist.addLine((Position[])shape);
                plist.addBreak();
                continue;
            }
            if (shape instanceof Position[][]) {
                for (Position[] positionArray : (Position[][])shape) {
                    plist.addLine(positionArray);
                    plist.addBreak();
                }
                continue;
            }
            if (shape instanceof LinearRing[]) {
                plist.addPolygon((LinearRing[])shape);
                plist.addBreak();
                continue;
            }
            if (shape instanceof LinearRing[][]) {
                for (Position[] positionArray : (LinearRing[][])shape) {
                    plist.addPolygon((LinearRing[])positionArray);
                    plist.addBreak();
                }
                continue;
            }
            assert (false);
        }
        int n2 = plist.dlist_.size();
        if (n2 > 2) {
            int n = n2 - 2;
            double[] data = new double[n];
            System.arraycopy(plist.dlist_.getDoubleBuffer(), 0, data, 0, n);
            return new Area(Area.Type.POLYGON, data);
        }
        return null;
    }

    private static double[] getNumbers(CharSequence cseq) {
        Matcher matcher = NUMBER_PATTERN.matcher(cseq);
        DoubleList dlist = new DoubleList();
        while (matcher.find()) {
            dlist.add(Double.parseDouble(matcher.group(1)));
        }
        return dlist.toDoubleArray();
    }

    private static boolean allDefinite(double[] data) {
        if (data != null) {
            int n = data.length;
            for (int i = 0; i < n; ++i) {
                if (!Double.isNaN(data[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean allDefinite(float[] data) {
        if (data != null) {
            int n = data.length;
            for (int i = 0; i < n; ++i) {
                if (!Float.isNaN(data[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static class TfcatPointList {
        final DoubleList dlist_ = new DoubleList();

        TfcatPointList() {
        }

        void addPosition(Position position) {
            this.dlist_.add(position.getTime());
            this.dlist_.add(position.getSpectral());
        }

        void addLine(Position[] positions) {
            int ip;
            int np = positions.length;
            for (ip = 0; ip < np; ++ip) {
                this.addPosition(positions[ip]);
            }
            for (ip = np - 1; ip >= 0; --ip) {
                this.addPosition(positions[ip]);
            }
        }

        void addPolygon(LinearRing[] lrings) {
            if (lrings.length > 0) {
                for (Position pos : lrings[0].getDistinctPositions()) {
                    this.addPosition(pos);
                }
                this.addBreak();
            }
        }

        void addBreak() {
            this.dlist_.add(Double.NaN);
            this.dlist_.add(Double.NaN);
        }
    }
}

