/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class JupyterCell {
    private static final Map<?, ?> EMPTY_MAP = new HashMap();
    private static final List<?> EMPTY_LIST = new ArrayList();
    private final List<String> lines_;

    public JupyterCell(List<String> lines) {
        this.lines_ = lines;
    }

    public JupyterCell(String[] lines) {
        this(Arrays.asList(lines));
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("cell_type", (Object)"code");
        json.put("execution_count", JSONObject.NULL);
        json.put("metadata", EMPTY_MAP);
        json.put("outputs", EMPTY_LIST);
        json.put("source", (Collection)this.lines_.stream().map(s -> s + "\n").collect(Collectors.toList()));
        return json;
    }

    public static JSONObject toNotebook(List<JupyterCell> cells) {
        JSONObject cmode = new JSONObject();
        cmode.put("name", (Object)"ipython");
        cmode.put("version", 3);
        JSONObject langinfo = new JSONObject();
        langinfo.put("codemirror_mode", (Object)cmode);
        langinfo.put("file_extension", (Object)".py");
        langinfo.put("mimetype", (Object)"text/x-python");
        langinfo.put("name", (Object)"python");
        langinfo.put("nbconvert_exporter", (Object)"python");
        langinfo.put("pygments_lexer", (Object)"ipython3");
        langinfo.put("version", (Object)"3.6.7");
        JSONObject kernelspec = new JSONObject();
        kernelspec.put("display_name", (Object)"Python 3");
        kernelspec.put("language", (Object)"python");
        kernelspec.put("name", (Object)"python3");
        JSONObject meta = new JSONObject();
        meta.put("kernelspec", (Object)kernelspec);
        meta.put("language_info", (Object)langinfo);
        JSONObject json = new JSONObject();
        json.put("cells", (Collection)cells.stream().map(JupyterCell::toJson).collect(Collectors.toList()));
        json.put("metadata", (Object)meta);
        json.put("nbformat", 4);
        json.put("nbformat_minor", 2);
        return json;
    }
}

