/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.io.PrintStream;
import java.util.Arrays;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.build.UsageWriter;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.OutputModeParameter;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;

public class ModeDoc {
    private final PrintStream out_;

    private ModeDoc(PrintStream out) {
        this.out_ = out;
    }

    private void write() throws LoadException {
        ObjectFactory<ProcessingMode> modeFact = Stilts.getModeFactory();
        Object[] mnames = modeFact.getNickNames();
        Arrays.sort(mnames);
        OutputModeParameter omodeParam = new OutputModeParameter("omode");
        for (int i = 0; i < mnames.length; ++i) {
            Object name = mnames[i];
            String modeId = "mode-" + (String)name;
            ProcessingMode mode = (ProcessingMode)modeFact.createObject((String)name);
            this.out_.println("<subsubsect id=\"" + modeId + "\">");
            this.out_.println("<subhead><title><code>" + (String)name + "</code></title></subhead>");
            this.out_.print("<p>");
            this.out_.println("<strong>Usage:</strong>");
            this.out_.print("<verbatim>");
            this.out_.print("<![CDATA[");
            this.out_.print(omodeParam.getModeUsage((String)name, 3));
            this.out_.print("]]>");
            this.out_.print("</verbatim>");
            this.out_.print("</p>");
            this.out_.println();
            String descrip = mode.getDescription();
            if (descrip == null) {
                throw new IllegalArgumentException("No description for mode " + (String)name);
            }
            this.out_.print(descrip);
            Parameter<?>[] params = mode.getAssociatedParameters();
            if (params.length > 0) {
                this.out_.println("<p>Additional parameters for this output mode are:<dl>");
                for (int j = 0; j < params.length; ++j) {
                    this.out_.println(UsageWriter.xmlItem(params[j], modeId, false));
                }
                this.out_.println("</dl></p>");
            }
            this.out_.println("</subsubsect>");
        }
    }

    public static void main(String[] args) throws LoadException {
        new ModeDoc(System.out).write();
    }
}

