/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.calc;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.MetadataStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.calc.MultiServiceColumnCalculator;
import uk.ac.starlink.ttools.calc.ServiceOperation;
import uk.ac.starlink.util.CgiQuery;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.util.URLUtils;

public class SchlegelCalculator
extends MultiServiceColumnCalculator<Spec> {
    public static final String SERVICE_URL = "http://irsa.ipac.caltech.edu/cgi-bin/DUST/nph-dust?";
    public static final Statistic DEFAULT_STAT = Statistic.MEAN;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.calc");

    @Override
    public ValueInfo[] getTupleInfos() {
        DefaultValueInfo raInfo = new DefaultValueInfo((ValueInfo)Tables.RA_INFO);
        DefaultValueInfo decInfo = new DefaultValueInfo((ValueInfo)Tables.DEC_INFO);
        raInfo.setUnitString("deg");
        decInfo.setUnitString("deg");
        return new ValueInfo[]{raInfo, decInfo};
    }

    private static String getQueryUrl(Spec spec, Object[] tuple) {
        double ra = SchlegelCalculator.getRangedValue(tuple[0], -180.0, 360.0);
        double dec = SchlegelCalculator.getRangedValue(tuple[1], -90.0, 90.0);
        if (Double.isNaN(ra) || Double.isNaN(dec)) {
            return null;
        }
        return new StringBuffer().append(SERVICE_URL).append("locstr=").append(CgiQuery.formatDouble((double)ra, (int)6, (int)16)).append("+").append(CgiQuery.formatDouble((double)dec, (int)6, (int)16)).append("+equ+j2000").toString();
    }

    @Override
    public ServiceOperation createServiceOperation(final Spec spec) {
        return new ServiceOperation(){

            @Override
            public StarTable getResultMetadata() {
                ValueInfo[] resultInfos = spec.getResultInfos();
                int ncol = resultInfos.length;
                ColumnInfo[] colInfos = new ColumnInfo[ncol];
                for (int ic = 0; ic < ncol; ++ic) {
                    colInfos[ic] = new ColumnInfo(resultInfos[ic]);
                }
                MetadataStarTable meta = new MetadataStarTable(colInfos);
                meta.getParameters().addAll(Arrays.asList(SchlegelCalculator.createServiceParams()));
                return meta;
            }

            @Override
            public Object[] calculateRow(Object[] tuple) throws IOException {
                return spec.calculateRow(tuple);
            }
        };
    }

    private static DescribedValue[] createServiceParams() {
        return new DescribedValue[]{new DescribedValue((ValueInfo)new DefaultValueInfo("Schlegel_Service", String.class, null), (Object)"Schlegel parameters from http://irsa.ipac.caltech.edu/cgi-bin/DUST/nph-dust?"), new DescribedValue((ValueInfo)new DefaultValueInfo("Schlegel_Paper", String.class, null), (Object)"D.J. Schlegel, D.P. Finkbeiner, & M. Davis (1998, ApJ, 500, 525)"), new DescribedValue((ValueInfo)new DefaultValueInfo("IPAC_Acknowledgement", String.class, null), (Object)"This research has made use of the NASA/IPAC Infrared Science Archive, which is operated by the Jet Propulsion Laboratory, California Institute of Technology, under contract with the National Aeronautics and Space Administration.")};
    }

    private static double getRangedValue(Object obj, double min, double max) {
        if (obj instanceof Number) {
            double dval = ((Number)obj).doubleValue();
            return dval >= min && dval <= max ? dval : Double.NaN;
        }
        return Double.NaN;
    }

    private static String getTextContent(Node node) {
        return node instanceof Element ? DOMUtils.getTextContent((Element)((Element)node)) : null;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            args = new String[]{"137", "-23.4"};
        }
        Object[] tuple = new Double[]{Double.valueOf(args[0]), Double.valueOf(args[1])};
        ResultType[] rtypes = new ResultType[]{ResultType.REDDENING, ResultType.EMISSION};
        Statistic[] stats = new Statistic[]{Statistic.MEAN, Statistic.STD};
        Spec spec = new Spec(rtypes, stats);
        ValueInfo[] infos = spec.getResultInfos();
        Object[] results = spec.calculateRow(tuple);
        for (int ic = 0; ic < infos.length; ++ic) {
            System.out.println(infos[ic] + " = " + results[ic] + " (" + infos[ic].getDescription() + ")");
        }
    }

    public static final class ResultType
    extends Enum<ResultType> {
        public static final /* enum */ ResultType REDDENING = new ResultType("Reddening", "E(B-V) Reddening", "mag");
        public static final /* enum */ ResultType EMISSION = new ResultType("Emission", "100 Micron Emission", "MJy/sr");
        public static final /* enum */ ResultType TEMPERATURE = new ResultType("Temperature", "Dust Temperature", "K");
        private final String title_;
        private final String fullDesc_;
        private final String unit_;
        private final Pattern valueRegex_;
        private static final /* synthetic */ ResultType[] $VALUES;

        public static ResultType[] values() {
            return (ResultType[])$VALUES.clone();
        }

        public static ResultType valueOf(String name) {
            return Enum.valueOf(ResultType.class, name);
        }

        private ResultType(String title, String fullDesc, String unit) {
            this.title_ = title;
            this.fullDesc_ = fullDesc;
            this.unit_ = unit;
            this.valueRegex_ = Pattern.compile("\\s*([0-9eE+.\\-]*)\\s*\\(" + unit.trim() + "\\)\\s*");
        }

        ValueInfo createInfo(Statistic stat) {
            String name = this.title_;
            if (stat != DEFAULT_STAT) {
                name = name + "_" + stat.nickName_;
            }
            String desc = "Schlegel " + this.fullDesc_ + " " + stat.desc_;
            DefaultValueInfo info = new DefaultValueInfo(name, Float.class, desc);
            info.setUnitString(this.unit_);
            return info;
        }

        Map<String, Float> getStatsMap(Element resultsEl) {
            LinkedHashMap<String, Float> statsMap = new LinkedHashMap<String, Float>();
            Element statsEl = this.getStatsElement(resultsEl);
            if (statsEl != null) {
                for (Node node = statsEl.getFirstChild(); node != null; node = node.getNextSibling()) {
                    Float value;
                    String txt = SchlegelCalculator.getTextContent(node);
                    if (txt == null || (value = this.getTypedValue(txt)) == null) continue;
                    statsMap.put(node.getNodeName(), value);
                }
            }
            return statsMap;
        }

        private Element getStatsElement(Element resultsEl) {
            NodeList rlist = resultsEl.getElementsByTagName("result");
            for (int ir = 0; ir < rlist.getLength(); ++ir) {
                Element rEl = (Element)rlist.item(ir);
                NodeList dlist = rEl.getElementsByTagName("desc");
                for (int id = 0; id < dlist.getLength(); ++id) {
                    Element dEl = (Element)dlist.item(id);
                    if (!this.fullDesc_.trim().equalsIgnoreCase(SchlegelCalculator.getTextContent(dEl).trim())) continue;
                    NodeList slist = rEl.getElementsByTagName("statistics");
                    if (slist.getLength() == 1) {
                        return (Element)slist.item(0);
                    }
                    return null;
                }
            }
            return null;
        }

        private Float getTypedValue(String txt) {
            Matcher matcher = this.valueRegex_.matcher(txt);
            if (matcher.matches()) {
                try {
                    return Float.valueOf(matcher.group(1));
                }
                catch (NumberFormatException e) {
                    assert (false);
                    return null;
                }
            }
            return null;
        }

        static {
            $VALUES = new ResultType[]{REDDENING, EMISSION, TEMPERATURE};
        }
    }

    public static enum Statistic {
        MEAN("meanValue", "mean", "mean value"),
        REF_PIXEL("refPixelValue", "refpix", "value at reference pixel"),
        STD("std", "std", "standard deviation"),
        MAX("maxValue", "max", "maximum value"),
        MIN("minValue", "min", "minimum value");

        private final String elName_;
        private final String nickName_;
        private final String desc_;

        private Statistic(String elName, String nickName, String desc) {
            this.elName_ = elName;
            this.nickName_ = nickName;
            this.desc_ = desc;
        }
    }

    public static class Spec {
        private final ResultType[] rtypes_;
        private final Statistic[] stats_;
        private final DocumentBuilderFactory dbf_;

        public Spec(ResultType[] rtypes, Statistic[] stats) {
            this.rtypes_ = rtypes;
            this.stats_ = stats;
            this.dbf_ = DocumentBuilderFactory.newInstance();
        }

        public ValueInfo[] getResultInfos() {
            ArrayList<ValueInfo> infoList = new ArrayList<ValueInfo>();
            for (int ir = 0; ir < this.rtypes_.length; ++ir) {
                ResultType rtype = this.rtypes_[ir];
                for (int is = 0; is < this.stats_.length; ++is) {
                    Statistic stat = this.stats_[is];
                    infoList.add(rtype.createInfo(stat));
                }
            }
            return infoList.toArray(new ValueInfo[0]);
        }

        Object[] calculateRow(Object[] tuple) throws IOException {
            Object[] row = new Float[this.rtypes_.length * this.stats_.length];
            String url = SchlegelCalculator.getQueryUrl(this, tuple);
            if (url == null) {
                return row;
            }
            Element resultsEl = this.getOkResultsElement(URLUtils.newURL((String)url));
            int ic = 0;
            for (int ir = 0; ir < this.rtypes_.length; ++ir) {
                ResultType rtype = this.rtypes_[ir];
                Map<String, Float> statsMap = rtype.getStatsMap(resultsEl);
                for (int is = 0; is < this.stats_.length; ++is) {
                    Statistic stat = this.stats_[is];
                    row[ic++] = statsMap.get(stat.elName_);
                }
            }
            assert (ic == row.length);
            return row;
        }

        private Element getOkResultsElement(URL url) throws IOException {
            Document doc;
            logger_.info(url.toString());
            try {
                doc = this.dbf_.newDocumentBuilder().parse(url.openStream());
            }
            catch (ParserConfigurationException e) {
                throw (IOException)new IOException("XML parsing trouble").initCause(e);
            }
            catch (SAXException e) {
                throw (IOException)new IOException("XML Parse failure for " + url).initCause(e);
            }
            Element el = doc.getDocumentElement();
            if (!"results".equals(el.getTagName())) {
                throw new IOException("Result from Schlegel service is not <results>");
            }
            String status = el.getAttribute("status");
            if ("error".equals(status)) {
                NodeList msgEls = el.getElementsByTagName("message");
                String message = msgEls.getLength() == 1 && msgEls.item(0) instanceof Text ? ((Text)msgEls.item(0)).getWholeText().trim() : "<no message available>";
                throw new IOException("Schlegel query failed: " + message + "(" + url + ")");
            }
            if ("ok".equals(status)) {
                return el;
            }
            logger_.warning("Unknown status \"" + status + "\" for results element");
            return el;
        }
    }
}

