/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.calc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.ttools.func.URLs;
import uk.ac.starlink.util.URLUtils;

public abstract class WebMapper {
    private final String name_;
    public static final WebMapper FILE = new WebMapper("Filename"){

        @Override
        public URL toUrl(String txt) {
            File file = new File(txt);
            return file.exists() ? URLUtils.makeFileURL((File)file) : null;
        }
    };
    public static final WebMapper URL = new WebMapper("URL"){

        @Override
        public URL toUrl(String txt) {
            try {
                return URLUtils.newURL((String)txt);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
    };
    public static final WebMapper BIBCODE = WebMapper.createBibcodeMapper("Bibcode", false);
    public static final WebMapper DOI = WebMapper.createDoiMapper("DOI");
    public static final WebMapper ARXIV = WebMapper.createArxivMapper("arXiv");
    public static final WebMapper SIMBAD = WebMapper.createPrefixMapper("SIMBAD", "http://simbad.u-strasbg.fr/simbad/sim-id?Ident=");
    public static final WebMapper NED = WebMapper.createPrefixMapper("NED", "http://ned.ipac.caltech.edu/byname?objname=");
    private static final WebMapper[] SELECTIVE_MAPPERS = new WebMapper[]{URL, FILE, BIBCODE, DOI, ARXIV};
    private static final WebMapper[] UNSELECTIVE_MAPPERS = new WebMapper[]{SIMBAD, NED};
    public static final WebMapper BIBCODE_OLD = WebMapper.createBibcodeMapper("BibcodeClassic", true);
    public static final WebMapper NED_CLASSIC = WebMapper.createPrefixMapper("NED", "http://ned.ipac.caltech.edu/cgi-bin/objsearch?extend=no&objname=");
    public static final WebMapper AUTO = WebMapper.createMultiMapper("auto", SELECTIVE_MAPPERS);

    protected WebMapper(String name) {
        this.name_ = name;
    }

    public abstract URL toUrl(String var1);

    public String getName() {
        return this.name_;
    }

    public String toString() {
        return this.name_;
    }

    public static WebMapper[] getMappers() {
        ArrayList<WebMapper> list = new ArrayList<WebMapper>();
        list.add(AUTO);
        list.addAll(Arrays.asList(SELECTIVE_MAPPERS));
        list.addAll(Arrays.asList(UNSELECTIVE_MAPPERS));
        return list.toArray(new WebMapper[0]);
    }

    private static URL stringToUrl(String url) {
        try {
            return URLUtils.newURL((String)url);
        }
        catch (MalformedURLException e) {
            assert (false);
            return null;
        }
    }

    private static WebMapper createBibcodeMapper(String name, boolean isClassic) {
        final String urlPrefix = isClassic ? "http://adsabs.harvard.edu/abs/" : "https://ui.adsabs.harvard.edu/abs/";
        final Pattern bibcodeRegex = Pattern.compile("[12][0-9]{3}[A-Za-z]\\S{4}\\S{4}\\S[0-9.]{4}[A-Z]");
        return new WebMapper(name){

            @Override
            public URL toUrl(String txt) {
                return bibcodeRegex.matcher(txt).matches() ? WebMapper.stringToUrl(urlPrefix + URLs.urlEncode(txt)) : null;
            }
        };
    }

    private static WebMapper createDoiMapper(String name) {
        String urlPrefix = "https://doi.org/";
        final Pattern doiRegex = Pattern.compile("(?:doi:)?(10[.][0-9]{4,}(?:[.][0-9]+)*)/(.+)");
        return new WebMapper(name){

            @Override
            public URL toUrl(String txt) {
                Matcher matcher = doiRegex.matcher(txt);
                if (matcher.matches()) {
                    String doiPrefix = matcher.group(1);
                    String doiSuffix = matcher.group(2);
                    return WebMapper.stringToUrl(new StringBuffer().append("https://doi.org/").append(doiPrefix).append('/').append(URLs.urlEncode(doiSuffix)).toString());
                }
                return null;
            }
        };
    }

    private static WebMapper createArxivMapper(String name) {
        int maxDecade;
        String urlPrefix = "https://arxiv.org/abs/";
        int year = new GregorianCalendar().get(1);
        int n = maxDecade = year > 2007 && year < 2097 ? (year - 2000 + 2) / 10 : 9;
        assert (Integer.toString(maxDecade).length() == 1);
        final Pattern post07Regex = Pattern.compile("(?:ar[xX]iv:)?[0-" + maxDecade + "][0-9](0[1-9]|1[0-2])[.][0-9]{4,5}(v[1-9][0-9]*)?");
        final Pattern pre07Regex = Pattern.compile("(?:ar[xX]iv:)?(astro-ph|cond-mat|gr-qc|hep-ex|hep-lat|hep-ph|hep-th|math-ph|nlin|nucl-ex|nucl-th|physics|quant-ph|math|CoRR|q-bio|q-fin|stat|eess)([.][A-Z][A-Z])?/[09][0-9](0[1-9]|1[0-2])[0-9][0-9][0-9]");
        return new WebMapper(name){

            @Override
            public URL toUrl(String txt) {
                if (pre07Regex.matcher(txt).matches() || post07Regex.matcher(txt).matches()) {
                    String id = txt.toLowerCase().startsWith("arxiv:") ? txt.substring(6) : txt;
                    return WebMapper.stringToUrl("https://arxiv.org/abs/" + id);
                }
                return null;
            }
        };
    }

    public static WebMapper createPrefixMapper(String name, final String urlPrefix) {
        return new WebMapper(name){

            @Override
            public URL toUrl(String txt) {
                return txt == null || txt.trim().length() == 0 ? null : WebMapper.stringToUrl(urlPrefix + URLs.urlEncode(txt));
            }
        };
    }

    public static WebMapper createMultiMapper(String name, final WebMapper[] others) {
        return new WebMapper(name){

            @Override
            public URL toUrl(String txt) {
                for (WebMapper other : others) {
                    URL url = other.toUrl(txt);
                    if (url == null) continue;
                    return url;
                }
                return null;
            }
        };
    }
}

