/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import cds.healpix.CompassPoint;
import cds.healpix.FlatHashIterator;
import cds.healpix.HashComputer;
import cds.healpix.HealpixNestedBMOC;
import cds.healpix.VerticesAndPathComputer;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class CdsHealpixUtil {
    private static final double HALF_PI = 1.5707963267948966;
    public static final int DFLT_INTERPOLATE_DEPTH = 5;

    private CdsHealpixUtil() {
    }

    public static void lonlatToVector(double lonRad, double latRad, double[] xyz) {
        double theta = 1.5707963267948966 - latRad;
        double phi = lonRad;
        double sd = Math.sin(theta);
        double x = Math.cos(phi) * sd;
        double y = Math.sin(phi) * sd;
        double z = Math.cos(theta);
        xyz[0] = x;
        xyz[1] = y;
        xyz[2] = z;
    }

    public static void lonlatToVector(double[] lonlatRad, double[] xyz) {
        CdsHealpixUtil.lonlatToVector(lonlatRad[0], lonlatRad[1], xyz);
    }

    public static double[] lonlatToVector(double[] lonlatRad) {
        double[] xyz = new double[3];
        CdsHealpixUtil.lonlatToVector(lonlatRad[0], lonlatRad[1], xyz);
        return xyz;
    }

    public static long vectorToHash(HashComputer hasher, double[] xyz) {
        double phi;
        double x = xyz[0];
        double y = xyz[1];
        double z = xyz[2];
        double theta = Math.acos(z);
        double lonRad = phi = Math.atan2(y, x);
        double latRad = 1.5707963267948966 - theta;
        return hasher.hash(lonRad, latRad);
    }

    public static void vectorToLonlat(double[] xyz, double[] lonlatRad) {
        double phi;
        double x = xyz[0];
        double y = xyz[1];
        double z = xyz[2];
        double theta = Math.acos(z);
        double lonRad = phi = Math.atan2(y, x);
        double latRad = 1.5707963267948966 - theta;
        lonlatRad[0] = lonRad;
        lonlatRad[1] = latRad;
    }

    public static double[] vectorToLonlat(double[] xyz) {
        double[] lonlat = new double[2];
        CdsHealpixUtil.vectorToLonlat(xyz, lonlat);
        return lonlat;
    }

    public static Set<Long> bmocSet(final HealpixNestedBMOC bmoc) {
        return new AbstractSet<Long>(){
            private int size_ = -1;

            @Override
            public int size() {
                if (this.size_ < 0) {
                    this.size_ = (int)bmoc.computeDeepSize();
                }
                return this.size_;
            }

            @Override
            public Iterator<Long> iterator() {
                final FlatHashIterator fhit = bmoc.flatHashIterator();
                return new Iterator<Long>(){

                    @Override
                    public boolean hasNext() {
                        return fhit.hasNext();
                    }

                    @Override
                    public Long next() {
                        return fhit.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static int lonlatVertices(VerticesAndPathComputer vpc, long hash, int minDepth, double[][] lonlats) {
        int nseg = 1 << Math.max(0, minDepth - vpc.depth());
        vpc.pathAlongCellEdge(hash, CompassPoint.Cardinal.E, true, nseg, lonlats);
        return 4 * nseg;
    }

    public static double[][] lonlatVertices(VerticesAndPathComputer vpc, long hash, int minDepth) {
        int nseg = 1 << Math.max(0, minDepth - vpc.depth());
        double[][] lonlats = new double[4 * nseg][2];
        int nv = CdsHealpixUtil.lonlatVertices(vpc, hash, minDepth, lonlats);
        assert (nv == lonlats.length);
        return lonlats;
    }
}

