/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.net.URL;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.cone.ConeSearchConer;
import uk.ac.starlink.ttools.cone.ConeSearcher;
import uk.ac.starlink.ttools.cone.Coverage;
import uk.ac.starlink.ttools.cone.ServiceConeSearcher;
import uk.ac.starlink.ttools.cone.SiaConeSearcher;
import uk.ac.starlink.ttools.cone.SsaConeSearcher;
import uk.ac.starlink.ttools.cone.UrlMocCoverage;
import uk.ac.starlink.ttools.task.TableCone;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.ConeSearch;
import uk.ac.starlink.vo.SiaFormatOption;
import uk.ac.starlink.vo.SiaVersion;

public abstract class ConeServiceType {
    private final String name_;
    public static final ConeServiceType CONE = new SimpleConeServiceType("cone");
    public static final ConeServiceType SSA = new SsaServiceType("ssa");
    public static final ConeServiceType SIA1 = new SiaServiceType("sia1", SiaVersion.V10);
    public static final ConeServiceType SIA2 = new SiaServiceType("sia2", SiaVersion.V20);
    public static final ConeServiceType SIA = new SiaServiceType("sia", SiaVersion.V10){

        @Override
        public String getDescription() {
            return "alias for <code>" + super.toString() + "</code>";
        }
    };
    private static final String BELIEVE_EMPTY_NAME = "emptyok";
    private static final String INCONSISTENT_EMPTY_ADVICE = "emptyok=false";

    protected ConeServiceType(String name) {
        this.name_ = name;
    }

    public abstract String getDescription();

    public abstract String getFormatDescription();

    public abstract void configureRadiusParam(Parameter<Double> var1);

    public abstract ConeSearcher createSingleSearcher(Environment var1, TableCone var2, String var3, StarTableFactory var4, ContentCoding var5) throws TaskException;

    public abstract ConeSearcher createMultiSearcher(Environment var1, ConeSearchConer var2, String var3, boolean var4, StarTableFactory var5, ContentCoding var6) throws TaskException;

    public abstract boolean useDistanceFilter();

    public abstract Coverage getCoverage(URL var1, int var2);

    public String toString() {
        return this.name_;
    }

    public static ConeServiceType[] getDistinctTypes() {
        return new ConeServiceType[]{CONE, SIA1, SIA2, SSA};
    }

    public static ConeServiceType[] getAllTypes() {
        return new ConeServiceType[]{CONE, SSA, SIA1, SIA2, SIA};
    }

    private static int getVerbosity(Environment env, Parameter<String> verbParam) throws TaskException {
        String sverb = verbParam.stringValue(env);
        if (sverb == null) {
            return -1;
        }
        try {
            return Integer.parseInt(sverb);
        }
        catch (NumberFormatException e) {
            assert (false);
            throw new ParameterValueException(verbParam, e.getMessage(), (Throwable)e);
        }
    }

    private static class SsaServiceType
    extends ConeServiceType {
        SsaServiceType(String name) {
            super(name);
        }

        @Override
        public String getDescription() {
            return new StringBuffer().append("Simple Spectral Access protocol ").append(" - returns a table of spectra near each location.\n").append("See <webref url='").append("http://www.ivoa.net/Documents/latest/SSA.html").append("'>SSA standard</webref>.").toString();
        }

        @Override
        public String getFormatDescription() {
            return new StringBuffer().append("gives the MIME type of spectra referenced in the ").append("output table, also special values ").append("\"<code>votable</code>\", ").append("\"<code>fits</code>\", ").append("\"<code>compliant</code>\", ").append("\"<code>graphic</code>\", ").append("\"<code>all</code>\", and others\n").append("(value of the SSA FORMAT parameter).").toString();
        }

        @Override
        public void configureRadiusParam(Parameter<Double> srParam) {
            srParam.setNullPermitted(true);
        }

        @Override
        public ConeSearcher createSingleSearcher(Environment env, TableCone coneTask, String url, StarTableFactory tfact, ContentCoding coding) throws TaskException {
            String format = coneTask.getFormatParameter().stringValue(env);
            return new SsaConeSearcher(url, format, true, tfact, coding);
        }

        @Override
        public ConeSearcher createMultiSearcher(Environment env, ConeSearchConer conerTask, String url, boolean believeEmpty, StarTableFactory tfact, ContentCoding coding) throws TaskException {
            String format = conerTask.getFormatParameter().stringValue(env);
            return new SsaConeSearcher(url, format, believeEmpty, tfact, coding){

                @Override
                protected String getInconsistentEmptyAdvice() {
                    return ConeServiceType.INCONSISTENT_EMPTY_ADVICE;
                }
            };
        }

        @Override
        public boolean useDistanceFilter() {
            return true;
        }

        @Override
        public Coverage getCoverage(URL url, int nside) {
            return null;
        }
    }

    private static class SiaServiceType
    extends ConeServiceType {
        final SiaVersion version_;

        SiaServiceType(String name, SiaVersion version) {
            super(name);
            this.version_ = version;
        }

        @Override
        public String getDescription() {
            return new StringBuffer().append("Simple Image Access protocol version ").append(this.version_.getMajorVersion()).append(" - returns a table of images near each location.\n").append("See <webref url='").append(this.version_.getDocumentUrl()).append("'>SIA ").append(this.version_).append(" standard</webref>.").toString();
        }

        @Override
        public String getFormatDescription() {
            StringBuffer sbuf = new StringBuffer().append("gives the MIME type required for images/resources\n").append("referenced in the output table,\n").append("corresponding to the SIA FORMAT parameter.\n").append("The special values ").append("\"<code>GRAPHIC</code>\" (all graphics formats) and ").append("\"<code>ALL</code>\" (no restriction)\n").append("as defined by SIAv1 are also permissible.\n");
            if (this.version_.getMajorVersion() == 1) {
                sbuf.append("For SIA version 1 only, this defaults to").append("<code>\"image/fits\"</code>.");
            }
            return sbuf.toString();
        }

        @Override
        public void configureRadiusParam(Parameter<Double> srParam) {
            srParam.setStringDefault("0");
            srParam.setNullPermitted(false);
        }

        @Override
        public ConeSearcher createSingleSearcher(Environment env, TableCone coneTask, String url, StarTableFactory tfact, ContentCoding coding) throws TaskException {
            Parameter<String> formatParam = coneTask.getFormatParameter();
            if (this.version_.getMajorVersion() == 1) {
                formatParam.setStringDefault("image/fits");
            }
            String formatTxt = formatParam.stringValue(env);
            SiaFormatOption format = SiaFormatOption.fromObject((Object)formatTxt);
            return new SiaConeSearcher(url, this.version_, format, true, tfact, coding);
        }

        @Override
        public ConeSearcher createMultiSearcher(Environment env, ConeSearchConer conerTask, String url, boolean believeEmpty, StarTableFactory tfact, ContentCoding coding) throws TaskException {
            Parameter<String> formatParam = conerTask.getFormatParameter();
            if (this.version_.getMajorVersion() == 1) {
                formatParam.setStringDefault("image/fits");
            }
            String formatTxt = formatParam.stringValue(env);
            SiaFormatOption format = SiaFormatOption.fromObject((Object)formatTxt);
            return new SiaConeSearcher(url, this.version_, format, believeEmpty, tfact, coding){

                @Override
                protected String getInconsistentEmptyAdvice() {
                    return ConeServiceType.INCONSISTENT_EMPTY_ADVICE;
                }
            };
        }

        @Override
        public boolean useDistanceFilter() {
            return false;
        }

        @Override
        public Coverage getCoverage(URL url, int nside) {
            return null;
        }
    }

    private static class SimpleConeServiceType
    extends ConeServiceType {
        SimpleConeServiceType(String name) {
            super(name);
        }

        @Override
        public String getDescription() {
            return new StringBuffer().append("Cone Search protocol ").append("- returns a table of objects found ").append("near each location.\n").append("See <webref url='").append("http://www.ivoa.net/Documents/latest/ConeSearch.html").append("'>Cone Search standard</webref>.").toString();
        }

        @Override
        public String getFormatDescription() {
            return "not used";
        }

        @Override
        public void configureRadiusParam(Parameter<Double> srParam) {
            srParam.setNullPermitted(false);
        }

        @Override
        public ConeSearcher createSingleSearcher(Environment env, TableCone coneTask, String url, StarTableFactory tfact, ContentCoding coding) throws TaskException {
            int verb = ConeServiceType.getVerbosity(env, (Parameter<String>)coneTask.getVerbosityParameter());
            return new ServiceConeSearcher(new ConeSearch(url, coding), verb, true, tfact);
        }

        @Override
        public ConeSearcher createMultiSearcher(Environment env, ConeSearchConer conerTask, String url, boolean believeEmpty, StarTableFactory tfact, ContentCoding coding) throws TaskException {
            int verb = ConeServiceType.getVerbosity(env, (Parameter<String>)conerTask.getVerbosityParameter());
            return new ServiceConeSearcher(new ConeSearch(url, coding), verb, believeEmpty, tfact){

                @Override
                protected String getInconsistentEmptyAdvice() {
                    return ConeServiceType.INCONSISTENT_EMPTY_ADVICE;
                }
            };
        }

        @Override
        public boolean useDistanceFilter() {
            return true;
        }

        @Override
        public Coverage getCoverage(URL url, int nside) {
            return UrlMocCoverage.getServiceMoc(url, nside);
        }
    }
}

