/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import uk.ac.starlink.table.RowPermutedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.cone.CdsHealpix;
import uk.ac.starlink.ttools.cone.ConeQueryRowSequence;
import uk.ac.starlink.ttools.cone.QuerySequenceFactory;
import uk.ac.starlink.ttools.cone.WrapperQuerySequence;

public class HealpixSortedQuerySequenceFactory
implements QuerySequenceFactory {
    private final QuerySequenceFactory baseFact_;
    private final CdsHealpix hpix_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.cone");
    private static final int ORDER = 12;

    public HealpixSortedQuerySequenceFactory(QuerySequenceFactory baseFact) {
        this.baseFact_ = baseFact;
        this.hpix_ = CdsHealpix.getInstance();
    }

    @Override
    public ConeQueryRowSequence createQuerySequence(StarTable table) throws IOException {
        if (!table.isRandom()) {
            throw new IllegalArgumentException("Non-random-access table");
        }
        logger_.info("Pre-sorting rows by HEALPix index, order 12");
        int nrow = Tables.checkedLongToInt((long)table.getRowCount());
        long[] codes = new long[nrow];
        ConeQueryRowSequence preSeq = this.baseFact_.createQuerySequence(table);
        int irow = 0;
        while (preSeq.next()) {
            double ra = preSeq.getRa();
            double dec = preSeq.getDec();
            long lndex = preSeq.getIndex();
            int hpixIndex = Tables.assertLongToInt((long)this.hpix_.ang2pix(12, ra, dec));
            int rowIndex = Tables.assertLongToInt((long)lndex);
            codes[irow] = HealpixSortedQuerySequenceFactory.packHpixRow(hpixIndex, rowIndex);
            ++irow;
        }
        preSeq.close();
        logger_.config("Sorting " + irow + " HEALPix indices");
        Arrays.sort(codes, 0, irow);
        final long[] rowMap = new long[irow];
        for (int ir = 0; ir < irow; ++ir) {
            rowMap[ir] = HealpixSortedQuerySequenceFactory.unpackRowIndex(codes[ir]);
        }
        RowPermutedStarTable sortedTable = new RowPermutedStarTable(table, rowMap);
        return new WrapperQuerySequence(this.baseFact_.createQuerySequence((StarTable)sortedTable)){

            @Override
            public long getIndex() throws IOException {
                return rowMap[Tables.assertLongToInt((long)super.getIndex())];
            }
        };
    }

    private static long packHpixRow(int healpixIndex, int rowIndex) {
        return (long)healpixIndex << 32 | (long)rowIndex;
    }

    private static int unpackRowIndex(long packed) {
        return (int)packed;
    }
}

