/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.IOException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.cone.ConeQueryRowSequence;
import uk.ac.starlink.ttools.cone.QuerySequenceFactory;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.SequentialJELRowReader;
import uk.ac.starlink.ttools.task.SkyCoordParameter;

public class JELQuerySequenceFactory
implements QuerySequenceFactory {
    private final String raString_;
    private final String decString_;
    private final String srString_;

    public JELQuerySequenceFactory(String raExpr, String decExpr, String srExpr) {
        this.raString_ = raExpr;
        this.decString_ = decExpr;
        this.srString_ = srExpr;
    }

    @Override
    public ConeQueryRowSequence createQuerySequence(StarTable table) throws IOException {
        return new JELQuerySequence(table, this.raString_, this.decString_, this.srString_);
    }

    private static class JELQuerySequence
    extends SequentialJELRowReader
    implements ConeQueryRowSequence {
        private final Library lib_ = JELUtils.getLibrary(this);
        private final CompiledExpression raExpr_;
        private final CompiledExpression decExpr_;
        private final CompiledExpression srExpr_;

        JELQuerySequence(StarTable table, String raString, String decString, String srString) throws IOException {
            super(table);
            if (raString == null || raString.trim().length() == 0) {
                raString = SkyCoordParameter.guessRaDegreesExpression(table);
            }
            if (decString == null || decString.trim().length() == 0) {
                decString = SkyCoordParameter.guessDecDegreesExpression(table);
            }
            if (raString == null || decString == null) {
                throw new IOException("Failed to identify likely RA/Dec columns");
            }
            this.raExpr_ = this.compileDouble(raString);
            this.decExpr_ = this.compileDouble(decString);
            this.srExpr_ = this.compileDouble(srString);
        }

        @Override
        public double getRa() throws IOException {
            return this.doEvaluateDouble(this.raExpr_);
        }

        @Override
        public double getDec() throws IOException {
            return this.doEvaluateDouble(this.decExpr_);
        }

        @Override
        public double getRadius() throws IOException {
            return this.doEvaluateDouble(this.srExpr_);
        }

        @Override
        public long getIndex() {
            return this.getCurrentRow();
        }

        private CompiledExpression compileDouble(String sexpr) throws IOException {
            if (sexpr == null || "null".equals(sexpr) || sexpr.trim().length() == 0) {
                sexpr = "NULL";
            }
            try {
                return JELUtils.compile(this.lib_, this.getTable(), sexpr, Double.TYPE);
            }
            catch (CompilationException e) {
                throw new IOException("Bad numeric expression \"" + sexpr + "\" - " + e.getMessage());
            }
        }

        private double doEvaluateDouble(CompiledExpression expr) throws IOException {
            try {
                return this.evaluateDouble(expr);
            }
            catch (Throwable e) {
                throw new IOException("Evaluation error: " + expr);
            }
        }
    }
}

