/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.ttools.cone.ConeSearcher;
import uk.ac.starlink.ttools.cone.DalConeSearcher;
import uk.ac.starlink.vo.ConeSearch;

public class ServiceConeSearcher
extends DalConeSearcher
implements ConeSearcher {
    private final int verb_;
    private final ConeSearch csearch_;
    private final StarTableFactory tfact_;

    public ServiceConeSearcher(ConeSearch csearch, int verb, boolean believeEmpty, StarTableFactory tfact) {
        super("Cone Search", "1.02", believeEmpty);
        this.verb_ = verb;
        this.csearch_ = csearch;
        this.tfact_ = tfact;
    }

    @Override
    public StarTable performSearch(double ra, double dec, double sr) throws IOException {
        if (Double.isNaN(ra) || Double.isNaN(dec) || Double.isNaN(sr)) {
            return null;
        }
        StarTable table = this.csearch_.performSearch(ra, dec, sr, this.verb_, this.tfact_);
        return this.getConsistentTable(table);
    }

    @Override
    public int getRaIndex(StarTable result) {
        return this.getUcd1RaIndex(result);
    }

    @Override
    public int getDecIndex(StarTable result) {
        return this.getUcd1DecIndex(result);
    }

    @Override
    public void close() {
    }
}

