/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.ttools.cone.ConeSearcher;
import uk.ac.starlink.ttools.cone.DalConeSearcher;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.DalQuery;

public class SsaConeSearcher
extends DalConeSearcher
implements ConeSearcher {
    private final String serviceUrl_;
    private final String specFormat_;
    private final StarTableFactory tfact_;
    private final ContentCoding coding_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.cone");
    private static final Pattern RA_NAME_REGEX = Pattern.compile("RA_?J?(2000)?", 2);
    private static final Pattern DEC_NAME_REGEX = Pattern.compile("DEC?L?_?J?(2000)?", 2);

    public SsaConeSearcher(String serviceUrl, String specFormat, boolean believeEmpty, StarTableFactory tfact, ContentCoding coding) {
        super("SSA", "1.04", believeEmpty);
        this.serviceUrl_ = serviceUrl;
        this.specFormat_ = specFormat;
        this.tfact_ = tfact;
        this.coding_ = coding;
    }

    @Override
    public StarTable performSearch(double ra, double dec, double sr) throws IOException {
        DalQuery query = new DalQuery(this.serviceUrl_, "SSA", ra, dec, sr * 2.0, this.coding_);
        query.addArgument("REQUEST", "queryData");
        if (this.specFormat_ != null && this.specFormat_.trim().length() > 0) {
            query.addArgument("FORMAT", this.specFormat_);
        }
        StarTable table = query.execute(this.tfact_);
        table = this.getConsistentTable(table);
        return table;
    }

    @Override
    public int getRaIndex(StarTable result) {
        return SsaConeSearcher.guessPosColumn(result, "ra", RA_NAME_REGEX);
    }

    @Override
    public int getDecIndex(StarTable result) {
        return SsaConeSearcher.guessPosColumn(result, "dec", DEC_NAME_REGEX);
    }

    @Override
    public void close() {
    }

    private static int guessPosColumn(StarTable table, String ucdAtom, Pattern nameRegex) {
        boolean isDeg;
        ColumnInfo info;
        String atom = ucdAtom.toLowerCase();
        String ucd1Part = "pos_eq_" + atom;
        String ucd1Full = ucd1Part + "_main";
        String ucd1pPart = "pos.eq." + atom;
        String ucd1pFull = ucd1pPart + ";meta.main";
        int bestIndex = -1;
        int score = 0;
        int ncol = table.getColumnCount();
        for (int icol = 0; icol < ncol; ++icol) {
            info = table.getColumnInfo(icol);
            if (!Number.class.isAssignableFrom(info.getContentClass())) continue;
            String ucd = info.getUCD();
            String name = info.getName();
            if (ucd != null && ucd.length() > 0) {
                ucd = ucd.trim().toLowerCase();
                if (score < 20 && ucd.equals(ucd1pFull)) {
                    bestIndex = icol;
                    score = 20;
                }
                if (score < 18 && ucd.equals(ucd1Full)) {
                    bestIndex = icol;
                    score = 18;
                }
                if (score < 10 && ucd.equals(ucd1pPart)) {
                    bestIndex = icol;
                    score = 10;
                }
                if (score < 8 && ucd.equals(ucd1Part)) {
                    bestIndex = icol;
                    score = 8;
                }
            }
            if (name == null || name.length() <= 0 || score >= 5 || !nameRegex.matcher(name.trim()).matches()) continue;
            bestIndex = icol;
            score = 5;
        }
        if (bestIndex >= 0) {
            info = table.getColumnInfo(bestIndex);
            logger_.info("Identified column " + info + " as " + ucdAtom.toUpperCase());
            String units = info.getUnitString();
            if (units == null || units.trim().length() == 0) {
                logger_.info("No units listed for column " + info.getName() + " - assume degrees");
                isDeg = true;
            } else if (units.toLowerCase().startsWith("rad")) {
                logger_.warning("Uh-oh - column is in radians.  Forget it.");
                isDeg = false;
            } else if (units.toLowerCase().startsWith("deg")) {
                isDeg = true;
            } else {
                logger_.info("Units for column " + info.getName() + " listed as " + units + " - assume degrees");
                isDeg = true;
            }
        } else {
            isDeg = false;
        }
        if (isDeg && bestIndex >= 0) {
            return bestIndex;
        }
        logger_.warning("Can't identify " + ucdAtom.toUpperCase() + " column in degrees");
        return -1;
    }
}

