/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import cds.moc.SMoc;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.cone.MocCoverage;
import uk.ac.starlink.util.CgiQuery;

public class UrlMocCoverage
extends MocCoverage {
    private final URL mocUrl_;
    public static final String FOOT_SERVICE_URL = "http://alasky.u-strasbg.fr/footprints";
    private static final Map<String, SMoc> mocMap_ = new HashMap<String, SMoc>();
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.cone");

    public UrlMocCoverage(URL mocUrl) {
        this.mocUrl_ = mocUrl;
    }

    @Override
    protected SMoc createMoc() throws IOException {
        return UrlMocCoverage.getMoc(this.mocUrl_);
    }

    public static UrlMocCoverage getServiceMoc(URL serviceUrl, int nside) {
        CgiQuery query = new CgiQuery("http://alasky.u-strasbg.fr/footprints/getMoc");
        query.addArgument("baseUrl", serviceUrl.toString());
        if (nside >= 0) {
            query.addArgument("nside", (long)nside);
        }
        return new UrlMocCoverage(query.toURL());
    }

    public static UrlMocCoverage getVizierMoc(String vizierId, int nside) {
        String url = new StringBuffer().append(FOOT_SERVICE_URL).append("/cats/vizier/").append(vizierId.replaceAll(" ", "%20")).toString();
        CgiQuery query = new CgiQuery(url);
        query.addArgument("product", "MOC");
        if (nside >= 0) {
            query.addArgument("nside", (long)nside);
        }
        return new UrlMocCoverage(query.toURL());
    }

    private static synchronized SMoc getMoc(URL mocUrl) throws IOException {
        String urlKey = mocUrl.toString();
        if (!mocMap_.containsKey(urlKey)) {
            SMoc moc = null;
            try {
                moc = UrlMocCoverage.readMoc(mocUrl);
            }
            finally {
                mocMap_.put(urlKey, moc);
            }
        }
        return mocMap_.get(urlKey);
    }

    private static SMoc readMoc(URL mocUrl) throws IOException {
        logger_.info("Attempt to acquire MOC from " + mocUrl);
        URLConnection conn = mocUrl.openConnection();
        conn.connect();
        if (conn instanceof HttpURLConnection && ((HttpURLConnection)conn).getResponseCode() == 404) {
            logger_.info("No footprint information available");
            return null;
        }
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
        try {
            SMoc moc = new SMoc((InputStream)in);
            if (logger_.isLoggable(Level.INFO)) {
                logger_.info("Got MOC footprint: " + UrlMocCoverage.summariseMoc(moc));
            }
            SMoc sMoc = moc;
            return sMoc;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException("MOC read error").initCause(e);
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
        }
    }
}

