/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.convert;

import uk.ac.starlink.ttools.func.CoordsRadians;

public abstract class SkyUnits {
    public static final SkyUnits DEGREES = new DegreesUnits("degrees");
    public static final SkyUnits RADIANS = new RadiansUnits("radians");
    public static final SkyUnits SEXAGESIMAL = new SexagesimalUnits("sexagesimal", 1, 2);
    private static final SkyUnits[] KNOWN_UNITS = new SkyUnits[]{DEGREES, RADIANS, SEXAGESIMAL};
    public static final SkyUnits DEFAULT_UNIT = KNOWN_UNITS[0];
    private final String name_;

    protected SkyUnits(String name) {
        this.name_ = name;
    }

    public abstract double[] decode(Object var1, Object var2);

    public abstract Object[] encode(double var1, double var3);

    public abstract String[] getUnitStrings();

    public abstract Class<?>[] getUnitTypes();

    public String getName() {
        return this.name_;
    }

    public String toString() {
        return this.getName();
    }

    public static SkyUnits[] getKnownUnits() {
        return (SkyUnits[])KNOWN_UNITS.clone();
    }

    public static SkyUnits getUnitsFor(String unitName) {
        if (unitName == null || unitName.length() == 0) {
            return DEFAULT_UNIT;
        }
        if (unitName.matches("[Ss][Ee][Xx][a-zA-Z]*[0-9]+")) {
            String digits = unitName.replaceAll("[^0-9]*", "");
            int ndig = Integer.parseInt(digits);
            int hdp = Math.max(ndig - 1, 0);
            int ddp = Math.max(ndig, 0);
            return new SexagesimalUnits(unitName, hdp, ddp);
        }
        String lname = unitName.toLowerCase();
        for (int i = 0; i < KNOWN_UNITS.length; ++i) {
            SkyUnits unit = KNOWN_UNITS[i];
            if (!unit.getName().toLowerCase().startsWith(lname)) continue;
            return unit;
        }
        StringBuffer sbuf = new StringBuffer("Unknown unit: ").append(unitName).append("\nKnown units are: ");
        int nunit = KNOWN_UNITS.length;
        for (int i = 0; i < nunit; ++i) {
            sbuf.append(KNOWN_UNITS[i]);
            sbuf.append(i < nunit - 1 ? ", " : ".");
        }
        throw new IllegalArgumentException(sbuf.toString());
    }

    private static class SexagesimalUnits
    extends SkyUnits {
        private final int dPlaces_;
        private final int hPlaces_;

        public SexagesimalUnits(String name, int dPlaces, int hPlaces) {
            super(name);
            this.dPlaces_ = dPlaces;
            this.hPlaces_ = hPlaces;
        }

        @Override
        public String[] getUnitStrings() {
            return new String[]{"'hms'", "'dms'"};
        }

        @Override
        public Class<?>[] getUnitTypes() {
            return new Class[]{String.class, String.class};
        }

        @Override
        public double[] decode(Object c1, Object c2) {
            return new double[]{c1 instanceof String ? CoordsRadians.hmsToRadians((String)c1) : Double.NaN, c2 instanceof String ? CoordsRadians.dmsToRadians((String)c2) : Double.NaN};
        }

        @Override
        public Object[] encode(double c1, double c2) {
            return new Object[]{CoordsRadians.radiansToHms(c1, this.hPlaces_), CoordsRadians.radiansToDms(c2, this.dPlaces_)};
        }
    }

    private static class DegreesUnits
    extends SkyUnits {
        public DegreesUnits(String name) {
            super(name);
        }

        @Override
        public String[] getUnitStrings() {
            return new String[]{"deg", "deg"};
        }

        @Override
        public Class<?>[] getUnitTypes() {
            return new Class[]{Double.class, Double.class};
        }

        @Override
        public double[] decode(Object c1, Object c2) {
            return new double[]{c1 instanceof Number ? Math.toRadians(((Number)c1).doubleValue()) : Double.NaN, c2 instanceof Number ? Math.toRadians(((Number)c2).doubleValue()) : Double.NaN};
        }

        @Override
        public Object[] encode(double c1, double c2) {
            return new Object[]{Math.toDegrees(c1), Math.toDegrees(c2)};
        }
    }

    private static class RadiansUnits
    extends SkyUnits {
        RadiansUnits(String name) {
            super(name);
        }

        @Override
        public String[] getUnitStrings() {
            return new String[]{"rad", "rad"};
        }

        @Override
        public Class<?>[] getUnitTypes() {
            return new Class[]{Double.class, Double.class};
        }

        @Override
        public double[] decode(Object c1, Object c2) {
            return new double[]{c1 instanceof Number ? ((Number)c1).doubleValue() : Double.NaN, c2 instanceof Number ? ((Number)c2).doubleValue() : Double.NaN};
        }

        @Override
        public Object[] encode(double c1, double c2) {
            return new Object[]{c1, c2};
        }
    }
}

