/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.example;

import java.awt.Color;
import java.io.IOException;
import java.util.function.DoubleUnaryOperator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.example.PlotGenerator;
import uk.ac.starlink.ttools.example.SinePlot;
import uk.ac.starlink.ttools.plot.BarStyle;
import uk.ac.starlink.ttools.plot2.BasicCaptioner;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.ShadeAxisKit;
import uk.ac.starlink.ttools.plot2.Trimming;
import uk.ac.starlink.ttools.plot2.ZoneContent;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.SimpleDataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.TupleRunner;
import uk.ac.starlink.ttools.plot2.geom.OrientationPolicy;
import uk.ac.starlink.ttools.plot2.geom.PlaneAspect;
import uk.ac.starlink.ttools.plot2.geom.PlaneDataGeom;
import uk.ac.starlink.ttools.plot2.geom.PlaneNavigator;
import uk.ac.starlink.ttools.plot2.geom.PlanePlotType;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.SideFlags;
import uk.ac.starlink.ttools.plot2.layer.BinSizer;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.Cumulation;
import uk.ac.starlink.ttools.plot2.layer.HistogramPlotter;
import uk.ac.starlink.ttools.plot2.layer.MarkForm;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;
import uk.ac.starlink.ttools.plot2.layer.Normalisation;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.layer.ShapePlotter;
import uk.ac.starlink.ttools.plot2.layer.ShapeStyle;
import uk.ac.starlink.ttools.plot2.layer.Unit;
import uk.ac.starlink.ttools.plot2.paper.Compositor;
import uk.ac.starlink.ttools.plot2.paper.PaperTypeSelector;
import uk.ac.starlink.ttools.plot2.task.ColumnDataSpec;
import uk.ac.starlink.ttools.plot2.task.PlotDisplay;

public class ApiPlanePlotter
implements SinePlot.PlanePlotter {
    @Override
    public PlotDisplay<?, ?> createPlotComponent(StarTable table, boolean dataMayChange) throws InterruptedException, IOException {
        PlotGenerator<PlaneSurfaceFactory.Profile, PlaneAspect> plotGen = this.createPlotGenerator(table);
        Navigator<PlaneAspect> navigator = this.createPlaneNavigator();
        boolean surfaceAuxRange = false;
        boolean caching = !dataMayChange;
        return plotGen.createPlotDisplay(navigator, surfaceAuxRange, caching);
    }

    private PlotGenerator<PlaneSurfaceFactory.Profile, PlaneAspect> createPlotGenerator(StarTable table) throws IOException, InterruptedException {
        PlanePlotType plotType = PlanePlotType.getInstance();
        DataGeom geom = plotType.getPointDataGeoms()[0];
        PlaneSurfaceFactory surfFact = new PlaneSurfaceFactory();
        Scale xscale = Scale.LINEAR;
        Scale yscale = Scale.LINEAR;
        boolean xflip = false;
        boolean yflip = false;
        String xlabel = "X axis";
        String ylabel = "Y axis";
        DoubleUnaryOperator x2func = null;
        DoubleUnaryOperator y2func = null;
        String x2label = null;
        String y2label = null;
        BasicCaptioner captioner = new BasicCaptioner();
        SideFlags annotateFlags = SideFlags.ALL;
        double xyfactor = Double.NaN;
        double xcrowd = 1.0;
        double ycrowd = 1.0;
        OrientationPolicy orientpolicy = OrientationPolicy.HORIZONTAL;
        boolean minor = true;
        boolean shadow = true;
        Color gridColor = null;
        Color axlabelColor = Color.BLACK;
        PlaneSurfaceFactory.Profile profile = new PlaneSurfaceFactory.Profile(xscale, yscale, xflip, yflip, xlabel, ylabel, x2func, y2func, x2label, y2label, captioner, annotateFlags, xyfactor, xcrowd, ycrowd, orientpolicy, minor, shadow, gridColor, axlabelColor);
        double[] xlimits = new double[]{0.0, 1.0};
        double[] ylimits = new double[]{-1.2, 1.2};
        PlaneAspect aspect = new PlaneAspect(xlimits, ylimits);
        Trimming trimming = null;
        ShadeAxisKit shadeKit = null;
        PlotLayer[] layers = new PlotLayer[]{this.createScatterLayer(geom, table)};
        ZoneContent<PlaneSurfaceFactory.Profile, PlaneAspect> content = new ZoneContent<PlaneSurfaceFactory.Profile, PlaneAspect>(profile, aspect, layers);
        int nl = layers.length;
        DataSpec[] dataSpecs = new DataSpec[nl];
        for (int il = 0; il < nl; ++il) {
            dataSpecs[il] = layers[il].getDataSpec();
        }
        TupleRunner tupleRunner = TupleRunner.DEFAULT;
        SimpleDataStoreFactory storeFact = new SimpleDataStoreFactory(tupleRunner);
        DataStore dataStore = storeFact.readDataStore(dataSpecs, null);
        Compositor compositor = Compositor.SATURATION;
        PaperTypeSelector ptSel = plotType.getPaperTypeSelector();
        int xpix = 500;
        int ypix = 400;
        Padding padding = new Padding();
        return new PlotGenerator<PlaneSurfaceFactory.Profile, PlaneAspect>(surfFact, content, trimming, shadeKit, ptSel, compositor, dataStore, xpix, ypix, padding);
    }

    private Navigator<PlaneAspect> createPlaneNavigator() {
        double zoomFactor = StyleKeys.ZOOM_FACTOR.getDefaultValue();
        boolean xZoom = true;
        boolean yZoom = true;
        boolean xPan = true;
        boolean yPan = true;
        double xAnchor = Double.NaN;
        double yAnchor = Double.NaN;
        return new PlaneNavigator(zoomFactor, xZoom, yZoom, xPan, yPan, xAnchor, yAnchor);
    }

    private PlotLayer createScatterLayer(DataGeom geom, StarTable table) {
        ColumnDataSpec dataSpec = new ColumnDataSpec(table, geom.getPosCoords(), new int[][]{{0}, {1}});
        MarkerShape shape = MarkerShape.OPEN_CIRCLE;
        int size = 2;
        Outliner outliner = MarkForm.createMarkOutliner(shape, size);
        ShapeMode.FlatStamper stamper = new ShapeMode.FlatStamper(Color.RED);
        ShapeStyle style = new ShapeStyle(outliner, stamper);
        ShapePlotter plotter = ShapePlotter.createFlat2dPlotter(MarkForm.SINGLE);
        return plotter.createLayer(geom, (DataSpec)dataSpec, style);
    }

    private PlotLayer createHistogramLayer(DataGeom geom, StarTable table) {
        ColumnDataSpec dataSpec = new ColumnDataSpec(table, new Coord[]{PlaneDataGeom.X_COORD}, new int[][]{{1}});
        Color color = Color.BLUE;
        BarStyle.Form barForm = BarStyle.FORM_OPEN;
        BarStyle.Placement placement = BarStyle.PLACE_ADJACENT;
        Cumulation cumulative = Cumulation.NONE;
        Normalisation norm = Normalisation.NONE;
        Unit unit = Unit.UNIT;
        int thick = 1;
        float[] dash = null;
        BinSizer sizer = BinSizer.createCountBinSizer(16.0);
        double phase = 0.0;
        Combiner combiner = Combiner.SUM;
        boolean isY = false;
        HistogramPlotter.HistoStyle style = new HistogramPlotter.HistoStyle(color, barForm, placement, cumulative, norm, unit, thick, dash, sizer, phase, combiner, isY);
        HistogramPlotter plotter = new HistogramPlotter(PlaneDataGeom.X_COORD, false, null);
        return plotter.createLayer(geom, (DataSpec)dataSpec, style);
    }
}

