/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.example;

import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.GraphicExporter;
import uk.ac.starlink.ttools.plot.Picture;
import uk.ac.starlink.ttools.plot2.Ganger;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.PlotCaching;
import uk.ac.starlink.ttools.plot2.PlotScene;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ShadeAxisKit;
import uk.ac.starlink.ttools.plot2.SingleGangerFactory;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.Trimming;
import uk.ac.starlink.ttools.plot2.ZoneContent;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.paper.Compositor;
import uk.ac.starlink.ttools.plot2.paper.PaperTypeSelector;
import uk.ac.starlink.ttools.plot2.task.AbstractPlot2Task;
import uk.ac.starlink.ttools.plot2.task.PlotDisplay;

public class PlotGenerator<P, A> {
    private final SurfaceFactory<P, A> surfFact_;
    private final ZoneContent<P, A> content_;
    private final Trimming trimming_;
    private final ShadeAxisKit shadeKit_;
    private final PaperTypeSelector ptSel_;
    private final Compositor compositor_;
    private final DataStore dataStore_;
    private final int xpix_;
    private final int ypix_;
    private final Padding padding_;

    public PlotGenerator(SurfaceFactory<P, A> surfFact, ZoneContent<P, A> content, Trimming trimming, ShadeAxisKit shadeKit, PaperTypeSelector ptSel, Compositor compositor, DataStore dataStore, int xpix, int ypix, Padding padding) {
        this.surfFact_ = surfFact;
        this.content_ = content;
        this.trimming_ = trimming;
        this.shadeKit_ = shadeKit;
        this.ptSel_ = ptSel;
        this.compositor_ = compositor;
        this.dataStore_ = dataStore;
        this.xpix_ = xpix;
        this.ypix_ = ypix;
        this.padding_ = padding;
    }

    public PlotDisplay<P, A> createPlotDisplay(Navigator<A> navigator, boolean surfaceAuxRange, boolean cacheImage) {
        PlotCaching cachePolicy = new PlotCaching();
        cachePolicy.setReuseRanges(!surfaceAuxRange);
        cachePolicy.setCacheImage(cacheImage);
        cachePolicy.setUsePlans(true);
        PlotScene<P, A> scene = new PlotScene<P, A>(this.surfFact_, this.content_, this.trimming_, this.shadeKit_, this.ptSel_, this.compositor_, this.padding_, cachePolicy);
        PlotDisplay<P, A> display = new PlotDisplay<P, A>(scene, navigator, this.dataStore_);
        display.setPreferredSize(new Dimension(this.xpix_, this.ypix_));
        return display;
    }

    public void exportPlot(GraphicExporter exporter, OutputStream out) throws IOException {
        boolean forceBitmap = false;
        Picture pic = PlotUtil.toPicture(this.createIcon(forceBitmap));
        BufferedOutputStream bufOut = new BufferedOutputStream(out);
        exporter.exportGraphic(pic, bufOut);
        ((OutputStream)bufOut).flush();
    }

    public Icon createIcon(boolean forceBitmap) {
        Ganger ganger = SingleGangerFactory.createGanger(this.padding_);
        return AbstractPlot2Task.createPlotIcon(ganger, this.surfFact_, PlotUtil.singletonArray(this.content_), new Trimming[]{this.trimming_}, new ShadeAxisKit[]{this.shadeKit_}, this.ptSel_, this.compositor_, this.dataStore_, this.xpix_, this.ypix_, forceBitmap);
    }
}

