/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.function.Function;
import java.util.function.LongSupplier;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.MappingRowSplittable;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowData;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.SequentialRowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.filter.ColumnSupplement;
import uk.ac.starlink.ttools.filter.SupplementData;

public class AddColumnsTable
extends WrapperStarTable {
    private final StarTable baseTable_;
    private final ColumnSupplement colSup_;
    private final int ncol_;
    private final boolean[] jtabs_;
    private final int[] jcols_;

    public AddColumnsTable(StarTable baseTable, ColumnSupplement colSup, int ipos) {
        super(baseTable);
        this.baseTable_ = baseTable;
        this.colSup_ = colSup;
        int nc0 = this.baseTable_.getColumnCount();
        int nc1 = this.colSup_.getColumnCount();
        this.ncol_ = nc0 + nc1;
        this.jtabs_ = new boolean[this.ncol_];
        this.jcols_ = new int[this.ncol_];
        for (int ic = 0; ic < this.ncol_; ++ic) {
            int jcol;
            boolean jtab;
            int ic1 = ic - ipos;
            if (ic1 < 0) {
                jtab = false;
                jcol = ic;
            } else if (ic1 >= nc1) {
                jtab = false;
                jcol = ic - nc1;
            } else {
                jtab = true;
                jcol = ic1;
            }
            this.jcols_[ic] = jcol;
            this.jtabs_[ic] = jtab;
        }
    }

    public AddColumnsTable(StarTable baseTable, ColumnSupplement colSup) {
        this(baseTable, colSup, baseTable.getColumnCount());
    }

    public int getColumnCount() {
        return this.jcols_.length;
    }

    public ColumnInfo getColumnInfo(int icol) {
        int jcol = this.jcols_[icol];
        return this.jtabs_[icol] ? this.colSup_.getColumnInfo(jcol) : this.baseTable_.getColumnInfo(jcol);
    }

    public Object getCell(long irow, int icol) throws IOException {
        int jcol = this.jcols_[icol];
        return this.jtabs_[icol] ? this.colSup_.getCell(irow, jcol) : this.baseTable_.getCell(irow, jcol);
    }

    public Object[] getRow(long irow) throws IOException {
        return this.combineRows(this.baseTable_.getRow(irow), this.colSup_.getRow(irow));
    }

    private Object[] combineRows(Object[] row0, Object[] row1) {
        assert (row0.length + row1.length == this.ncol_);
        Object[] row = new Object[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            row[icol] = (this.jtabs_[icol] ? row1 : row0)[this.jcols_[icol]];
        }
        return row;
    }

    public RowSequence getRowSequence() throws IOException {
        final RowSequence baseSeq = this.baseTable_.getRowSequence();
        final SupplementData supData = this.colSup_.createSupplementData((RowData)baseSeq);
        return new RowSequence(){
            long lrow_ = -1L;

            public boolean next() throws IOException {
                if (baseSeq.next()) {
                    ++this.lrow_;
                    return true;
                }
                return false;
            }

            public Object getCell(int icol) throws IOException {
                if (this.lrow_ >= 0L) {
                    int jcol = AddColumnsTable.this.jcols_[icol];
                    return AddColumnsTable.this.jtabs_[icol] ? supData.getCell(this.lrow_, jcol) : baseSeq.getCell(jcol);
                }
                throw new IllegalStateException();
            }

            public Object[] getRow() throws IOException {
                return AddColumnsTable.this.combineRows(baseSeq.getRow(), supData.getRow(this.lrow_));
            }

            public void close() throws IOException {
                baseSeq.close();
            }
        };
    }

    public RowAccess getRowAccess() throws IOException {
        if (this.isRandom()) {
            final RowAccess baseAcc = this.baseTable_.getRowAccess();
            final SupplementData sup = this.colSup_.createSupplementData((RowData)baseAcc);
            return new RowAccess(){
                long irow_ = -1L;

                public void setRowIndex(long irow) throws IOException {
                    this.irow_ = irow;
                    baseAcc.setRowIndex(irow);
                }

                public Object getCell(int icol) throws IOException {
                    int jcol = AddColumnsTable.this.jcols_[icol];
                    return AddColumnsTable.this.jtabs_[icol] ? sup.getCell(this.irow_, jcol) : baseAcc.getCell(jcol);
                }

                public Object[] getRow() throws IOException {
                    return AddColumnsTable.this.combineRows(baseAcc.getRow(), sup.getRow(this.irow_));
                }

                public void close() throws IOException {
                    baseAcc.close();
                }
            };
        }
        throw new UnsupportedOperationException("Not random");
    }

    public RowSplittable getRowSplittable() throws IOException {
        RowSplittable baseSplittable = this.baseTable.getRowSplittable();
        if (baseSplittable.rowIndex() == null) {
            return new SequentialRowSplittable((StarTable)this);
        }
        Function<RowSplittable, RowData> mapper = base -> new RowData((RowSplittable)base){
            final SupplementData sup;
            final LongSupplier rowIndex;
            final /* synthetic */ RowSplittable val$base;
            {
                this.val$base = rowSplittable;
                this.rowIndex = this.val$base.rowIndex();
                try {
                    this.sup = AddColumnsTable.this.colSup_.createSupplementData((RowData)this.val$base);
                }
                catch (IOException e) {
                    throw new RuntimeException("shouldn't happen");
                }
            }

            public Object getCell(int icol) throws IOException {
                int jcol = AddColumnsTable.this.jcols_[icol];
                return AddColumnsTable.this.jtabs_[icol] ? this.sup.getCell(this.rowIndex.getAsLong(), jcol) : this.val$base.getCell(jcol);
            }

            public Object[] getRow() throws IOException {
                return AddColumnsTable.this.combineRows(this.val$base.getRow(), this.sup.getRow(this.rowIndex.getAsLong()));
            }
        };
        return new MappingRowSplittable(baseSplittable, mapper);
    }
}

