/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ArrayReader {
    private final LengthReader lrdr_;
    private final ValueReader vrdr_;
    private static final ArrayReader DOUBLE = new ArrayReader(a -> a instanceof double[] ? ((double[])a).length : -1, (a, i) -> a instanceof double[] ? ((double[])a)[i] : Double.NaN);
    private static final ArrayReader FLOAT = new ArrayReader(a -> a instanceof float[] ? ((float[])a).length : -1, (a, i) -> a instanceof float[] ? (double)((float[])a)[i] : Double.NaN);
    private static final ArrayReader LONG = new ArrayReader(a -> a instanceof long[] ? ((long[])a).length : -1, (a, i) -> a instanceof long[] ? (double)((long[])a)[i] : Double.NaN);
    private static final ArrayReader INT = new ArrayReader(a -> a instanceof int[] ? ((int[])a).length : -1, (a, i) -> a instanceof int[] ? (double)((int[])a)[i] : Double.NaN);
    private static final ArrayReader SHORT = new ArrayReader(a -> a instanceof short[] ? ((short[])a).length : -1, (a, i) -> a instanceof short[] ? (double)((short[])a)[i] : Double.NaN);
    private static final ArrayReader BYTE = new ArrayReader(a -> a instanceof byte[] ? ((byte[])a).length : -1, (a, i) -> a instanceof byte[] ? (double)((byte[])a)[i] : Double.NaN);
    private static final Map<Class<?>, ArrayReader> READERS = ArrayReader.createReaderMap();

    private ArrayReader(LengthReader lrdr, ValueReader vrdr) {
        this.lrdr_ = lrdr;
        this.vrdr_ = vrdr;
    }

    public int getLength(Object array) {
        return this.lrdr_.getLength(array);
    }

    public double getValue(Object array, int index) {
        return this.vrdr_.getValue(array, index);
    }

    public static ArrayReader forClass(Class<?> arrayClazz) {
        return READERS.get(arrayClazz);
    }

    private static Map<Class<?>, ArrayReader> createReaderMap() {
        HashMap<Class<byte[]>, ArrayReader> map = new HashMap<Class<byte[]>, ArrayReader>();
        map.put(double[].class, DOUBLE);
        map.put(float[].class, FLOAT);
        map.put(int[].class, INT);
        map.put(short[].class, SHORT);
        map.put(byte[].class, BYTE);
        return Collections.unmodifiableMap(map);
    }

    @FunctionalInterface
    private static interface ValueReader {
        public double getValue(Object var1, int var2);
    }

    @FunctionalInterface
    private static interface LengthReader {
        public int getLength(Object var1);
    }
}

