/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.util.Iterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.EveryTable;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class EveryFilter
extends BasicFilter {
    public EveryFilter() {
        super("every", "[-exact|-approx] <step>");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Include only every <code>&lt;step&gt;</code>'th row in the", "result, starting with the first row.", "The optional <code>-approx</code>/<code>-exact</code> argument", "controls whether the selection needs to be exact;", "in some cases an approximate calculation can take advantage", "of parallelism where an exact one cannot.", "</p>", "<p>The <code>&lt;step&gt;</code> argument", " may be given as a plain integer (<code>1000</code>),\nor with embedded underscores (<code>1_000</code>),\nor in exponential format (<code>1e3</code>).", "</p>"};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) throws ArgException {
        long count;
        String countStr = null;
        boolean isExact = true;
        while (argIt.hasNext() && countStr == null) {
            String arg = argIt.next();
            if (arg.equals("-exact")) {
                argIt.remove();
                isExact = true;
                continue;
            }
            if (arg.startsWith("-approx")) {
                argIt.remove();
                isExact = false;
                continue;
            }
            if (arg.startsWith("-")) {
                argIt.remove();
                throw new ArgException("Unknown flag " + arg);
            }
            argIt.remove();
            countStr = arg;
        }
        if (countStr == null) {
            throw new ArgException("No step given");
        }
        try {
            count = Tables.parseCount(countStr);
        }
        catch (NumberFormatException e) {
            throw new ArgException("Step value " + countStr + " not numeric");
        }
        assert (count >= 0L);
        return new EveryStep(count, isExact);
    }

    private static class EveryStep
    implements ProcessingStep {
        final long count_;
        final boolean isExact_;

        EveryStep(long count, boolean isExact) {
            this.count_ = count;
            this.isExact_ = isExact;
        }

        @Override
        public StarTable wrap(StarTable base) {
            return new EveryTable(base, this.count_, this.isExact_);
        }
    }
}

