/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ExplodedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class ExplodeAllFilter
extends BasicFilter {
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.filter");

    public ExplodeAllFilter() {
        super("explodeall", "[-ifndim <ndim>] [-ifshape <dims>]");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Replaces any columns which is an N-element arrays with", "N scalar columns.", "Only columns with fixed array sizes are affected.", "The action can be restricted to only columns of a certain", "shape using the flags.", "</p>", "<p>If the <code>-ifndim</code> flag is used, then only columns", "of dimensionality <code>&lt;ndim&gt;</code> will be exploded.", "<code>&lt;ndim&gt;</code> may be 1, 2, ....", "</p>", "<p>If the <code>-ifshape</code> flag is used, then only columns", "with a specific shape will be exploded;", "<code>&lt;dims&gt;</code> is a space- or comma-separated list", "of dimension extents, with the most rapidly-varying first,", "e.g. '<code>2 5</code>' to explode all 2 x 5 element array", "columns.", "</p>"};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) throws ArgException {
        int ndim = -1;
        int[] shape = null;
        while (argIt.hasNext()) {
            String txt;
            String arg = argIt.next();
            if ("-ifndim".equals(arg) && ndim < 0 && argIt.hasNext()) {
                argIt.remove();
                txt = argIt.next();
                argIt.remove();
                try {
                    ndim = Integer.parseInt(txt);
                    if (ndim >= 1) continue;
                    throw new ArgException(txt + " not positive");
                }
                catch (NumberFormatException e) {
                    throw new ArgException(txt + " not an integer", e);
                }
            }
            if (!"-ifshape".equals(arg) || shape != null || !argIt.hasNext()) continue;
            argIt.remove();
            txt = argIt.next();
            argIt.remove();
            try {
                String[] txts = txt.split("( +|,)");
                shape = new int[txts.length];
                for (int i = 0; i < txts.length; ++i) {
                    shape[i] = Integer.parseInt(txts[i]);
                    if (shape[i] >= 1) continue;
                    throw new IllegalArgumentException(txts[i] + " is negative");
                }
            }
            catch (RuntimeException e) {
                throw new ArgException("\"" + txt + "\" not a space- or comma-separated list of positive integers", e);
            }
        }
        final int reqNdim = ndim;
        final int[] reqShape = shape;
        return new ProcessingStep(){

            @Override
            public StarTable wrap(StarTable base) {
                int ncol = base.getColumnCount();
                boolean[] explodes = new boolean[ncol];
                int nexplode = 0;
                for (int icol = 0; icol < ncol; ++icol) {
                    boolean explode;
                    ColumnInfo info = base.getColumnInfo(icol);
                    if (info.isArray()) {
                        int[] shape = info.getShape();
                        boolean bl = explode = shape != null;
                        if (shape != null) {
                            if (shape.length == 0 || shape[shape.length - 1] < 0) {
                                explode = false;
                            }
                            if (reqNdim >= 0) {
                                boolean bl2 = explode = explode && shape.length == reqNdim;
                            }
                            if (reqShape != null) {
                                explode = explode && Arrays.equals(shape, reqShape);
                            }
                        }
                    } else {
                        explode = false;
                    }
                    explodes[icol] = explode;
                    if (!explodes[icol]) continue;
                    ++nexplode;
                }
                logger_.info("Exploding " + nexplode + "/" + ncol + " columns");
                return new ExplodedStarTable(base, explodes);
            }
        };
    }
}

