/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.ExplodedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;

public class ExplodeColsFilter
extends BasicFilter {
    public ExplodeColsFilter() {
        super("explodecols", "<colid-list>");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Takes a list of specified columns which represent N-element", "arrays and replaces each one with N scalar columns.", "Each of the columns specified by <code>&lt;colid-list&gt;</code>", "must have a fixed-length array type,", "though not all the arrays need to have the same number", "of elements.", "</p>", "<p>This filter does the opposite of", "<ref id='collapsecols'><code>collapsecols</code></ref>.", "</p>", ExplodeColsFilter.explainSyntax(new String[]{"colid-list"})};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) throws ArgException {
        if (argIt.hasNext()) {
            final String colIdList = argIt.next();
            argIt.remove();
            return new ProcessingStep(){

                @Override
                public StarTable wrap(StarTable base) throws IOException {
                    boolean[] colFlags = new ColumnIdentifier(base).getColumnFlags(colIdList);
                    try {
                        return new ExplodedStarTable(base, colFlags);
                    }
                    catch (IllegalArgumentException e) {
                        throw (IOException)new IOException(e.getMessage()).initCause(e);
                    }
                }
            };
        }
        throw new ArgException("Missing column list");
    }
}

