/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class FixNamesFilter
extends BasicFilter
implements ProcessingStep {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.filter");

    public FixNamesFilter() {
        super("fixcolnames", "");
    }

    @Override
    public String[] getDescriptionLines() {
        return new String[]{"<p>Renames all columns and parameters in the input table", "so that they have names which have convenient syntax for STILTS.", "For the most part this means replacing spaces and other", "non-alphanumeric characters with underscores.", "This is a convenience which lets you use column names in", "algebraic expressions and other STILTS syntax.", "</p>", "<p>Additionally, column names are adjusted if necessary to ensure", "that they are all unique when compared case-insensitively.", "If the names are all unique to start with", "then no changes are made,", "but if for instance two columns exist with names", "<code>gMag</code> and <code>GMag</code>,", "one of them will be altered", "(for instance to <code>GMag_1</code>).", "</p>"};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) {
        return this;
    }

    @Override
    public StarTable wrap(StarTable base) {
        return new FixNamesTable(base);
    }

    public String fixName(String name) {
        if (name == null || name.trim().length() == 0) {
            return "_unnamed_";
        }
        name = name.trim();
        StringBuffer sbuf = new StringBuffer(name.length());
        for (int ic = 0; ic < name.length(); ++ic) {
            char ch = name.charAt(ic);
            sbuf.append((ic == 0 ? Character.isJavaIdentifierStart(ch) : Character.isJavaIdentifierPart(ch)) ? (char)ch : (char)'_');
        }
        return sbuf.toString();
    }

    public String uniqueName(String name, Set<String> lcNames) {
        if (!lcNames.contains(name.toLowerCase())) {
            return name;
        }
        for (int i = 1; i > 0; ++i) {
            String name1 = name + "_" + i;
            if (lcNames.contains(name1.toLowerCase())) continue;
            return name1;
        }
        assert (false);
        return "???";
    }

    private class FixNamesTable
    extends WrapperStarTable {
        private final ColumnInfo[] colInfos_;
        private final List<DescribedValue> paramList_;

        FixNamesTable(StarTable base) {
            super(base);
            int ncol = base.getColumnCount();
            this.colInfos_ = new ColumnInfo[ncol];
            HashSet<String> lcNames = new HashSet<String>();
            for (int icol = 0; icol < ncol; ++icol) {
                ColumnInfo info = new ColumnInfo((ValueInfo)base.getColumnInfo(icol));
                String name = info.getName();
                String fixName = FixNamesFilter.this.uniqueName(FixNamesFilter.this.fixName(name), lcNames);
                if (!fixName.equals(name)) {
                    info.setName(fixName);
                    String msg = new StringBuffer().append("Rename column #").append(icol + 1).append(" ").append(name).append(" -> ").append(fixName).toString();
                    logger_.info(msg);
                }
                lcNames.add(fixName.toLowerCase());
                this.colInfos_[icol] = info;
            }
            assert (lcNames.size() == ncol);
            this.paramList_ = new ArrayList<DescribedValue>();
            for (DescribedValue param : base.getParameters()) {
                DefaultValueInfo info = new DefaultValueInfo(param.getInfo());
                info.setName(FixNamesFilter.this.fixName(info.getName()));
                this.paramList_.add(new DescribedValue((ValueInfo)info, param.getValue()));
            }
        }

        public ColumnInfo getColumnInfo(int icol) {
            return this.colInfos_[icol];
        }

        public List<DescribedValue> getParameters() {
            return this.paramList_;
        }

        public DescribedValue getParameterByName(String parName) {
            for (DescribedValue param : this.paramList_) {
                if (!param.getInfo().getName().equals(parName)) continue;
                return param;
            }
            return null;
        }

        public void setParameter(DescribedValue dval) {
            this.paramList_.remove(this.getParameterByName(dval.getInfo().getName()));
            this.paramList_.add(dval);
        }
    }
}

