/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.IOException;
import java.util.function.LongSupplier;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.SequentialRowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.jel.DummyJELRowReader;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.SequentialJELRowReader;
import uk.ac.starlink.ttools.jel.StarTableJELRowReader;

public class JELSelectorTable
extends WrapperStarTable {
    private final String expr_;
    private final boolean requiresRowIndex_;
    private final StarTable baseTable_;

    public JELSelectorTable(StarTable baseTable, String expr) throws CompilationException {
        super(baseTable);
        this.baseTable_ = baseTable;
        this.expr_ = expr;
        DummyJELRowReader rdr = new DummyJELRowReader(baseTable);
        Library lib = JELUtils.getLibrary(rdr);
        JELUtils.checkExpressionType(lib, baseTable, expr, Boolean.TYPE);
        this.requiresRowIndex_ = rdr.requiresRowIndex();
    }

    public boolean isRandom() {
        return false;
    }

    public long getRowCount() {
        return -1L;
    }

    public Object getCell(long irow, int icol) {
        throw new UnsupportedOperationException("Not random");
    }

    public Object[] getRow(long irow) {
        throw new UnsupportedOperationException("Not random");
    }

    public RowAccess getRowAccess() {
        throw new UnsupportedOperationException("Not random");
    }

    public RowSequence getRowSequence() throws IOException {
        CompiledExpression compEx;
        final SequentialJELRowReader jelSeq = new SequentialJELRowReader(this.baseTable_);
        try {
            compEx = JELUtils.compile(JELUtils.getLibrary(jelSeq), this.baseTable_, this.expr_, Boolean.TYPE);
        }
        catch (CompilationException e) {
            throw JELUtils.toIOException(e, this.expr_);
        }
        assert (compEx.getType() == 0);
        return new WrapperRowSequence(jelSeq){

            public boolean next() throws IOException {
                while (jelSeq.next()) {
                    if (!JELSelectorTable.isIncluded(jelSeq, compEx)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public RowSplittable getRowSplittable() throws IOException {
        return this.requiresRowIndex_ ? new SequentialRowSplittable((StarTable)this) : new JELSelectorRowSplittable(this.baseTable_.getRowSplittable());
    }

    private static boolean isIncluded(StarTableJELRowReader rdr, CompiledExpression compEx) throws IOException {
        try {
            return rdr.evaluateBoolean(compEx);
        }
        catch (Throwable e) {
            throw new IOException("Evaluation error", e);
        }
    }

    private class JELSelectorRowSplittable
    extends WrapperRowSequence
    implements RowSplittable {
        final RowSplittable baseSplittable_;
        final SequentialJELRowReader rdr_;
        final CompiledExpression compEx_;

        JELSelectorRowSplittable(RowSplittable baseSplittable) throws IOException {
            super((RowSequence)baseSplittable);
            this.baseSplittable_ = baseSplittable;
            this.rdr_ = new SequentialJELRowReader((StarTable)JELSelectorTable.this, baseSplittable);
            try {
                this.compEx_ = JELUtils.compile(JELUtils.getLibrary(this.rdr_), JELSelectorTable.this.baseTable_, JELSelectorTable.this.expr_, Boolean.TYPE);
            }
            catch (CompilationException e) {
                throw JELUtils.toIOException(e, JELSelectorTable.this.expr_);
            }
        }

        public RowSplittable split() {
            RowSplittable spl = (RowSplittable)this.baseSplittable_.split();
            if (spl == null) {
                return null;
            }
            try {
                return new JELSelectorRowSplittable(spl);
            }
            catch (IOException e) {
                return null;
            }
        }

        public LongSupplier rowIndex() {
            return null;
        }

        public long splittableSize() {
            return this.baseSplittable_.splittableSize();
        }

        public boolean next() throws IOException {
            while (super.next()) {
                if (!JELSelectorTable.isIncluded(this.rdr_, this.compEx_)) continue;
                return true;
            }
            return false;
        }
    }
}

