/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.filter.RepeatTable;
import uk.ac.starlink.ttools.jel.JELRowReader;
import uk.ac.starlink.ttools.jel.JELUtils;

public class RepeatFilter
extends BasicFilter {
    public RepeatFilter() {
        super("repeat", "[-row|-table] <count>");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Repeats the rows of a table multiple times to produce", "a longer table.", "The output table will have <code>&lt;count&gt;</code> times", "as many rows as the input table.", "</p>", "<p>The optional flag determines the sequence of the output rows.", "If <code>&lt;count&gt;</code>=2 and there are three rows,", "the output sequence will be 112233 for <code>-row</code>", "and 123123 for <code>-table</code>.", "The default behaviour is currently <code>-table</code>.", "</p>", "<p>The <code>&lt;count&gt;</code> value will usually", "be a constant integer value, but it can be an expression", "evaluated in the context of the table,", "for instance <code>1000000/$nrow</code>.", "If it's a constant, it may be given as a plain integer (<code>1000</code>),\nor with embedded underscores (<code>1_000</code>),\nor in exponential format (<code>1e3</code>).", "</p>"};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) throws ArgException {
        boolean byrow = false;
        String countStr = null;
        while (argIt.hasNext() && countStr == null) {
            String arg = argIt.next();
            if (arg.equals("-row")) {
                argIt.remove();
                byrow = true;
                continue;
            }
            if (arg.equals("-table")) {
                argIt.remove();
                byrow = false;
                continue;
            }
            if (arg.startsWith("-")) {
                argIt.remove();
                throw new ArgException("Unknown flag " + arg);
            }
            argIt.remove();
            countStr = arg;
        }
        if (countStr == null) {
            throw new ArgException("No count given");
        }
        final String countStr0 = countStr;
        final boolean byrow0 = byrow;
        return new ProcessingStep(){

            @Override
            public StarTable wrap(StarTable base) throws IOException {
                long count = RepeatFilter.this.getCount(countStr0, base);
                return new RepeatTable(base, count, byrow0);
            }
        };
    }

    private long getCount(String countExpr, StarTable table) throws IOException {
        try {
            return Tables.parseCount((String)countExpr);
        }
        catch (NumberFormatException numberFormatException) {
            Object countObj;
            CompiledExpression compex;
            JELRowReader rdr = JELUtils.createDatalessRowReader(table);
            Library lib = JELUtils.getLibrary(rdr);
            String qexpr = "\"" + countExpr + "\"";
            try {
                compex = Evaluator.compile(countExpr, lib, Long.TYPE);
            }
            catch (CompilationException e) {
                throw (IOException)new IOException("Bad expression " + qexpr + ": " + e.getMessage()).initCause(e);
            }
            try {
                countObj = rdr.evaluate(compex);
            }
            catch (Throwable e) {
                throw (IOException)new IOException("Evaluation error for " + qexpr).initCause(e);
            }
            if (countObj instanceof Number) {
                long count = ((Number)countObj).longValue();
                if (count >= 0L) {
                    return count;
                }
                throw new IOException("Count " + count + " is negative");
            }
            assert (false) : "Should be a long!";
            throw new IOException("Not numeric " + qexpr);
        }
    }
}

